<?php
/**
 * Single Post Table Of Contents
 * 
 * @package Botiga_Pro
 */
if ( class_exists( 'Botiga_Modules' ) && ! Botiga_Modules::is_module_active( 'table-of-contents' ) ) {
    return;
}

/**
 * Single Post Table Of Contents Metabox
 */
require BOTIGA_PRO_DIR . 'inc/modules/table-of-contents/table-of-contents-metabox.php';

/**
 * Enqueue css and js
 */
function botiga_single_post_toc_enqueue_scripts() {

    if( ! is_singular( 'post' ) ) {
        return;
    }

    global $post;

    wp_enqueue_style( 'botiga-single-post-toc', BOTIGA_PRO_URI . 'assets/css/botiga-single-post-toc.min.css', array(), BOTIGA_PRO_VERSION );

    if( get_post_meta( $post->ID, '_botiga_toc_sticky', true ) ) {
        wp_enqueue_script( 'botiga-single-post-toc', BOTIGA_PRO_URI . 'assets/js/botiga-single-post-toc.min.js', array(), BOTIGA_PRO_VERSION, true );
    }
}
add_action( 'wp_enqueue_scripts', 'botiga_single_post_toc_enqueue_scripts', 10 );

/**
 * Modify content
 */
function botiga_single_post_toc_post_content() {

    if( ! is_singular( 'post' ) ) {
        return;
    }

    global $post;
    $enable_toc = get_post_meta( $post->ID, '_botiga_enable_toc', true );

    if( ! $enable_toc ) {
        return;
    }

    // TOC Options
    $toc_heading_tag       = get_post_meta( $post->ID, '_botiga_toc_heading_tag', true );
    $toc_sticky            = get_post_meta( $post->ID, '_botiga_toc_sticky', true );
    $toc_title             = get_post_meta( $post->ID, '_botiga_toc_title', true );
    $toc_list_style        = get_post_meta( $post->ID, '_botiga_toc_list_style', true );
    $toc_target_offset_top = get_post_meta( $post->ID, '_botiga_toc_target_offset_top', true );
    $toc_is_hierarchical   = $toc_heading_tag === 'all' ? true : false;

    if( is_user_logged_in() ) {
        $toc_target_offset_top = $toc_target_offset_top + 32;       
    }

    $regex_pattern = '/<'. $toc_heading_tag .'*[^>]+>(.*)<\/'. $toc_heading_tag .'+>/';
    if( $toc_is_hierarchical ) {
        $regex_pattern = '/<h1*[^>]+>(.*)<\/h1+>|<h2*[^>]+>(.*)<\/h2+>|<h3*[^>]+>(.*)<\/h3+>|<h4*[^>]+>(.*)<\/h4+>|<h5*[^>]+>(.*)<\/h5+>|<h6*[^>]+>(.*)<\/h6+>/';
    }

    // Get all toc headings from post content
    preg_match_all( $regex_pattern, $post->post_content, $headings );
    
    if( ! empty( $headings[0] ) ) {
        $to_replace = array(
            'search' => array(),
            'replace' => array()
        );
        $list_items_output = $offset_css = '';

        // Loop through each found heading
        foreach( $headings[0] as $key => $match ) {

            // Toc ignore
            if( strpos( $match, 'toc-ignore' ) !== FALSE ) {
                continue;
            }

            $dom = new DOMDocument();
            $dom->loadHTML($match);

            $toc_heading_tag = botiga_get_toc_heading_tag( $match );

            $heading = array();

            // "Explode" each heading attribute to the "$heading" array
            $headingEl = $dom->getElementsByTagName( $toc_heading_tag )->item(0);
            if ($headingEl->hasAttributes()) {
                foreach ($headingEl->attributes as $attr) {
                    $name = $attr->nodeName;
                    $value = $attr->nodeValue;    
                    $heading[$name] = $value;
                }
            }

            
            // Change/create the heading ID
            $heading['id'] = sanitize_title( $headings[0][ $key ] );

            // The heading innerHTML
            $title = wp_strip_all_tags( $headings[0][ $key ] );

            // Mount the modified heading tag to replace in the post content further
            $modified = "<$toc_heading_tag";

            foreach( $heading as $attr => $attr_value ) {
                $modified .= " $attr=\"$attr_value\"";
            }

            $modified .= ">$title</$toc_heading_tag>";

            // push data to the array that will be used to make the replace in the post content
            array_push( $to_replace['search'], $match );
            array_push( $to_replace['replace'], $modified );

            // mount list output
            $list_items_output .= botiga_single_post_toc_mount_list_items_output( $title, $toc_is_hierarchical ? $toc_heading_tag : '' );

            // mount offset css
            // css technique to create a offset between the target and top of browser window
            $offset_css .= '#' . esc_attr( $heading['id'] ) . ':before { content: ""; display: block; height: '. absint( $toc_target_offset_top ) .'px; margin-top: -'. absint( $toc_target_offset_top ) .'px; }';

        }
        
        // Replace the content with modified headings
        $post->post_content = str_replace( $to_replace['search'], $to_replace['replace'], $post->post_content );

        $list_output = '';

        // Sticky Effect (open)
        if( $toc_sticky ) {
            $list_output .= '<div class="botiga-toc-sticky-wrapper">';
                $list_output .= '<a href="#" class="botiga-toc-sticky-expand botiga-toc-sticky-expand-hide"><span>'. esc_html( $toc_title ) .'</span></a>';
        }

        // Prepend TOC List output
        $list_output .= '<div class="botiga-single-post-toc">';
            if( $toc_title ) {
                $list_output .= '<h5 class="botiga-single-post-toc__title">'. esc_html( $toc_title ) .'</h5>';
            }
            $list_output .= '<ul class="botiga-single-post-toc__list botiga-single-post-toc__list--style-'. esc_attr( $toc_list_style ) .'">';
                $list_output .= $list_items_output;
            $list_output .= '</ul>';
        $list_output .= '</div>';

        // Sticky Effect (close)
        if( $toc_sticky ) {
            $list_output .= '</div>';
        }

        $post->post_content = $list_output . $post->post_content;
        
        // Add offset css
        wp_add_inline_style( 'botiga-style-min', $offset_css );
    }

}
add_action( 'wp_enqueue_scripts', 'botiga_single_post_toc_post_content', 11 );

function botiga_single_post_toc_mount_list_items_output( $list_item_title = '', $heading_tag = '' ) {
    ob_start(); ?>
    <li class="botiga-single-post-toc__list-item botiga-toc-<?php echo esc_attr( $heading_tag ); ?>">
        <a href="#<?php echo esc_attr( sanitize_title( $list_item_title ) ); ?>" class="botiga-single-post-toc__list-link">
            <?php echo esc_html( $list_item_title ); ?>
        </a>
    </li>

    <?php
    return ob_get_clean();
}

function botiga_get_toc_heading_tag( $heading ) {
    $tags = array( 'h1', 'h2', 'h3', 'h4', 'h5', 'h6' );
    
    foreach( $tags as $tag ) {
        if( strpos( $heading, "<$tag" ) !== FALSE ) {
            return $tag;
        }
    }
}

/**
 * Custom CSS
 */
function botiga_single_toc_custom_css( $css ) {
    $css .= Botiga_Custom_CSS::get_background_color_css( 'content_cards_background', '#f5f5f5', '.botiga-single-post-toc' );
    $css .= Botiga_Custom_CSS::get_color_css( 'color_body_text', '#212121', 'a.botiga-single-post-toc__list-link' );
    $css .= Botiga_Custom_CSS::get_color_css( 'color_link_default', '#757575', 'a.botiga-single-post-toc__list-link:hover', true );
    $css .= Botiga_Custom_CSS::get_border_color_css( 'color_body_text', '#212121', '.botiga-single-post-toc__list.botiga-single-post-toc__list--style-arrows .botiga-single-post-toc__list-item:before' );
    $css .= Botiga_Custom_CSS::get_border_color_rgba_css( 'color_body_text', '#212121', '.botiga-single-post-toc__list-item+.botiga-single-post-toc__list-item', 0.1 );
    $css .= Botiga_Custom_CSS::get_color_css( 'button_color', '#757575', '.botiga-single-post-toc__list.botiga-single-post-toc__list--style-numbers .botiga-single-post-toc__list-item:before' );
    $css .= Botiga_Custom_CSS::get_background_color_rgba_css( 'button_background_color', '#212121', '.botiga-single-post-toc__list.botiga-single-post-toc__list--style-numbers .botiga-single-post-toc__list-item:before', 1 );
    $css .= Botiga_Custom_CSS::get_background_color_css( 'content_cards_background', '', '.botiga-toc-sticky-expand' );

    return $css;
}
add_filter( 'botiga_custom_css_output', 'botiga_single_toc_custom_css' );
