<?php
/**
 * Single Post TOC Metabox
 *
 * @package Botiga
 */
if ( class_exists( 'Botiga_Metabox' ) ) {

	class Botiga_Single_Post_TOC_Metabox extends Botiga_Metabox {

		public function __construct() {
			add_action( 'botiga_metabox_options', array( $this, 'add_single_post_toc_metabox_options' ) );
		}

		public function add_single_post_toc_metabox_options() {

			$this->add_section( 'toc', array(
				'post_type' => array( 'post' ),
				'title'     => esc_html__( 'Table Of Contents (TOC)', 'botiga-pro' ),
			) );

			$this->add_field( '_botiga_enable_toc', array(
				'section' => 'toc',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Enable', 'botiga-pro' ),
			) );

			$this->add_field( '_botiga_toc_sticky', array(
				'section'  => 'toc',
				'type'     => 'switcher',
				'title'    => esc_html__( 'Enable Sticky Effect', 'botiga-pro' ),
				'subtitle' => esc_html__( 'The TOC will sticky on the screen while scrolling down.', 'botiga-pro' ),
			) );

			$this->add_field( '_botiga_toc_title', array(
				'section' => 'toc',
				'type'    => 'text',
				'title'   => esc_html__( 'Title', 'botiga-pro' ),
			) );

			$this->add_field( '_botiga_toc_heading_tag', array(
				'section'  => 'toc',
				'type'     => 'select',
				'title'    => esc_html__( 'Target Headings', 'botiga-pro' ),
				'subtitle' => esc_html__( 'The TOC is built automatically from all your Target Headings.', 'botiga-pro' ),
				'options'  => array(
					'all'  => esc_html__( 'All', 'botiga-pro' ),
					'h1'   => esc_html__( 'H1', 'botiga-pro' ),
					'h2'   => esc_html__( 'H2', 'botiga-pro' ),
					'h3'   => esc_html__( 'H3', 'botiga-pro' ),
					'h4'   => esc_html__( 'H4', 'botiga-pro' ),
					'h5'   => esc_html__( 'H5', 'botiga-pro' ),
					'h6'   => esc_html__( 'H6', 'botiga-pro' ),
				),
			) );

			$this->add_field( '_botiga_toc_list_style', array(
				'section' => 'toc',
				'type'    => 'select',
				'title'   => esc_html__( 'Bullet Type', 'botiga-pro' ),
				'options' => array(
					'arrows'  => esc_html__( 'Arrows', 'botiga-pro' ),
					'numbers' => esc_html__( 'Numbers', 'botiga-pro' ),
					'none'    => esc_html__( 'None', 'botiga-pro' ),
				),
			) );

			$this->add_field( '_botiga_toc_target_offset_top', array(
				'section'  => 'toc',
				'type'     => 'number',
				'title'    => esc_html__( 'Target Offset Top', 'botiga-pro' ),
				'subtitle' => esc_html__( 'The target distance in pixels from browser window top (when the scrolling ends).', 'botiga-pro' ),
				'default'  => '0',
			) );

			if ( ! defined( 'BOTIGA_AWL_ACTIVE' ) ) {

				$content  = '';
				$content .= '<small>';
				$content .= esc_html__( 'Learn more about this feature in our documentation by clicking on the below link.', 'botiga-pro' );
				$content .= '<br />';
				$content .= '<a href="https://docs.athemes.com/article/432-pro-single-blog-post-table-of-contents/" target="_blank">'. esc_html__( 'Learn more', 'botiga-pro' ) .'</a>';
				$content .= '</small>';

				$this->add_field( '_botiga_toc_awl_active_content', array(
					'section' => 'toc',
					'type'    => 'content',
					'content' => $content,
				) );

			}

		}
	}

	new Botiga_Single_Post_TOC_Metabox();

}
