<?php

/**
 * Size Chart Customizer Options
 */
$controls_general = json_decode($wp_customize->get_control('botiga_single_product_tabs')->controls_general);

$new_controls_general = array(
	'#customize-control-accordion_single_product_size_chart',
	'#customize-control-single_size_chart_global',
	'#customize-control-single_size_chart_button_title',
	'#customize-control-single_size_chart_docs_link',
);

$wp_customize->get_control('botiga_single_product_tabs')->controls_general = json_encode(array_merge($controls_general, $new_controls_general));

// Size Chart
$wp_customize->add_setting(
	'accordion_single_product_size_chart',
	array(
		'sanitize_callback' => 'esc_attr'
	)
);
$wp_customize->add_control(
	new Botiga_Accordion_Control(
		$wp_customize,
		'accordion_single_product_size_chart',
		array(
			'label'    => esc_html__('Size Chart', 'botiga-pro'),
			'section'  => 'botiga_section_single_product',
			'until'    => 'single_size_chart_docs_link',
			'priority' => 115
		)
	)
);

$wp_customize->add_setting(
	'single_size_chart_global',
	array(
		'sanitize_callback' => 'botiga_sanitize_select',
		'default'           => '',
	)
);
$wp_customize->add_control(
	'single_size_chart_global',
	array(
		'type'            => 'select',
		'section'         => 'botiga_section_single_product',
		'label'           => esc_html__('Global Size Chart (Optional)', 'botiga-pro'),
		'choices'         => botiga_get_size_charts(),
		'priority'        => 115
	)
);

$wp_customize->add_setting(
	'single_size_chart_button_title',
	array(
		'sanitize_callback' => 'botiga_sanitize_text',
		'default'           => esc_html__('Size Chart', 'botiga-pro'),
	)
);
$wp_customize->add_control(
	'single_size_chart_button_title',
	array(
		'label'           => esc_html__('Title', 'botiga-pro'),
		'type'            => 'text',
		'section'         => 'botiga_section_single_product',
		'priority'        => 115
	)
);

// Learn more about the size chart feature
$wp_customize->add_setting(
	'single_size_chart_docs_link',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr',
	)
);
$wp_customize->add_control(
	new Botiga_Text_Control(
		$wp_customize,
		'single_size_chart_docs_link',
		array(
			'description'       => esc_html__('Learn more about this feature in our documentation by clicking on the below link.', 'botiga-pro'),
			'link_title'        => esc_html__('Learn more', 'botiga-pro'),
			'link'              => 'https://docs.athemes.com/article/pro-size-chart/',
			'check_white_label' => true,
			'section'           => 'botiga_section_single_product',
			'priority'          => 115
		)
	)
);