<?php
/**
 * Functions for the quick links module
 *
 * @package Botiga
 */

if( ! class_exists( 'Botiga_Modules' ) ) {
	return;
}

if ( ! Botiga_Modules::is_module_active( 'quick-links' ) ) {
	return;
}

/**
 * Enqueue footer related styles
 */
function botiga_enqueue_quick_links_styles() {
	wp_enqueue_style( 'botiga-quick-links-styles', BOTIGA_PRO_URI . 'assets/css/botiga-quick-links.min.css' );
}
add_action( 'wp_enqueue_scripts', 'botiga_enqueue_quick_links_styles', 9 );

/**
 * Load Customizer options
 */
function botiga_quick_links_customizer_options( $wp_customize ) {
	require BOTIGA_PRO_DIR . '/inc/modules/quick-links/customizer/class_botiga_quick_links_control.php';
	require BOTIGA_PRO_DIR . '/inc/modules/quick-links/customizer/options.php';
}
add_action( 'customize_register', 'botiga_quick_links_customizer_options', 999 );

/**
 * Render quick links
 */
function botiga_render_quick_links() {

	$enable = get_theme_mod( 'enable_quick_links', 0 );

	if ( !$enable ) {
		return;
	}

	$position = get_theme_mod( 'quick_links_style', 'bottom' );
	$visibility = get_theme_mod( 'quicklinks_visibility', 'all' );

	$quick_links = get_theme_mod( 'quick_links_group' );
	$quick_links = json_decode( $quick_links, true );

	if ( empty( $quick_links ) ) {
		return;
	}

	?>

	<div class="botiga-quick-links pos-<?php echo esc_attr( $position ); ?> visibility-<?php echo esc_attr( $visibility ); ?>">
		<div class="container">
			<div class="quick-links-inner">
				<?php foreach ( $quick_links as $quick_link ) : ?>

				<?php
				if ( false === strpos( $quick_link['link'], '[' ) ) {
					$href = $quick_link['link'];
				} else {
					$href = '#';
				}

				$style = '';
				$image_style = '';
				$image_class = '';
				if ( false !== strpos( $quick_link['image_url'], 'svg' ) ) {
					$style = 'style="mask: url(' . esc_url( $quick_link['image_url'] ) . ') no-repeat center / contain;-webkit-mask: url(' . esc_url( $quick_link['image_url'] ) . ') no-repeat center / contain"';
					$image_style = 'style="opacity:0;"';
					$image_class = 'is-svg';
				}
				?>

				<div class="quick-link">
					<a href="<?php echo esc_url( $href ); ?>">
						<div class="ql-image <?php echo $image_class; ?>" <?php echo $style; ?>><img <?php echo $image_style; ?> src="<?php echo esc_url( $quick_link['image_url'] ); ?>"/></div>
						<div class="ql-text"><?php echo esc_html( $quick_link['text'] ); ?></div>
					</a>
					<?php if ( false !== strpos( $quick_link['link'], '[' ) ) : ?>
					<div class="ql-shortcode">
						<?php echo do_shortcode( $quick_link['link'] ); ?>
					</div>
					<?php endif; ?>					
				</div>
				<?php endforeach; ?>
			</div>
		</div>
	</div>

	<?php if ( is_customize_preview() ) : ?>
	<script type="text/javascript">
	function botigaQuickLinks() {
		let toggles		= document.querySelectorAll( '.quick-link' );
		let shortcode 	= document.getElementsByClassName( 'ql-shortcode' )[0];

		if ( typeof( shortcode ) != 'undefined' && shortcode != null ) {

			for ( var toggle of toggles ) {
				var link = toggle.getElementsByTagName( 'a' )[0];
				link.addEventListener( 'click', function(e) {
					e.preventDefault();
					this.parentNode.getElementsByClassName( 'ql-shortcode' )[0].classList.toggle( 'is-visible' );
				} );		
			}
		}
	}
	botigaQuickLinks();
	</script>
	<?php endif; ?>
	<?php
}
add_action( 'botiga_after_site', 'botiga_render_quick_links' );

/**
 * Dynamic styles for the footer module
 */
function botiga_quick_links_dynamic_styles( $css ) {

    $css .= Botiga_Custom_CSS::get_background_color_css( 'ql_background_color', '', '.botiga-quick-links.pos-bottom-full, .botiga-quick-links:not(.pos-bottom-full) .quick-links-inner' );

    $css .= Botiga_Custom_CSS::get_color_css( 'ql_item_color', '', '.botiga-quick-links .quick-link .ql-text' );
    $css .= Botiga_Custom_CSS::get_background_color_css( 'ql_item_color', '', '.botiga-quick-links .ql-image.is-svg' );

    $css .= Botiga_Custom_CSS::get_background_color_css( 'ql_item_bg_hover', '', '.botiga-quick-links .quick-link:hover' );

    $css .= Botiga_Custom_CSS::get_color_css( 'ql_item_color_hover', '', '.botiga-quick-links .quick-link:hover .ql-text' );
    $css .= Botiga_Custom_CSS::get_background_color_css( 'ql_item_color_hover', '', '.botiga-quick-links .quick-link:hover .ql-image.is-svg' );

    $css .= Botiga_Custom_CSS::get_border_color_rgba_css( 'ql_item_border_color', '', '.botiga-quick-links .quick-link, .botiga-quick-links.pos-left .quick-link, .botiga-quick-links.pos-right .quick-link', 0.1 );

	$ql_border_radius = get_theme_mod( 'ql_border_radius', 15 );
	$css .= ".botiga-quick-links .quick-links-inner { border-radius:" . esc_attr( $ql_border_radius ) . "px;}" . "\n";	
	$css .= ".botiga-quick-links.pos-bottom .quick-link:first-of-type { border-top-left-radius:" . esc_attr( $ql_border_radius ) . "px;border-bottom-left-radius:" . esc_attr( $ql_border_radius ) . "px;}" . "\n";	
	$css .= ".botiga-quick-links.pos-bottom .quick-link:last-of-type { border-top-right-radius:" . esc_attr( $ql_border_radius ) . "px;border-bottom-right-radius:" . esc_attr( $ql_border_radius ) . "px;}" . "\n";	

	$css .= ".botiga-quick-links.pos-left .quick-link:first-of-type, .botiga-quick-links.pos-right .quick-link:first-of-type { border-top-left-radius:" . esc_attr( $ql_border_radius ) . "px;border-top-right-radius:" . esc_attr( $ql_border_radius ) . "px;}" . "\n";	
	$css .= ".botiga-quick-links.pos-left .quick-link:last-of-type, .botiga-quick-links.pos-right .quick-link:last-of-type { border-bottom-right-radius:" . esc_attr( $ql_border_radius ) . "px;border-bottom-left-radius:" . esc_attr( $ql_border_radius ) . "px;}" . "\n";	

	return $css;
}
add_filter( 'botiga_custom_css_output', 'botiga_quick_links_dynamic_styles' );