<?php 
/**
 * Quick Links Options
 */

$wp_customize->add_section(
  'botiga_quicklinks',
  array(
    'title'    => esc_html__( 'Quick Links', 'botiga-pro'),
    'priority' => 85,
  )
);

$wp_customize->add_setting(
  'enable_quick_links',
  array(
    'default'           => 0,
    'sanitize_callback' => 'botiga_sanitize_checkbox',
  )
);
$wp_customize->add_control(
  new Botiga_Toggle_Control(
    $wp_customize,
    'enable_quick_links',
    array(
      'label'   => esc_html__( 'Enable Quick Links', 'botiga-pro' ),
      'section' => 'botiga_quicklinks',
    )
  )
);

// Tabs
$wp_customize->add_setting(
  'botiga_quicklinks_tabs',
  array(
    'default'           => '',
    'sanitize_callback' => 'esc_attr'
  )
);
$wp_customize->add_control(
  new Botiga_Tab_Control (
    $wp_customize,
    'botiga_quicklinks_tabs',
    array(
      'label'   => '',
      'section' => 'botiga_quicklinks',
      'controls_general' => json_encode( array( 
        '#customize-control-quick_links_style',
        '#customize-control-quicklinks_visibility',
        '#customize-control-ql_border_radius',
        '#customize-control-ql_divider_2',
        '#customize-control-quick_links_group',
      ) ),
      'controls_design'  => json_encode( array(
        '#customize-control-ql_background',
        '#customize-control-ql_item',
        '#customize-control-ql_item_border_color',
      ) ),
      'active_callback' => 'botiga_callback_quick_links'
    )
  )
);

$wp_customize->add_setting(
  'quick_links_style',
  array(
    'default'           => 'bottom',
    'sanitize_callback' => 'sanitize_key',
    'transport'         => 'postMessage'
  )
);
$wp_customize->add_control(
  new Botiga_Radio_Images(
    $wp_customize,
    'quick_links_style',
    array(
      'label'     => esc_html__( 'Style', 'botiga-pro' ),
      'section'   => 'botiga_quicklinks',
      'cols'    => 4,
      'class'     => 'botiga-radio-images-medium',
      'choices'   => array(     
        'bottom'  => array(
          'label' => esc_html__( 'Bottom', 'botiga-pro' ),
          'url'   => '%s/assets/img/qlb.svg'
        ),    
        'bottom-full'   => array(
          'label' => esc_html__( 'Bottom fullwidth', 'botiga-pro' ),
          'url'   => '%s/assets/img/qlbf.svg'
        ),  
        'left'  => array(
          'label' => esc_html__( 'Left', 'botiga-pro' ),
          'url'   => '%s/assets/img/qll.svg'
        ),  
        'right'   => array(
          'label' => esc_html__( 'Right', 'botiga-pro' ),
          'url'   => '%s/assets/img/qlr.svg'
        ),                                        
      ),
      'active_callback' => 'botiga_callback_quick_links',
    )
  )
); 

$wp_customize->add_setting( 'quicklinks_visibility', array(
  'sanitize_callback' => 'botiga_sanitize_select',
  'default'       => 'all',
) );
$wp_customize->add_control( 'quicklinks_visibility', array(
  'type'    => 'select',
  'section'   => 'botiga_quicklinks',
  'label'   => esc_html__( 'Visibility', 'botiga-pro' ),
  'choices' => array(
    'all'       => esc_html__( 'Show on all devices', 'botiga-pro' ),
    'desktop-only'  => esc_html__( 'Desktop only', 'botiga-pro' ),
    'mobile-only'   => esc_html__( 'Mobile/tablet only', 'botiga-pro' ),
  ),
  'active_callback' => 'botiga_callback_quick_links',
) );

$wp_customize->add_setting( 'ql_border_radius', array(
  'default'       => 15,
  'transport'     => 'postMessage',
  'sanitize_callback' => 'absint',
) );
$wp_customize->add_control( new Botiga_Responsive_Slider( $wp_customize, 'ql_border_radius',
  array(
    'label'     => esc_html__( 'Radius', 'botiga-pro' ),
    'section'     => 'botiga_quicklinks',
    'is_responsive' => 0,
    'settings'    => array (
      'size_desktop'  => 'ql_border_radius',
    ),
    'input_attrs' => array (
      'min' => 0,
      'max' => 100
    ),
    'active_callback' => 'botiga_callback_quick_links',
  )
) );

$wp_customize->add_setting( 'ql_divider_2',
  array(
    'sanitize_callback' => 'esc_attr'
  )
);
$wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'ql_divider_2',
    array(
      'section'       => 'botiga_quicklinks',
      'active_callback'   => 'botiga_callback_quick_links'
    )
  )
);

if( class_exists( 'Botiga_Quick_Links_Control' ) ) {
    $wp_customize->add_setting(
        'quick_links_group',
        array(
            'sanitize_callback' => 'botiga_sanitize_quick_links',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Quick_Links_Control(
            $wp_customize,
            'quick_links_group',
            array(
                'label'   => esc_html__( 'Quick Links', 'botiga-pro' ),
                'section' => 'botiga_quicklinks',
                'customizer_repeater_image_control' => true,
                'customizer_repeater_text_control' => true,
                'customizer_repeater_link_control' => true,
                'customizer_repeater_attention_control' => true,
                'active_callback' => 'botiga_callback_quick_links',
            )
        )
    ); 
}

$wp_customize->add_setting(
  'ql_background_color',
  array(
    'default'           => '',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'botiga_sanitize_hex_rgba',
  )
);
$wp_customize->add_setting(
  'ql_item_bg_hover',
  array(
    'default'           => '',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'botiga_sanitize_hex_rgba',
  )
);
$wp_customize->add_control(
  new Botiga_Color_Group(
    $wp_customize,
    'ql_background',
    array(
      'label'    => esc_html__( 'Background Color', 'botiga-pro' ),
      'section'  => 'botiga_quicklinks',
      'settings' => array(
        'normal' => 'ql_background_color',
        'hover'  => 'ql_item_bg_hover',
      ),
      'active_callback' => 'botiga_callback_quick_links'
    )
  )
);

$wp_customize->add_setting(
  'ql_item_color',
  array(
    'default'           => '',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'botiga_sanitize_hex_rgba',
  )
);
$wp_customize->add_setting(
  'ql_item_color_hover',
  array(
    'default'           => '',
    'transport'         => 'postMessage',
    'sanitize_callback' => 'botiga_sanitize_hex_rgba',
  )
);
$wp_customize->add_control(
  new Botiga_Color_Group(
    $wp_customize,
    'ql_item',
    array(
      'label'    => esc_html__( 'Item Color', 'botiga-pro' ),
      'section'  => 'botiga_quicklinks',
      'settings' => array(
        'normal' => 'ql_item_color',
        'hover'  => 'ql_item_color_hover',
      ),
      'active_callback' => 'botiga_callback_quick_links'
    )
  )
);

$wp_customize->add_setting(
  'ql_item_border_color',
  array(
    'default'           => '',
    'sanitize_callback' => 'botiga_sanitize_hex_rgba',
    'transport'         => 'postMessage'
  )
);
$wp_customize->add_control(
  new Botiga_Alpha_Color(
    $wp_customize,
    'ql_item_border_color',
    array(
      'label'           => esc_html__( 'Border color', 'botiga-pro' ),
      'section'         => 'botiga_quicklinks',
      'active_callback' => 'botiga_callback_quick_links'
    )
  )
);

/**
 * Partials
 */
$wp_customize->selective_refresh->add_partial( 'quick_links_style', array(
  'selector'            => '.botiga-quick-links',
  'render_callback'     => 'botiga_render_quick_links',
  'container_inclusive'   => true,
) );

$wp_customize->selective_refresh->add_partial( 'quick_links_group', array(
  'selector'            => '.botiga-quick-links',
  'render_callback'     => 'botiga_render_quick_links',
  'container_inclusive'   => true,
) );