<?php

/**
 * Product Swatches Customizer Options
 */
$wp_customize->add_section(
    'botiga_section_product_swatches',
    array(
        'title'    => __('Product Swatches', 'botiga-pro'),
        'priority' => 150,
    )
);

// Tabs
$wp_customize->add_setting(
    'botiga_section_product_swatches_tabs',
    array(
        'default'           => '',
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control(
    new Botiga_Tab_Control(
        $wp_customize,
        'botiga_section_product_swatches_tabs',
        array(
            'label'            => '',
            'section'          => 'botiga_section_product_swatches',
            'controls_general' => json_encode(array(
                '#customize-control-product_swatch_on_shop_catalog',
                '#customize-control-product_swatch_tooltip',
                '#customize-control-product_swatch_mouseover',
            )),
            'controls_design'  => json_encode(array(
                '#customize-control-product_swatch_select_style_accordion',
                '#customize-control-product_swatch_select_padding',
                '#customize-control-product_swatch_select_border_radius',
                '#customize-control-product_swatch_select_text_color',
                '#customize-control-product_swatch_select_border_color',
                '#customize-control-product_swatch_select_background_color',
                '#customize-control-product_swatch_color_style_accordion',
                '#customize-control-product_swatch_color_width',
                '#customize-control-product_swatch_color_height',
                '#customize-control-product_swatch_color_spacing',
                '#customize-control-product_swatch_color_border_width',
                '#customize-control-product_swatch_color_border_radius',
                '#customize-control-product_swatch_color_border_color',
                '#customize-control-product_swatch_button_style_accordion',
                '#customize-control-product_swatch_button_padding',
                '#customize-control-product_swatch_button_spacing',
                '#customize-control-product_swatch_button_border_width',
                '#customize-control-product_swatch_button_border_radius',
                '#customize-control-product_swatch_button_text_color',
                '#customize-control-product_swatch_button_border_color',
                '#customize-control-product_swatch_button_background_color',
                '#customize-control-product_swatch_image_style_accordion',
                '#customize-control-product_swatch_image_width',
                '#customize-control-product_swatch_image_height',
                '#customize-control-product_swatch_image_spacing',
                '#customize-control-product_swatch_image_border_width',
                '#customize-control-product_swatch_image_border_radius',
                '#customize-control-product_swatch_image_border_color',
            )),
        )
    )
);

$wp_customize->add_setting(
    'product_swatch_on_shop_catalog',
    array(
        'default'           => 0,
        'sanitize_callback' => 'botiga_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    new Botiga_Toggle_Control(
        $wp_customize,
        'product_swatch_on_shop_catalog',
        array(
            'label'   => esc_html__('Enable on Shop Catalog', 'botiga-pro'),
            'section' => 'botiga_section_product_swatches',
        )
    )
);

$wp_customize->add_setting(
    'product_swatch_tooltip',
    array(
        'default'           => 0,
        'sanitize_callback' => 'botiga_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    new Botiga_Toggle_Control(
        $wp_customize,
        'product_swatch_tooltip',
        array(
            'label'   => esc_html__('Enable Tooltip', 'botiga-pro'),
            'section' => 'botiga_section_product_swatches',
        )
    )
);

// TO DO - Add this option in the future
// $wp_customize->add_setting(
//     'product_swatch_mouseover',
//     array(
//         'default'           => 0,
//         'sanitize_callback' => 'botiga_sanitize_checkbox',
//     )
// );
// $wp_customize->add_control(
//     new Botiga_Toggle_Control(
//         $wp_customize,
//         'product_swatch_mouseover',
//         array(
//             'label'   => esc_html__('Display Variation Image On Mouse Over', 'botiga-pro'),
//             'description' => esc_html__('Check this option to automatically display the variation image when mouse over it.', 'botiga-pro'),
//             'section' => 'botiga_section_product_swatches',
//         )
//     )
// );

// Styles
$wp_customize->add_setting(
    'product_swatch_select_style_accordion',
    array(
        'sanitize_callback' => 'esc_attr',
    )
);
$wp_customize->add_control(
    new Botiga_Accordion_Control(
        $wp_customize,
        'product_swatch_select_style_accordion',
        array(
            'label'   => esc_html__('Select', 'botiga-pro'),
            'section' => 'botiga_section_product_swatches',
            'until'   => 'product_swatch_select_background_color',
        )
    )
);

if( class_exists( 'Botiga_Dimensions_Control' ) ) {
    $wp_customize->add_setting( 
        'product_swatch_select_padding_desktop',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'product_swatch_select_padding_tablet',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'product_swatch_select_padding_mobile',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'product_swatch_select_padding',
            array(
                'label'           	=> __( 'Padding', 'botiga-pro' ),
                'section'         	=> 'botiga_section_product_swatches',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => true,
                'settings'        	 => array(
                    'desktop' => 'product_swatch_select_padding_desktop',
                    'tablet'  => 'product_swatch_select_padding_tablet',
                    'mobile'  => 'product_swatch_select_padding_mobile'
                )
            )
        )
    );

    $wp_customize->add_setting( 
        'product_swatch_select_border_radius',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'product_swatch_select_border_radius',
            array(
                'label'           	=> __( 'Border Radius', 'botiga-pro' ),
                'section'         	=> 'botiga_section_product_swatches',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => false,
                'settings'        	 => array(
                    'desktop' => 'product_swatch_select_border_radius'
                )
            )
        )
    );
}

$wp_customize->add_setting(
    'product_swatch_select_text_color',
    array(
        'default'           => '',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control(
    new Botiga_Alpha_Color(
        $wp_customize,
        'product_swatch_select_text_color',
        array(
            'label'   => esc_html__('Text Color', 'botiga-pro'),
            'section' => 'botiga_section_product_swatches',
        )
    )
);

$wp_customize->add_setting(
    'product_swatch_select_border_color',
    array(
        'default'           => '',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control(
    new Botiga_Alpha_Color(
        $wp_customize,
        'product_swatch_select_border_color',
        array(
            'label'   => esc_html__('Border Color', 'botiga-pro'),
            'section' => 'botiga_section_product_swatches',
        )
    )
);

$wp_customize->add_setting(
    'product_swatch_select_background_color',
    array(
        'default'           => '',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control(
    new Botiga_Alpha_Color(
        $wp_customize,
        'product_swatch_select_background_color',
        array(
            'label'   => esc_html__('Background Color', 'botiga-pro'),
            'section' => 'botiga_section_product_swatches',
        )
    )
);

$wp_customize->add_setting(
    'product_swatch_color_style_accordion',
    array(
        'sanitize_callback' => 'esc_attr',
    )
);
$wp_customize->add_control(
    new Botiga_Accordion_Control(
        $wp_customize,
        'product_swatch_color_style_accordion',
        array(
            'label'   => esc_html__('Color', 'botiga-pro'),
            'section' => 'botiga_section_product_swatches',
            'until'   => 'product_swatch_color_border_color',
        )
    )
);

$wp_customize->add_setting('product_swatch_color_width_desktop', array(
    'default'           => 26,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_setting('product_swatch_color_width_tablet', array(
    'default'           => 26,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_setting('product_swatch_color_width_mobile', array(
    'default'           => 26,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(
    new Botiga_Responsive_Slider(
        $wp_customize,
        'product_swatch_color_width',
        array(
            'label'         => esc_html__('Width', 'botiga-pro'),
            'section'       => 'botiga_section_product_swatches',
            'is_responsive' => 1,
            'settings'      => array(
                'size_desktop' => 'product_swatch_color_width_desktop',
                'size_tablet'  => 'product_swatch_color_width_tablet',
                'size_mobile'  => 'product_swatch_color_width_mobile',
            ),
            'input_attrs' => array(
                'min' => 0,
                'max' => 250
            )
        )
    )
);

$wp_customize->add_setting('product_swatch_color_height_desktop', array(
    'default'           => 26,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_setting('product_swatch_color_height_tablet', array(
    'default'           => 26,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_setting('product_swatch_color_height_mobile', array(
    'default'           => 26,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(
    new Botiga_Responsive_Slider(
        $wp_customize,
        'product_swatch_color_height',
        array(
            'label'         => esc_html__('Height', 'botiga-pro'),
            'section'       => 'botiga_section_product_swatches',
            'is_responsive' => 1,
            'settings'      => array(
                'size_desktop' => 'product_swatch_color_height_desktop',
                'size_tablet'  => 'product_swatch_color_height_tablet',
                'size_mobile'  => 'product_swatch_color_height_mobile',
            ),
            'input_attrs' => array(
                'min' => 0,
                'max' => 250
            )
        )
    )
);

$wp_customize->add_setting('product_swatch_color_spacing_desktop', array(
    'default'           => 2,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_setting('product_swatch_color_spacing_tablet', array(
    'default'           => 2,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_setting('product_swatch_color_spacing_mobile', array(
    'default'           => 2,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(
    new Botiga_Responsive_Slider(
        $wp_customize,
        'product_swatch_color_spacing',
        array(
            'label'         => esc_html__('Spacing', 'botiga-pro'),
            'section'       => 'botiga_section_product_swatches',
            'is_responsive' => 1,
            'settings'      => array(
                'size_desktop' => 'product_swatch_color_spacing_desktop',
                'size_tablet'  => 'product_swatch_color_spacing_tablet',
                'size_mobile'  => 'product_swatch_color_spacing_mobile',
            ),
            'input_attrs' => array(
                'min' => 0,
                'max' => 100
            )
        )
    )
);

if( class_exists( 'Botiga_Dimensions_Control' ) ) {
    $wp_customize->add_setting( 
        'product_swatch_color_border_width_desktop',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'product_swatch_color_border_width_tablet',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'product_swatch_color_border_width_mobile',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'product_swatch_color_border_width',
            array(
                'label'           	=> __( 'Border Width', 'botiga-pro' ),
                'section'         	=> 'botiga_section_product_swatches',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => true,
                'settings'        	 => array(
                    'desktop' => 'product_swatch_color_border_width_desktop',
                    'tablet'  => 'product_swatch_color_border_width_tablet',
                    'mobile'  => 'product_swatch_color_border_width_mobile'
                )
            )
        )
    );
}

if( class_exists( 'Botiga_Dimensions_Control' ) ) {
    $wp_customize->add_setting( 
        'product_swatch_color_border_radius',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'product_swatch_color_border_radius',
            array(
                'label'           	=> __( 'Border Radius', 'botiga-pro' ),
                'section'         	=> 'botiga_section_product_swatches',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => false,
                'settings'        	 => array(
                    'desktop' => 'product_swatch_color_border_radius'
                )
            )
        )
    );
}

$wp_customize->add_setting(
    'product_swatch_color_border_color_default',
    array(
        'default'           => '',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_setting(
    'product_swatch_color_border_color_hover',
    array(
        'default'           => '',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'product_swatch_color_border_color',
        array(
            'label'    => esc_html__('Border Color', 'botiga'),
            'section'  => 'botiga_section_product_swatches',
            'settings' => array(
                'normal' => 'product_swatch_color_border_color_default',
                'hover'  => 'product_swatch_color_border_color_hover',
            ),
        )
    )
);

$wp_customize->add_setting(
    'product_swatch_button_style_accordion',
    array(
        'sanitize_callback' => 'esc_attr',
    )
);
$wp_customize->add_control(
    new Botiga_Accordion_Control(
        $wp_customize,
        'product_swatch_button_style_accordion',
        array(
            'label'   => esc_html__('Button', 'botiga-pro'),
            'section' => 'botiga_section_product_swatches',
            'until'   => 'product_swatch_button_background_color',
        )
    )
);

if( class_exists( 'Botiga_Dimensions_Control' ) ) {
    $wp_customize->add_setting( 
        'product_swatch_button_padding_desktop',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'product_swatch_button_padding_tablet',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'product_swatch_button_padding_mobile',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'product_swatch_button_padding',
            array(
                'label'           	=> __( 'Padding', 'botiga-pro' ),
                'section'         	=> 'botiga_section_product_swatches',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => true,
                'settings'        	 => array(
                    'desktop' => 'product_swatch_button_padding_desktop',
                    'tablet'  => 'product_swatch_button_padding_tablet',
                    'mobile'  => 'product_swatch_button_padding_mobile'
                )
            )
        )
    );
}

$wp_customize->add_setting('product_swatch_button_spacing_desktop', array(
    'default'           => 5,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_setting('product_swatch_button_spacing_tablet', array(
    'default'           => 5,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_setting('product_swatch_button_spacing_mobile', array(
    'default'           => 5,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(
    new Botiga_Responsive_Slider(
        $wp_customize,
        'product_swatch_button_spacing',
        array(
            'label'         => esc_html__('Spacing', 'botiga-pro'),
            'section'       => 'botiga_section_product_swatches',
            'is_responsive' => 1,
            'settings'      => array(
                'size_desktop' => 'product_swatch_button_spacing_desktop',
                'size_tablet'  => 'product_swatch_button_spacing_tablet',
                'size_mobile'  => 'product_swatch_button_spacing_mobile',
            ),
            'input_attrs' => array(
                'min' => 0,
                'max' => 100
            )
        )
    )
);

if( class_exists( 'Botiga_Dimensions_Control' ) ) {
    $wp_customize->add_setting( 
        'product_swatch_button_border_width_desktop',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'product_swatch_button_border_width_tablet',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'product_swatch_button_border_width_mobile',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'product_swatch_button_border_width',
            array(
                'label'           	=> __( 'Border Width', 'botiga-pro' ),
                'section'         	=> 'botiga_section_product_swatches',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => true,
                'settings'        	 => array(
                    'desktop' => 'product_swatch_button_border_width_desktop',
                    'tablet'  => 'product_swatch_button_border_width_tablet',
                    'mobile'  => 'product_swatch_button_border_width_mobile'
                )
            )
        )
    );
}

if( class_exists( 'Botiga_Dimensions_Control' ) ) {
    $wp_customize->add_setting( 
        'product_swatch_button_border_radius',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'product_swatch_button_border_radius',
            array(
                'label'           	=> __( 'Border Radius', 'botiga-pro' ),
                'section'         	=> 'botiga_section_product_swatches',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => false,
                'settings'        	 => array(
                    'desktop' => 'product_swatch_button_border_radius'
                )
            )
        )
    );
}

$wp_customize->add_setting(
    'product_swatch_button_text_color_default',
    array(
        'default'           => '',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_setting(
    'product_swatch_button_text_color_hover',
    array(
        'default'           => '',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'product_swatch_button_text_color',
        array(
            'label'    => esc_html__('Text Color', 'botiga'),
            'section'  => 'botiga_section_product_swatches',
            'settings' => array(
                'normal' => 'product_swatch_button_text_color_default',
                'hover'  => 'product_swatch_button_text_color_hover',
            ),
        )
    )
);

$wp_customize->add_setting(
    'product_swatch_button_border_color_default',
    array(
        'default'           => '',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_setting(
    'product_swatch_button_border_color_hover',
    array(
        'default'           => '',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'product_swatch_button_border_color',
        array(
            'label'    => esc_html__('Border Color', 'botiga'),
            'section'  => 'botiga_section_product_swatches',
            'settings' => array(
                'normal' => 'product_swatch_button_border_color_default',
                'hover'  => 'product_swatch_button_border_color_hover',
            ),
        )
    )
);

$wp_customize->add_setting(
    'product_swatch_button_background_color_default',
    array(
        'default'           => '',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_setting(
    'product_swatch_button_background_color_hover',
    array(
        'default'           => '',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'product_swatch_button_background_color',
        array(
            'label'    => esc_html__('Background Color', 'botiga'),
            'section'  => 'botiga_section_product_swatches',
            'settings' => array(
                'normal' => 'product_swatch_button_background_color_default',
                'hover'  => 'product_swatch_button_background_color_hover',
            ),
        )
    )
);

$wp_customize->add_setting(
    'product_swatch_image_style_accordion',
    array(
        'sanitize_callback' => 'esc_attr',
    )
);
$wp_customize->add_control(
    new Botiga_Accordion_Control(
        $wp_customize,
        'product_swatch_image_style_accordion',
        array(
            'label'   => esc_html__('Image', 'botiga-pro'),
            'section' => 'botiga_section_product_swatches',
            'until'   => 'product_swatch_image_border_color',
        )
    )
);

$wp_customize->add_setting('product_swatch_image_width_desktop', array(
    'default'           => 26,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_setting('product_swatch_image_width_tablet', array(
    'default'           => 26,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_setting('product_swatch_image_width_mobile', array(
    'default'           => 26,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(
    new Botiga_Responsive_Slider(
        $wp_customize,
        'product_swatch_image_width',
        array(
            'label'         => esc_html__('Width', 'botiga-pro'),
            'section'       => 'botiga_section_product_swatches',
            'is_responsive' => 1,
            'settings'      => array(
                'size_desktop' => 'product_swatch_image_width_desktop',
                'size_tablet'  => 'product_swatch_image_width_tablet',
                'size_mobile'  => 'product_swatch_image_width_mobile',
            ),
            'input_attrs' => array(
                'min' => 0,
                'max' => 250
            )
        )
    )
);

$wp_customize->add_setting('product_swatch_image_height_desktop', array(
    'default'           => 26,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_setting('product_swatch_image_height_tablet', array(
    'default'           => 26,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_setting('product_swatch_image_height_mobile', array(
    'default'           => 26,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(
    new Botiga_Responsive_Slider(
        $wp_customize,
        'product_swatch_image_height',
        array(
            'label'         => esc_html__('Height', 'botiga-pro'),
            'section'       => 'botiga_section_product_swatches',
            'is_responsive' => 1,
            'settings'      => array(
                'size_desktop' => 'product_swatch_image_height_desktop',
                'size_tablet'  => 'product_swatch_image_height_tablet',
                'size_mobile'  => 'product_swatch_image_height_mobile',
            ),
            'input_attrs' => array(
                'min' => 0,
                'max' => 250
            )
        )
    )
);

$wp_customize->add_setting('product_swatch_image_spacing_desktop', array(
    'default'           => 2,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_setting('product_swatch_image_spacing_tablet', array(
    'default'           => 2,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_setting('product_swatch_image_spacing_mobile', array(
    'default'           => 2,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(
    new Botiga_Responsive_Slider(
        $wp_customize,
        'product_swatch_image_spacing',
        array(
            'label'         => esc_html__('Spacing', 'botiga-pro'),
            'section'       => 'botiga_section_product_swatches',
            'is_responsive' => 1,
            'settings'      => array(
                'size_desktop' => 'product_swatch_image_spacing_desktop',
                'size_tablet'  => 'product_swatch_image_spacing_tablet',
                'size_mobile'  => 'product_swatch_image_spacing_mobile',
            ),
            'input_attrs' => array(
                'min' => 0,
                'max' => 100
            )
        )
    )
);

if( class_exists( 'Botiga_Dimensions_Control' ) ) {
    $wp_customize->add_setting( 
        'product_swatch_image_border_width_desktop',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'product_swatch_image_border_width_tablet',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'product_swatch_image_border_width_mobile',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'product_swatch_image_border_width',
            array(
                'label'           	=> __( 'Border Width', 'botiga-pro' ),
                'section'         	=> 'botiga_section_product_swatches',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => true,
                'settings'        	 => array(
                    'desktop' => 'product_swatch_image_border_width_desktop',
                    'tablet'  => 'product_swatch_image_border_width_tablet',
                    'mobile'  => 'product_swatch_image_border_width_mobile'
                )
            )
        )
    );
}

if( class_exists( 'Botiga_Dimensions_Control' ) ) {
    $wp_customize->add_setting( 
        'product_swatch_image_border_radius',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'product_swatch_image_border_radius',
            array(
                'label'           	=> __( 'Border Radius', 'botiga-pro' ),
                'section'         	=> 'botiga_section_product_swatches',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => false,
                'settings'        	 => array(
                    'desktop' => 'product_swatch_image_border_radius'
                )
            )
        )
    );
}

$wp_customize->add_setting(
    'product_swatch_image_border_color_default',
    array(
        'default'           => '',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_setting(
    'product_swatch_image_border_color_hover',
    array(
        'default'           => '',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'product_swatch_image_border_color',
        array(
            'label'    => esc_html__('Border Color', 'botiga'),
            'section'  => 'botiga_section_product_swatches',
            'settings' => array(
                'normal' => 'product_swatch_image_border_color_default',
                'hover'  => 'product_swatch_image_border_color_hover',
            ),
        )
    )
);
