<?php
/**
 * Product linked variations custom post type.
 */
if ( ! post_type_exists( 'linked_variation' ) ) {

    $botiga_linked_variations_args = array(
        'labels'              => array(
            'name'            => esc_html__( 'Linked Variations', 'botiga-pro' ),
        ),
        'supports'            => array( 'title' ),
        'public'              => true,
        'can_export'          => true,
        'exclude_from_search' => true,
        'show_in_rest'        => false,
        'has_archive'         => false,
        'show_in_nav_menus'   => false,
        'show_in_admin_bar'   => false,
        'show_in_menu'        => 'edit.php?post_type=product',
    );

    register_post_type( 'linked_variation', $botiga_linked_variations_args );

}

/**
 * Product linked variations set admin menu position bottom.
 */
function botiga_linked_variations_admin_menu_position() {
    
    global $submenu;
    
    $product_key = 'edit.php?post_type=product';
    $linked_variation_key = 'edit.php?post_type=linked_variation';
    
    if ( ! empty( $submenu[ $product_key ] ) ) {
        foreach ( $submenu[ $product_key ] as $item_key => $item_value ) {
            if ( array_search( $linked_variation_key, $item_value ) !== FALSE ) {
                unset( $submenu[ $product_key ][ $item_key ] );
                $submenu[ $product_key ][] = $item_value;
            }
        }
    }
    
}
add_action( 'admin_menu', 'botiga_linked_variations_admin_menu_position' );

/**
 * Product linked variations metabox.
 */
if ( class_exists( 'Botiga_Metabox' ) ) {

    class Botiga_Product_Linked_Variations_Metabox extends Botiga_Metabox {
        
        public function __construct() {
            add_action( 'botiga_metabox_options', array( $this, 'add_product_linked_variations_metabox_options' ) );
            add_filter( 'botiga_metabox_exclude_post_types_from_sidebar_section', array( $this, 'post_types_to_exclude_from_metabox_sidebar' ) );
            add_filter( 'botiga_metabox_exclude_post_types_from_general_section', array( $this, 'post_types_to_exclude_from_metabox_sidebar' ) );
        }

        public function post_types_to_exclude_from_metabox_sidebar( $post_types_arr ) {
            $post_types_arr[] = 'linked_variation';

            return $post_types_arr;
        }
        
        public function add_product_linked_variations_metabox_options() {
            
            $this->add_section( 'cpt_linked_variation', array(
                'post_type' => array( 'linked_variation' ),
            ) );
            
            $this->add_field( '_botiga_linked_products', array(
                'section' => 'cpt_linked_variation',
                'type'    => 'select-ajax',
                'title'   => esc_html__( 'Linked Products', 'botiga-pro' ),
                'source'  => 'product',
            ) );
                
            $this->add_field( '_botiga_linked_attributes', array(
                'section' => 'cpt_linked_variation',
                'type'    => 'wc-attributes',
                'title'   => esc_html__( 'Linked Attributes', 'botiga-pro' ),
            ) );
                        
        }
        
    }

    new Botiga_Product_Linked_Variations_Metabox();

}