<?php
/**
 * Search Component
 * Extra Functionality file
 *
 * @package Botiga_Pro
 */

/**
 * Product Categories Dropdown
 */
add_action( 'botiga_searchform_before_form_content', function(){
    $product_cats = get_theme_mod( 'bhfb_search_product_categories_dropdown', 0 );

    if( ! $product_cats ) {
        return;
    }

    $classes = array( 'botiga-select', 'botiga-search-with-product-categories' );

    // Hide Dropdown On Mobile
    $hide_on_mobile = get_theme_mod( 'bhfb_search_product_categories_dropdown_hide_mobile', 1 );
    if( $hide_on_mobile ) {
        $classes[] = 'bt-mobile-hidden';
    }

    $exclude = get_theme_mod( 'bhfb_search_product_categories_dropdown_exclude', '' );
    if( ! $exclude ) {
        $exclude = array();
    }

    $args = array(
        'show_option_all'  => esc_html__( 'All Categories', 'botiga-pro' ),
        'taxonomy'         => 'product_cat',
        'name'             => 'product_cat',
        'class'            => 'product_cat',
        'value_field'      => 'slug',
        'exclude'          => $exclude,
        'selected'         => isset( $_GET['product_cat'] ) ? $_GET['product_cat'] : ''
    );

    $args = apply_filters( 'botiga_search_product_categories_dropdown_args', $args );

    echo '<div class="'. esc_attr( implode( ' ', $classes ) ) .'">';
        wp_dropdown_categories( $args );
    echo '</div>';
} );