<?php
/**
 * Header/Footer Builder
 * Search Component CSS Output
 * 
 * @package Botiga_Pro
 */

/**
 * General (tab)
 */

// Search Form Button Margin Left
$margin_left = get_theme_mod( 'bhfb_search_form_button_margin_left', 10 );
$css .= Botiga_Custom_CSS::get_css( 
    'bhfb_search_form_button_margin_left', 
    10, 
    '.header-search-form form button',
    'margin-left',
    'px',
    true
);

if( $margin_left < 0 ) {
    $css .= '.header-search-form form .search-field { padding-right: '. absint( $margin_left ) .'px; }';
}

// Search Form Size
$css .= Botiga_Custom_CSS::get_css( 
    'bhfb_search_form_size', 
    1, 
    '.header-search-form form button, .header-search-form form .search-field, .header-search-form .botiga-select, .header-search-form .botiga-select select',
    'font-size',
    'rem' 
);

// Search Form Width
if( 'visible' === get_theme_mod( 'bhfb_search_layout' ) ) {
    $css .= Botiga_Custom_CSS::get_responsive_css( 
        'bhfb_search_form_width', 
        array( 'desktop' => 320, 'tablet' => 320, 'mobile' => 200 ), 
        '.header-search-form',
        'width',
        'px' 
    );
}

// Product Categories Dropdown
$css .= Botiga_Custom_CSS::get_css( 
    'bhfb_search_form_product_cat_dropdown_margin_right', 
    10, 
    '.header-search-form .botiga-select',
    'margin-right',
    'px',
    true
);

/**
 * Style (tab)
 */

// Search Form Wrapper Background Color
$css .= Botiga_Custom_CSS::get_background_color_css( 'bhfb_search_form_wrapper_background_color', '#FFF', '.header-search-form' );

// Search Form Input Background Color
$css .= Botiga_Custom_CSS::get_background_color_css( 'bhfb_search_form_input_background_color', '#FFF', '.header-search-form form .search-field, .header-search-form .botiga-select select' );

// Search Form Input Border Color
$css .= Botiga_Custom_CSS::get_border_color_css( 'bhfb_search_form_input_border_color', '#212121', '.header-search-form form .search-field, .header-search-form .botiga-select select' );

// Search Form Input Text Color
$css .= Botiga_Custom_CSS::get_color_css( 'bhfb_search_form_input_text_color', '#212121', '.header-search-form form .search-field, .header-search-form .botiga-select select' );
$css .= Botiga_Custom_CSS::get_border_color_css( 'bhfb_search_form_input_text_color', '#212121', '.botiga-select:before' );

// Search Form Input Placeholder Color
$css .= Botiga_Custom_CSS::get_color_css( 'bhfb_search_form_input_placeholder_color', '#757575', '.header-search-form form .search-field::placeholder, .header-search-form form .search-field::-webkit-input-placeholder' );

// Search Form Input Border Radius
$css .= Botiga_Custom_CSS::get_css( 
    'bhfb_search_form_input_border_radius', 
    0, 
    '.header-search-form form .search-field, .header-search-form .botiga-select select',
    'border-radius',
    'px' 
);

// Search Form Button Background Color
$css .= Botiga_Custom_CSS::get_background_color_css( 'bhfb_search_form_button_background_color', '#212121', '.header-search-form form button' );
$css .= Botiga_Custom_CSS::get_background_color_css( 'bhfb_search_form_button_background_color_hover', '#212121', '.header-search-form form button:hover' );

// Search Form Button Border Color
$css .= Botiga_Custom_CSS::get_border_color_css( 'bhfb_search_form_button_border_color', '#212121', '.header-search-form form button' );
$css .= Botiga_Custom_CSS::get_border_color_css( 'bhfb_search_form_button_border_color_hover', '#212121', '.header-search-form form button:hover' );

// Search Form Button Text Color
$css .= Botiga_Custom_CSS::get_color_css( 'bhfb_search_form_button_text_color', '#FFF', '.header-search-form form button' );
$css .= Botiga_Custom_CSS::get_color_css( 'bhfb_search_form_button_text_color_hover', '#FFF', '.header-search-form form button:hover' );
$css .= Botiga_Custom_CSS::get_fill_css( 'bhfb_search_form_button_text_color', '#FFF', '.header-search-form form button svg', 1, true );
$css .= Botiga_Custom_CSS::get_fill_css( 'bhfb_search_form_button_text_color_hover', '#FFF', '.header-search-form form button:hover svg', 1, true );

// Search Form Button Border Radius
$css .= Botiga_Custom_CSS::get_css( 
    'bhfb_search_form_button_border_radius', 
    0, 
    '.header-search-form form button',
    'border-radius',
    'px' 
);