<?php
/**
 * Header/Footer Builder
 * Login/Register Component
 * 
 * @package Botiga_Pro
 */

// List of options we'll need to move.
$opts_to_move = array(
	'general' => array(
		'header_login_register_title',
		'login_register_link_text',
		'login_register_show_welcome_message',
		'login_register_welcome_message_text'
	),
	'style'   => array()
);

$wp_customize->add_section(
	'botiga_section_hb_component__login_register',
	array(
		'title'      => esc_html__( 'Login/Register', 'botiga-pro' ),
		'panel'      => 'botiga_panel_header'
	)
);

$wp_customize->add_setting(
	'botiga_section_hb_component__login_register_tabs',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_attr'
	)
);
$wp_customize->add_control(
	new Botiga_Tab_Control (
		$wp_customize,
		'botiga_section_hb_component__login_register_tabs',
		array(
			'label' 				=> '',
			'section'       		=> 'botiga_section_hb_component__login_register',
			'controls_general'		=> json_encode(
                array_merge(
                    array(
                        '#customize-control-login_register_visibility'
                    ),
                    array_map( function( $name ){ return "#customize-control-$name"; }, $opts_to_move[ 'general' ] )
                ),
			),
			'controls_design'		=> json_encode(
				array_merge(
					array(
						'#customize-control-login_register',
						'#customize-control-login_register_submenu_background',
						'#customize-control-login_register_submenu',
						'#customize-control-login_register_sticky_title',
						'#customize-control-login_register_sticky',
						'#customize-control-login_register_sticky_submenu_background',
						'#customize-control-login_register_sticky_submenu',
						'#customize-control-login_register_padding',
						'#customize-control-login_register_margin'
					),
					array_map( function( $name ){ return "#customize-control-$name"; }, $opts_to_move[ 'style' ] )
				)
			),
			'priority' 				=> 20
		)
	)
);

// Visibility
$wp_customize->add_setting( 
    'login_register_visibility_desktop',
    array(
        'default' 			=> 'visible',
        'sanitize_callback' => 'botiga_sanitize_text',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_setting( 
    'login_register_visibility_tablet',
    array(
        'default' 			=> 'visible',
        'sanitize_callback' => 'botiga_sanitize_text',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_setting( 
    'login_register_visibility_mobile',
    array(
        'default' 			=> 'visible',
        'sanitize_callback' => 'botiga_sanitize_text',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control( 
    new Botiga_Radio_Buttons( 
        $wp_customize, 
        'login_register_visibility',
        array(
            'label'         => esc_html__( 'Visibility', 'botiga' ),
            'section'       => 'botiga_section_hb_component__login_register',
            'is_responsive' => true,
            'settings' => array(
                'desktop' 		=> 'login_register_visibility_desktop',
                'tablet' 		=> 'login_register_visibility_tablet',
                'mobile' 		=> 'login_register_visibility_mobile'
            ),
            'choices'       => array(
                'visible' => esc_html__( 'Visible', 'botiga' ),
                'hidden'  => esc_html__( 'Hidden', 'botiga' )
            ),
            'priority'      => 60
        )
    ) 
);

// Text Color
$wp_customize->add_setting(
	'login_register_color',
	array(
		'default'           => '#212121',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_setting(
	'login_register_color_hover',
	array(
		'default'           => '#757575',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'login_register',
        array(
            'label'    => esc_html__( 'Text Color', 'botiga-pro' ),
            'section'  => 'botiga_section_hb_component__login_register',
            'settings' => array(
                'normal' => 'login_register_color',
                'hover'  => 'login_register_color_hover',
            ),
            'priority' => 25
        )
    )
);

// Submenu Background
$wp_customize->add_setting(
	'login_register_submenu_background',
	array(
		'default'           => '#FFF',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
	new Botiga_Alpha_Color(
		$wp_customize,
		'login_register_submenu_background',
		array(
			'label'         	=> esc_html__( 'Submenu Background', 'botiga-pro' ),
			'section'       	=> 'botiga_section_hb_component__login_register',
			'priority'			=> 35
		)
	)
);

// Submenu Text Color
$wp_customize->add_setting(
	'login_register_submenu_color',
	array(
		'default'           => '#212121',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_setting(
	'login_register_submenu_color_hover',
	array(
		'default'           => '#757575',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'login_register_submenu',
        array(
            'label'    => esc_html__( 'Submenu Text Color', 'botiga-pro' ),
            'section'  => 'botiga_section_hb_component__login_register',
            'settings' => array(
                'normal' => 'login_register_submenu_color',
                'hover'  => 'login_register_submenu_color_hover',
            ),
            'priority' => 40
        )
    )
);

// Sticky Header - Title
$wp_customize->add_setting( 
	'login_register_sticky_title',
	array(
		'default' 			=> '',
		'sanitize_callback' => 'esc_attr'
	)
);
$wp_customize->add_control( 
	new Botiga_Text_Control( 
		$wp_customize, 
		'login_register_sticky_title',
		array(
			'label'			  => esc_html__( 'Sticky Header - Active State', 'botiga-pro' ),
			'description'     => esc_html__( 'Control the colors when the sticky header state is active.', 'botiga-pro' ),
			'section' 		  => 'botiga_section_hb_component__login_register',
			'active_callback' => 'botiga_sticky_header_enabled',
			'priority'	 	  => 47
		)
	)
);

// Sticky Header - Text Color
$wp_customize->add_setting(
	'login_register_sticky_color',
	array(
		'default'           => '#212121',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_setting(
	'login_register_sticky_color_hover',
	array(
		'default'           => '#757575',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'login_register_sticky',
        array(
            'label'    => esc_html__( 'Text Color', 'botiga-pro' ),
            'section'  => 'botiga_section_hb_component__login_register',
            'settings' => array(
                'normal' => 'login_register_sticky_color',
                'hover'  => 'login_register_sticky_color_hover',
            ),
						'active_callback' => 'botiga_sticky_header_enabled',
            'priority' => 48
        )
    )
);

// Sticky Header - Submenu Background
$wp_customize->add_setting(
	'login_register_sticky_submenu_background',
	array(
		'default'           => '#FFF',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
	new Botiga_Alpha_Color(
		$wp_customize,
		'login_register_sticky_submenu_background',
		array(
			'label'         	=> esc_html__( 'Submenu Background', 'botiga-pro' ),
			'section'       	=> 'botiga_section_hb_component__login_register',
			'active_callback'	=> 'botiga_sticky_header_enabled',
			'priority'			=> 50
		)
	)
);

// Sticky Header - Submenu Text Color
$wp_customize->add_setting(
	'login_register_sticky_submenu_color',
	array(
		'default'           => '#212121',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_setting(
	'login_register_sticky_submenu_color_hover',
	array(
		'default'           => '#757575',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
    new Botiga_Color_Group(
        $wp_customize,
        'login_register_sticky_submenu',
        array(
            'label'    => esc_html__( 'Submenu Text Color', 'botiga-pro' ),
            'section'  => 'botiga_section_hb_component__login_register',
            'settings' => array(
                'normal' => 'login_register_sticky_submenu_color',
                'hover'  => 'login_register_sticky_submenu_color_hover',
            ),
						'active_callback' => 'botiga_sticky_header_enabled',
            'priority' => 51
        )
    )
);

if( class_exists( 'Botiga_Dimensions_Control' ) ) {

    // Padding
    $wp_customize->add_setting( 
        'login_register_padding_desktop',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'login_register_padding_tablet',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'login_register_padding_mobile',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'login_register_padding',
            array(
                'label'           	=> __( 'Wrapper Padding', 'botiga' ),
                'section'         	=> 'botiga_section_hb_component__login_register',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => true,
                'settings'        	 => array(
                    'desktop' => 'login_register_padding_desktop',
                    'tablet'  => 'login_register_padding_tablet',
                    'mobile'  => 'login_register_padding_mobile'
                ),
                'priority'	      	 => 72
            )
        )
    );

    // Margin
    $wp_customize->add_setting( 
        'login_register_margin_desktop',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'login_register_margin_tablet',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'login_register_margin_mobile',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'login_register_margin',
            array(
                'label'           	=> __( 'Wrapper Margin', 'botiga' ),
                'section'         	=> 'botiga_section_hb_component__login_register',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => true,
                'settings'        	 => array(
                    'desktop' => 'login_register_margin_desktop',
                    'tablet'  => 'login_register_margin_tablet',
                    'mobile'  => 'login_register_margin_mobile'
                ),
                'priority'	      	 => 72
            )
        )
    );

}

// Move existing options.
$priority = 50;
foreach( $opts_to_move as $tabs ) {
	foreach( $tabs as $option_name ) {
		$wp_customize->get_control( $option_name )->section  = 'botiga_section_hb_component__login_register';
		$wp_customize->get_control( $option_name )->priority = $priority;
		
		$priority++;
	}
}