<?php
/**
 * Google Autocomplete
 * 
 * @package Botiga_Pro
 */

if ( class_exists( 'Botiga_Modules' ) && ! Botiga_Modules::is_module_active( 'google-autocomplete' ) ) {
	return;
}

/**
 * Customizer Settings.
 */
function botiga_customizer_google_autocomplete_options( $wp_customize ) {

    // Checkout go to goggle autcomplete section button
    $wp_customize->add_setting( 'checkout_botiga_google_autocomplete_goto_section',
        array(
            'default' 			=> '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( new Botiga_Text_Control( $wp_customize, 'checkout_botiga_google_autocomplete_goto_section',
            array(
                'description' 	=> '<span class="customize-control-title" style="font-style: normal;"></span><a class="botiga-to-widget-area-link" href="javascript:wp.customize.section( \'botiga_google_autocomplete_section\' ).focus();">' . esc_html__( 'Google Autocomplete Settings', 'botiga-pro' ) . '<span class="dashicons dashicons-arrow-right-alt2"></span></a>',
                'section' 		=> 'woocommerce_checkout',
                'priority' 		=> 1
            )
        )
    );

    // Google Autocomplete section
    $wp_customize->add_section( 'botiga_google_autocomplete_section', array(
        'title'    => esc_html__( 'Google Autocomplete', 'botiga-pro' ),
        'panel'    => null,
        'priority' => 1
    ) );

    // Google Autocomplete Api KEY (google maps)
    $wp_customize->add_setting(
        'botiga_google_autocomplete_api_key',
        array(
            'default'           => '',
            'sanitize_callback' => 'botiga_sanitize_text',
        )
    );
    $wp_customize->add_control( 'botiga_google_autocomplete_api_key',
        array(
            'type'            => 'text',
            'label'           => esc_html__( 'Google Autocomplete API Key', 'botiga-pro' ),
            'section'         => 'botiga_google_autocomplete_section',
            'priority'        => 10
        )
    );

    // Learn More about Google Autocomplete feature
    $wp_customize->add_setting(
        'botiga_google_autocomplete_learn_more_info',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        new Botiga_Text_Control(
            $wp_customize,
            'botiga_google_autocomplete_learn_more_info',
            array(
                'description'       => esc_html__( 'A Google Maps API key is required to use the autocomplete.', 'botiga-pro' ),
                'link_title'        => esc_html__( 'Learn more', 'botiga-pro' ),
                'link'              => 'https://docs.athemes.com/article/pro-how-to-enable-google-autocomplete-on-checkout-address-fields/',
                'check_white_label' => true,
                'section'           => 'botiga_google_autocomplete_section',
                'priority'          => 15
            )
        )
    );

}
add_action( 'customize_register', 'botiga_customizer_google_autocomplete_options', 999 );

/**
 * Google autocomplete scripts.
 */
function botiga_google_autocomplete_scripts() {

    $api_key = get_theme_mod( 'botiga_google_autocomplete_api_key', '' );

    if ( ! $api_key ) {
        return;
    }

    if ( ! is_checkout() ) {
        return;
    }

    $api_url = add_query_arg( array( 'key' => $api_key, 'libraries' => 'places', 'v' => 'weekly', 'callback' => 'botigaGoogleAutoComplete' ), 'https://maps.googleapis.com/maps/api/js' );

    wp_enqueue_script( 'botiga-google-autocomplete', BOTIGA_PRO_URI . 'assets/js/botiga-google-autocomplete.js', array(), BOTIGA_PRO_VERSION, true );
    wp_enqueue_script( 'botiga-google-autocomplete-api', $api_url, array(), BOTIGA_PRO_VERSION, true );

}
add_filter( 'wp_enqueue_scripts', 'botiga_google_autocomplete_scripts' );