<?php
/**
 * Custom Fonts Customize Options
 *
 * @package Botiga
 */

if ( $wp_customize->get_control( 'fonts_library' ) !== NULL ) {
	$wp_customize->get_control( 'fonts_library' )->choices['custom'] = esc_html__( 'Custom Fonts', 'botiga-pro' );
}

$wp_customize->add_setting( 
	'custom_fonts',
	array(
		'default'           => '[]',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'sanitize_textarea_field'
	)
);

$wp_customize->add_control( 
	new Botiga_Custom_Fonts_Control( 
		$wp_customize, 
		'custom_fonts',
		array(
			'section'         => 'botiga_section_typography_general',
			'active_callback' => 'botiga_font_library_custom'
		)
	)
);
