<?php 
/**
 * Breadcrumb options
 */

$wp_customize->add_section(
	'botiga_breadcrumbs',
	array(
		'title'    => esc_html__( 'Breadcrumbs', 'botiga-pro'),
		'priority' => 80,
	)
);

// Tabs
$wp_customize->add_setting(
	'botiga_breadcrumbs_tabs',
	array(
		'default'           => '',
		'sanitize_callback'	=> 'esc_attr'
	)
);
$wp_customize->add_control(
	new Botiga_Tab_Control (
		$wp_customize,
		'botiga_breadcrumbs_tabs',
		array(
			'label'   => '',
			'section' => 'botiga_breadcrumbs',
			'controls_general' => json_encode( array( 
				'#customize-control-breadcrumbs_source',
				'#customize-control-breadcrumbs_position',
				'#customize-control-breadcrumbs_divider_0',
				'#customize-control-breadcrumbs_padding',
				'#customize-control-breadcrumbs_margin_bottom',
				'#customize-control-breadcrumbs_align',
			) ),
			'controls_design'  => json_encode( array(
				'#customize-control-breadcrumbs_link',
				'#customize-control-breadcrumbs_background',
				'#customize-control-breadcrumbs_color',
				'#customize-control-breadcrumbs_border_bottom_color',
			) ),
		)
	)
);

//Source
$breadcrumbs_sources = array();

$breadcrumbs_sources['builtin'] = esc_html__( 'Built-in engine', 'botiga-pro' );

if ( function_exists('bcn_display' ) ) {
	$breadcrumbs_sources['bcn_display'] = esc_html__( 'Breadcrumb NavXT', 'botiga-pro' );
}

if ( function_exists('yoast_breadcrumb' ) ) {
	$breadcrumbs_sources['yoast_breadcrumb'] = esc_html__( 'Yoast SEO', 'botiga-pro' );
}

if ( function_exists('rank_math_the_breadcrumbs' ) ) {
	$breadcrumbs_sources['rank_math_the_breadcrumbs'] = esc_html__( 'RankMath', 'botiga-pro' );
}

if ( function_exists('aioseo_breadcrumbs' ) ) {
	$breadcrumbs_sources['aioseo_breadcrumbs'] = esc_html__( 'All in One SEO', 'botiga-pro' );
}

$wp_customize->add_setting( 'breadcrumbs_source', array(
	'sanitize_callback' => 'botiga_sanitize_select',
	'default' 			=> 'builtin',
) );
$wp_customize->add_control( 'breadcrumbs_source', array(
	'type' 			=> 'select',
	'section' 		=> 'botiga_breadcrumbs',
	'label' 		=> esc_html__( 'Breadcrumbs generator', 'botiga-pro' ),
	'description' 	=> esc_html__( 'Use the theme built-in breadcrumbs or All-in-One SEO, Yoast, Rankmath, or Breadcrumb NavXT.', 'botiga-pro' ),
	'choices' 		=> $breadcrumbs_sources
) );

$wp_customize->add_setting( 'breadcrumbs_position', array(
	'sanitize_callback' => 'botiga_sanitize_select',
	'default' 			=> 'botiga_after_header',
) );
$wp_customize->add_control( 'breadcrumbs_position', array(
	'type' 			=> 'select',
	'section' 		=> 'botiga_breadcrumbs',
	'label' 		=> esc_html__( 'Position', 'botiga-pro' ),
	'choices' 		=> array(
		'botiga_after_header' => esc_html__( 'After header', 'botiga-pro' ),	
		'botiga_before_title' => esc_html__( 'Before page title', 'botiga-pro' ),
	)
) );

$wp_customize->add_setting( 'breadcrumbs_divider_0',
	array(
		'sanitize_callback' => 'esc_attr'
	)
);
$wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'breadcrumbs_divider_0',
		array(
			'section' 	=> 'botiga_breadcrumbs',
		)
	)
);

$wp_customize->add_setting( 'breadcrumbs_padding_desktop', array(
	'default'   		=> 15,
	'transport'			=> 'postMessage',
	'sanitize_callback' => 'absint',
) );			
$wp_customize->add_setting( 'breadcrumbs_padding_tablet', array(
	'default'   		=> 15,
	'transport'			=> 'postMessage',
	'sanitize_callback' => 'absint',
) );
$wp_customize->add_setting( 'breadcrumbs_padding_mobile', array(
	'default'   		=> 15,
	'transport'			=> 'postMessage',
	'sanitize_callback' => 'absint',
) );			
$wp_customize->add_control( new Botiga_Responsive_Slider( $wp_customize, 'breadcrumbs_padding',
	array(
		'label' 		=> esc_html__( 'Vertical padding', 'botiga-pro' ),
		'section' 		=> 'botiga_breadcrumbs',
		'is_responsive'	=> 1,
		'settings' 		=> array (
			'size_desktop' 		=> 'breadcrumbs_padding_desktop',
			'size_tablet' 		=> 'breadcrumbs_padding_tablet',
			'size_mobile' 		=> 'breadcrumbs_padding_mobile',
		),
		'input_attrs' => array (
			'min'	=> 0,
			'max'	=> 200
		)		
	)
) );

$wp_customize->add_setting( 'breadcrumbs_margin_bottom_desktop', array(
	'default'   		=> 15,
	'transport'			=> 'postMessage',
	'sanitize_callback' => 'absint',
) );			
$wp_customize->add_setting( 'breadcrumbs_margin_bottom_tablet', array(
	'default'   		=> 15,
	'transport'			=> 'postMessage',
	'sanitize_callback' => 'absint',
) );
$wp_customize->add_setting( 'breadcrumbs_margin_bottom_mobile', array(
	'default'   		=> 15,
	'transport'			=> 'postMessage',
	'sanitize_callback' => 'absint',
) );			
$wp_customize->add_control( new Botiga_Responsive_Slider( $wp_customize, 'breadcrumbs_margin_bottom',
	array(
		'label' 		=> esc_html__( 'Bottom Margin', 'botiga-pro' ),
		'section' 		=> 'botiga_breadcrumbs',
		'is_responsive'	=> 1,
		'settings' 		=> array (
			'size_desktop' 		=> 'breadcrumbs_margin_bottom_desktop',
			'size_tablet' 		=> 'breadcrumbs_margin_bottom_tablet',
			'size_mobile' 		=> 'breadcrumbs_margin_bottom_mobile',
		),
		'input_attrs' => array (
			'min'	=> 0,
			'max'	=> 200
		)		
	)
) );

$wp_customize->add_setting( 'breadcrumbs_align',
	array(
		'default' 			=> 'left',
		'sanitize_callback' => 'botiga_sanitize_text',
		'transport'			=> 'postMessage'
	)
);
$wp_customize->add_control( new Botiga_Radio_Buttons( $wp_customize, 'breadcrumbs_align',
	array(
		'label'   => esc_html__( 'Alignment', 'botiga-pro' ),
		'section' => 'botiga_breadcrumbs',
		'choices' => array(
			'left' 		=> '<svg width="16" height="13" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h10v1H0zM0 4h16v1H0zM0 8h10v1H0zM0 12h16v1H0z"/></svg>',
			'center' 	=> '<svg width="16" height="13" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M3 0h10v1H3zM0 4h16v1H0zM3 8h10v1H3zM0 12h16v1H0z"/></svg>',
			'right' 	=> '<svg width="16" height="13" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6 0h10v1H6zM0 4h16v1H0zM6 8h10v1H6zM0 12h16v1H0z"/></svg>',
		),
	)
) );

$wp_customize->add_setting(
	'breadcrumbs_link_color',
	array(
		'default'           => '#737C8C',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
	)
);
$wp_customize->add_setting(
	'breadcrumbs_link_hover_color',
	array(
		'default'           => '#737C8C',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
	)
);
$wp_customize->add_control(
	new Botiga_Color_Group(
		$wp_customize,
		'breadcrumbs_link',
		array(
			'label'    => esc_html__( 'Link Color', 'botiga-pro' ),
			'section'  => 'botiga_breadcrumbs',
			'settings' => array(
				'normal' => 'breadcrumbs_link_color',
				'hover'  => 'breadcrumbs_link_hover_color',
			),
		)
	)
);

$wp_customize->add_setting(
	'breadcrumbs_background',
	array(
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
	new Botiga_Alpha_Color(
		$wp_customize,
		'breadcrumbs_background',
		array(
			'label'         	=> esc_html__( 'Background color', 'botiga-pro' ),
			'section'       	=> 'botiga_breadcrumbs',
		)
	)
);

$wp_customize->add_setting(
	'breadcrumbs_color',
	array(
		'default'			=> '#47425d',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
	new Botiga_Alpha_Color(
		$wp_customize,
		'breadcrumbs_color',
		array(
			'label'         	=> esc_html__( 'Text Color', 'botiga-pro' ),
			'section'       	=> 'botiga_breadcrumbs',
		)
	)
);

$wp_customize->add_setting(
	'breadcrumbs_border_bottom_color',
	array(
		'default'			=> '#dbdbdb',
		'sanitize_callback' => 'botiga_sanitize_hex_rgba',
		'transport'         => 'postMessage'
	)
);
$wp_customize->add_control(
	new Botiga_Alpha_Color(
		$wp_customize,
		'breadcrumbs_border_bottom_color',
		array(
			'label'         	=> esc_html__( 'Border Color', 'botiga-pro' ),
			'section'       	=> 'botiga_breadcrumbs',
		)
	)
);