<?php 
/**
 * Advanced Reviews Customizer Options
 */
$controls_general = json_decode( $wp_customize->get_control( 'botiga_single_product_tabs' )->controls_general );

$new_controls_general = array(
	'#customize-control-accordion_single_product_reviews_advanced',
  '#customize-control-single_product_reviews_advanced_default_sorting',
  '#customize-control-single_product_reviews_advanced_comments_per_page',
  '#customize-control-single_product_reviews_advanced_pagination_type',
  '#customize-control-single_product_reviews_advanced_display_order',
  '#customize-control-single_product_reviews_advanced_learn_more',
);

$wp_customize->get_control( 'botiga_single_product_tabs' )->controls_general = json_encode( array_merge( $controls_general, $new_controls_general ) );

$controls_design     = json_decode( $wp_customize->get_control( 'botiga_single_product_tabs' )->controls_design );
$new_controls_design = array(
  '#customize-control-accordion_single_product_reviews_advanced_styling',
  '#customize-control-single_product_reviews_advanced_section_bg_color',
  '#customize-control-single_product_reviews_advanced_stars_bg_color',
  '#customize-control-single_product_reviews_advanced_stars_color',
);
$wp_customize->get_control( 'botiga_single_product_tabs' )->controls_design = json_encode( array_merge( $controls_design, $new_controls_design ) );

// Advanced Reviews
$wp_customize->add_setting( 'accordion_single_product_reviews_advanced', 
  array(
    'sanitize_callback' => 'esc_attr',
  )
);
$wp_customize->add_control(
  new Botiga_Accordion_Control(
    $wp_customize,
    'accordion_single_product_reviews_advanced',
    array(
      'label'    => esc_html__( 'Advanced Reviews', 'botiga-pro' ),
      'section'  => 'botiga_section_single_product',
      'until'    => 'single_product_reviews_advanced_learn_more',
      'priority' => 114
    )
  )
);

$wp_customize->add_setting( 
  'single_product_reviews_advanced_default_sorting', 
  array(
    'default'           => 'newest',
    'sanitize_callback' => 'botiga_sanitize_select',
  ) 
);
$wp_customize->add_control( 
  'single_product_reviews_advanced_default_sorting', 
  array(
    'type'          => 'select',
    'section'       => 'botiga_section_single_product',
    'label'         => esc_html__( 'Default Reviews Sorting', 'botiga-pro' ),
    'choices'       => array(
        'newest'    => esc_html__( 'Newest', 'botiga-pro' ),
        'oldest'    => esc_html__( 'Oldest', 'botiga-pro' ),
        'top-rated' => esc_html__( 'Top Rated', 'botiga-pro' ),
        'low-rated' => esc_html__( 'Low Rated', 'botiga-pro' )
    ),
    'priority'      => 114
  ) 
);

$wp_customize->add_setting(
  'single_product_reviews_advanced_comments_per_page',
  array(
    'default'           => '',
    'sanitize_callback' => 'esc_attr',
  )
);
$wp_customize->add_control(
  new Botiga_Text_Control(
    $wp_customize,
    'single_product_reviews_advanced_comments_per_page',
    array(
      'label'       => '',
      'description' => esc_html__( 'By default, WordPress doesn\'t have pagination enabled for comments/reviews. You can change it through:', 'botiga-pro' ),
      'link_title'  => esc_html__( 'Settings > Discussion', 'botiga-pro' ),
      'link'        => get_admin_url( null, 'options-discussion.php' ),
      'section'     => 'botiga_section_single_product',
      'priority'    => 114
    )
  )
);

$wp_customize->add_setting( 
  'single_product_reviews_advanced_pagination_type', 
  array(
    'default' => 'default',
    'sanitize_callback' => 'botiga_sanitize_select',
  ) 
);
$wp_customize->add_control( 
  'single_product_reviews_advanced_pagination_type', 
  array(
    'type'        => 'select',
    'section'     => 'botiga_section_single_product',
    'label'       => esc_html__( 'Pagination Type', 'botiga-pro' ),
    'description' => esc_html__( 'This option works only if you have pagination for comments enabled.', 'botiga-pro' ),
    'choices'     => array(
      'default'   => esc_html__( 'Default', 'botiga-pro' ),
      'load-more' => esc_html__( 'Load More Button', 'botiga-pro' ),
    ),
    'priority'    => 114
  ) 
);

$wp_customize->add_setting( 
  'single_product_reviews_advanced_display_order', 
  array(
    'default' => '10',
    'sanitize_callback' => 'botiga_sanitize_select',
  ) 
);
$wp_customize->add_control( 
  'single_product_reviews_advanced_display_order', 
  array(
    'type'        => 'select',
    'label'       => esc_html__( 'Display Order', 'botiga-pro' ),
    'description' => esc_html__( 'Controls the display order from the entire advanced reviews section. Low values will move the section to top. High values will move the section to bottom.', 'botiga-pro' ),
    'section'     => 'botiga_section_single_product',
    'choices'     => array(
      '10' => esc_html__( '10', 'botiga-pro' ),
      '15' => esc_html__( '15', 'botiga-pro' ),
      '20' => esc_html__( '20', 'botiga-pro' ),
      '25' => esc_html__( '25', 'botiga-pro' ),
      '30' => esc_html__( '30', 'botiga-pro' ),
      '35' => esc_html__( '35', 'botiga-pro' )
    ),
    'priority'  => 114
  ) 
);

$wp_customize->add_setting(
  'single_product_reviews_advanced_learn_more',
  array(
    'default'           => '',
    'sanitize_callback' => 'esc_attr',
  )
);
$wp_customize->add_control(
  new Botiga_Text_Control(
    $wp_customize,
    'single_product_reviews_advanced_learn_more',
    array(
      'label'             => '',
      'description'       => esc_html__( 'Click in the below link to learn more about the single product advanced reviews feature.', 'botiga-pro' ),
      'link_title'        => esc_html__( 'Learn More', 'botiga-pro' ),
      'link'              => 'https://docs.athemes.com/article/439-pro-single-product-advanced-reviews',
      'check_white_label' => true,
      'section'           => 'botiga_section_single_product',
      'priority'          => 114
    )
  )
);

//Advanced Reviews Styling
$wp_customize->add_setting( 'accordion_single_product_reviews_advanced_styling', 
  array(
    'sanitize_callback' => 'esc_attr',
  )
);
$wp_customize->add_control(
  new Botiga_Accordion_Control(
    $wp_customize,
    'accordion_single_product_reviews_advanced_styling',
    array(
      'label'    => esc_html__( 'Advanced Reviews', 'botiga-pro' ),
      'section'  => 'botiga_section_single_product',
      'until'    => 'single_product_reviews_advanced_stars_color',
      'priority' => 151
    )
  )
);

$wp_customize->add_setting(
  'single_product_reviews_advanced_section_bg_color',
  array(
    'default'           => '#FFF',
    'sanitize_callback' => 'botiga_sanitize_hex_rgba',
    'transport'         => 'postMessage'
  )
);
$wp_customize->add_control(
  new Botiga_Alpha_Color(
    $wp_customize,
    'single_product_reviews_advanced_section_bg_color',
    array(
      'label'    => esc_html__( 'Section Background Color', 'botiga-pro' ),
      'section'  => 'botiga_section_single_product',
      'priority' => 151
    )
  )
);

$wp_customize->add_setting(
  'single_product_reviews_advanced_stars_bg_color',
  array(
    'default'           => '#777',
    'sanitize_callback' => 'botiga_sanitize_hex_rgba',
    'transport'         => 'postMessage'
  )
);
$wp_customize->add_control(
  new Botiga_Alpha_Color(
    $wp_customize,
    'single_product_reviews_advanced_stars_bg_color',
    array(
      'label'    => esc_html__( 'Stars Background Color', 'botiga-pro' ),
      'section'  => 'botiga_section_single_product',
      'priority' => 151
    )
  )
);

$wp_customize->add_setting(
  'single_product_reviews_advanced_stars_color',
  array(
    'default'           => '#FFA441',
    'sanitize_callback' => 'botiga_sanitize_hex_rgba',
    'transport'         => 'postMessage'
  )
);
$wp_customize->add_control(
  new Botiga_Alpha_Color(
    $wp_customize,
    'single_product_reviews_advanced_stars_color',
    array(
      'label'    => esc_html__( 'Stars Color', 'botiga-pro' ),
      'section'  => 'botiga_section_single_product',
      'priority' => 151
    )
  )
);