<?php
/**
 * Helper functions
 *
 * @package Botiga_Pro
 */

/**
 * Get Registered Sidebars
 */
function botiga_pro_get_registered_sidebars() {
	global $wp_registered_sidebars;

	$sidebars = array(
		'' => esc_html__( 'Default', 'botiga-pro' ),
	);

	if ( ! empty( $wp_registered_sidebars ) ) {
		foreach ( $wp_registered_sidebars as $sidebar ) {
			$sidebars[ $sidebar['id'] ] = $sidebar['name'];
		}
	}

	return $sidebars;
}

/**
 * Wrapper For Get SVG Icon
 * The 'botiga_get_svg_icon' function is defined in the theme files. We need this wrapper
 * to avoid fatal errors when cloning the website with wordpress cpanel toolkit
 */
function botiga_pro_get_svg_icon( $icon, $echo = false ) {
	if( ! function_exists( 'botiga_get_svg_icon' ) ) {
		return '';
	}

	return botiga_get_svg_icon( $icon, $echo );
}

/**
 * Get template part (for templates like the shop-loop).
 *
 * BOTIGA_TEMPLATE_DEBUG_MODE will prevent overrides in themes from taking priority.
 *
 * @param mixed  $slug Template slug.
 * @param string $name Template name (default: '').
 */
function bp_get_template_part( $slug, $name = '' ) {
	$template = '';
	$template_path = 'templates/';

	if ( $name ) {
		$template = BOTIGA_TEMPLATE_DEBUG_MODE ? '' : locate_template(
			array(
				"{$slug}-{$name}.php",
				$template_path . "{$slug}-{$name}.php",
			)
		);

		if ( ! $template ) {
			$fallback = BOTIGA_PRO_DIR . "/templates/{$slug}-{$name}.php";
			$template = file_exists( $fallback ) ? $fallback : '';
		}
	}

	if ( ! $template ) {
		// If template file doesn't exist, look in yourtheme/slug.php and yourtheme/woocommerce/slug.php.
		$template = BOTIGA_TEMPLATE_DEBUG_MODE ? '' : locate_template(
			array(
				"{$slug}.php",
				$template_path . "{$slug}.php",
			)
		);
	}

	// Allow 3rd party plugins to filter template file from their plugin.
	$template = apply_filters( 'bp_get_template_part', $template, $slug, $name );

	if ( $template ) {
		load_template( $template, false );
	}
}