<?php
/**
 * WooCommerce Customizer options
 *
 * @package Botiga_Pro
 */

function botiga_pro_woocommerce_options( $wp_customize ) {
    
    /**
     * Tabs Control
     */
    $controls_general     = json_decode( $wp_customize->get_control( 'botiga_product_catalog_tabs' )->controls_general );
    $new_controls_general = array( '#customize-control-shop_archive_pro_divider1','#customize-control-shop_archive_header_style','#customize-control-shop_archive_header_style_alignment','#customize-control-shop_archive_header_style_show_categories','#customize-control-shop_archive_header_style_show_sub_categories','#customize-control-shop_archive_header_style_hide_cat_term_count','#customize-control-shop_archive_pro_divider2','#customize-control-shop_sidebar','#customize-control-shop_archive_sidebar_open_button_text','#customize-control-shop_archive_sidebar_open_icon','#customize-control-shop_archive_sidebar_filter_in_desktop','#customize-control-shop_archive_sidebar_top_columns','#customize-control-shop_archive_columns_gap_title3','#customize-control-shop_archive_columns_gap_desktop','#customize-control-shop_archive_pagination_divider1','#customize-control-shop_archive_pagination_title','#customize-control-shop_archive_pagination_type','#customize-control-shop_product_stock','#customize-control-shop_product_quantity','#customize-control-shop_grid_list_view','#customize-control-shop_pagination_ppp','#customize-control-shop_product_image_swap' );
    $wp_customize->get_control( 'botiga_product_catalog_tabs' )->controls_general = json_encode( array_merge( $controls_general, $new_controls_general ) );
    
    $controls_design     = json_decode( $wp_customize->get_control( 'botiga_product_catalog_tabs' )->controls_design );
    $new_controls_design = array( '#customize-control-shop_archive_header_title1','#customize-control-shop_archive_header_styling_layout','#customize-control-shop_archive_header_background_color','#customize-control-shop_archive_header_background_image','#customize-control-shop_archive_header_background_size','#customize-control-shop_archive_header_background_position','#customize-control-shop_archive_header_background_repeat','#customize-control-shop_archive_header_title_color','#customize-control-shop_archive_header_description_color','#customize-control-shop_archive_header_border_color','#customize-control-shop_archive_header_border_size','#customize-control-shop_archive_header_padding_top','#customize-control-shop_archive_header_padding_bottom','#customize-control-shop_archive_header_title2','#customize-control-shop_archive_header_button','#customize-control-shop_archive_header_button_background','#customize-control-shop_archive_header_button_border','#customize-control-shop_archive_header_button_border_radius' );
    $wp_customize->get_control( 'botiga_product_catalog_tabs' )->controls_design = json_encode( array_merge( $controls_design, $new_controls_design ) );

    /**
     * General
     */
    // Quantity input styles
    $wp_customize->add_setting( 'shop_general_pro_divider1',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'shop_general_pro_divider1',
            array(
                'section'         => 'botiga_section_catalog_general',
                'priority'        => 21
            )
        )
    );

    $wp_customize->add_setting(
        'shop_general_quantity_style',
        array(
            'default'           => 'style1',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control(
        new Botiga_Radio_Images(
            $wp_customize,
            'shop_general_quantity_style',
            array(
                'label'     => esc_html__( 'Quantity Input Style', 'botiga-pro' ),
                'section'   => 'botiga_section_catalog_general',
                'cols'      => 3,
                'class'     => 'botiga-radio-images-medium',
                'choices'  => array(
                    'style1' => array(
                        'label' => esc_html__( 'Style 1', 'botiga-pro' ),
                        'url'   => '%s/assets/img/qty1.svg'
                    ),
                    'style2' => array(
                        'label' => esc_html__( 'Style 2', 'botiga-pro' ),
                        'url'   => '%s/assets/img/qty2.svg'
                    ),
                    'style3' => array(
                        'label' => esc_html__( 'Style 3', 'botiga-pro' ),
                        'url'   => '%s/assets/img/qty3.svg'
                    ),
                    'style4' => array(
                        'label' => esc_html__( 'Style 4', 'botiga-pro' ),
                        'url'   => '%s/assets/img/qty4.svg'
                    ),
                    'style5' => array(
                        'label' => esc_html__( 'Style 5', 'botiga-pro' ),
                        'url'   => '%s/assets/img/qty5.svg'
                    ),
                    'style6' => array(
                        'label' => esc_html__( 'Style 6', 'botiga-pro' ),
                        'url'   => '%s/assets/img/qty6.svg'
                    ),
                    'style7' => array(
                        'label' => esc_html__( 'Style 7', 'botiga-pro' ),
                        'url'   => '%s/assets/img/qty7.svg'
                    ),
                    'style8' => array(
                        'label' => esc_html__( 'Style 8', 'botiga-pro' ),
                        'url'   => '%s/assets/img/qty8.svg'
                    ),
                    'style9' => array(
                        'label' => esc_html__( 'Style 9', 'botiga-pro' ),
                        'url'   => '%s/assets/img/qty9.svg'
                    )
                ),
                'priority'   => 22
            )
        )
    );

    // Accordion - Layout
    $wp_customize->get_control( 'accordion_shop_layout' )->until = 'shop_archive_pagination_type';

    // Masonry - Layout
    $wp_customize->get_control( 'shop_archive_layout' )->choices['product-masonry'] = esc_html__( 'Masonry', 'botiga-pro' );

    // Shop header styles
    $wp_customize->add_setting( 'shop_archive_pro_divider1',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'shop_archive_pro_divider1',
            array(
                'section'         => 'woocommerce_product_catalog',
                'priority'        => 21
            )
        )
    );

    $wp_customize->add_setting(
        'shop_archive_header_style',
        array(
            'default'           => 'style1',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control(
        new Botiga_Radio_Images(
            $wp_customize,
            'shop_archive_header_style',
            array(
                'label'     => esc_html__( 'Shop Header Style', 'botiga-pro' ),
                'section'   => 'woocommerce_product_catalog',
                'cols'      => 2,
                'choices'  => array(
                    'style1' => array(
                        'label' => esc_html__( 'Style 1', 'botiga-pro' ),
                        'url'   => '%s/assets/img/shop-page-header-style-1.svg'
                    ),
                    'style2' => array(
                        'label' => esc_html__( 'Style 2', 'botiga-pro' ),
                        'url'   => '%s/assets/img/shop-page-header-style-2.svg'
                    ),
                    'style3' => array(
                        'label' => esc_html__( 'Style 3', 'botiga-pro' ),
                        'url'   => '%s/assets/img/shop-page-header-style-3.svg'
                    )       
                ),
                'priority'   => 21
            )
        )
    );

    $wp_customize->add_setting( 
        'shop_archive_header_style_alignment',
        array(
            'default'           => 'center',
            'sanitize_callback' => 'botiga_sanitize_text'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Radio_Buttons( 
            $wp_customize, 
            'shop_archive_header_style_alignment',
            array(
                'label'           => esc_html__( 'Alignment', 'botiga-pro' ),
                'section'         => 'woocommerce_product_catalog',
                'active_callback' => 'botiga_callback_shop_archive_header_style_alignment',
                'choices'         => array(
                    'left'   => esc_html__( 'Left', 'botiga-pro' ),
                    'center' => esc_html__( 'Center', 'botiga-pro' ),
                    'right'  => esc_html__( 'Right', 'botiga-pro' )
                ),
                'priority'        => 21
            )
        ) 
    );

    $wp_customize->add_setting(
        'shop_archive_header_style_show_categories',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'shop_archive_header_style_show_categories',
            array(
                'label'           => esc_html__( 'Show Categories in the Header', 'botiga-pro' ),
                'description'     => esc_html__( 'Controls whether to show or not the products categories in the shop page header.', 'botiga-pro' ),
                'section'         => 'woocommerce_product_catalog',
                'priority'        => 21
            )
        )
    );

    $wp_customize->add_setting(
        'shop_archive_header_style_show_sub_categories',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'shop_archive_header_style_show_sub_categories',
            array(
                'label'           => esc_html__( 'Show Sub Categories in the Header', 'botiga-pro' ),
                'description'     => esc_html__( 'Controls whether to show or not the products categories in the category/taxonomy page header.', 'botiga-pro' ),
                'section'         => 'woocommerce_product_catalog',
                'priority'        => 21
            )
        )
    );

    $wp_customize->add_setting(
        'shop_archive_header_style_hide_cat_term_count',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'shop_archive_header_style_hide_cat_term_count',
            array(
                'label'           => esc_html__( 'Hide categories terms count', 'botiga-pro' ),
                'section'         => 'woocommerce_product_catalog',
                'priority'        => 21
            )
        )
    );

    $wp_customize->add_setting( 'shop_archive_pro_divider2',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'shop_archive_pro_divider2',
            array(
                'section'         => 'woocommerce_product_catalog',
                'priority'        => 22
            )
        )
    );

    // Sidebar
    $wp_customize->get_control( 'shop_archive_sidebar' )->choices = array(
        'no-sidebar'   => array(
            'label' => esc_html__( 'No Sidebar', 'botiga-pro' ),
            'url'   => '%s/assets/img/sidebar-disabled.svg'
        ),
        'sidebar-left' => array(
            'label' => esc_html__( 'Left', 'botiga-pro' ),
            'url'   => '%s/assets/img/sidebar-left.svg'
        ),
        'sidebar-right' => array(
            'label' => esc_html__( 'Right', 'botiga-pro' ),
            'url'   => '%s/assets/img/sidebar-right.svg'
        ),
        // Pro
        'sidebar-top' => array(
            'label' => esc_html__( 'Top', 'botiga-pro' ),
            'url'   => '%s/assets/img/sidebar-top.svg'
        ),
        'sidebar-slide' => array(
            'label' => esc_html__( 'Slide-out', 'botiga-pro' ),
            'url'   => '%s/assets/img/sidebar-slide.svg'
        )
    );
    $wp_customize->get_control( 'shop_archive_sidebar' )->description = esc_html__( 'If the shop widget area is empty, the default widget sidebar area will be shown (the same that is shown in blog pages)', 'botiga-pro' );

    // Shop Sidebar
    $wp_customize->add_setting( 
        'shop_sidebar', 
        array(
            'default'           => '',
            'sanitize_callback' => 'botiga_sanitize_select',
        ) 
    );
    $wp_customize->add_control( 
        'shop_sidebar', 
        array(
            'type'            => 'select',
            'section'         => 'woocommerce_product_catalog',
            'label'           => esc_html__( 'Sidebar', 'botiga-pro' ),
            'choices'         => botiga_pro_get_registered_sidebars(),
            'active_callback' => 'botiga_callback_shop_sidebar',
            'priority'        => 30,
        ) 
    );

    $wp_customize->add_setting(
        'shop_archive_sidebar_open_button_text',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'shop_archive_sidebar_open_button_text', 
        array(
            'label'           => esc_html__( 'Sidebar open button text', 'botiga-pro' ),
            'type'            => 'text',
            'section'         => 'woocommerce_product_catalog',
            'active_callback' => 'botiga_callback_shop_archive_sidebar_slide',
            'priority'        => 31
        ) 
    );

    $wp_customize->add_setting(
        'shop_archive_sidebar_open_icon',
        array(
            'default'           => 1,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'shop_archive_sidebar_open_icon',
            array(
                'label'           => esc_html__( 'Sidebar open icon', 'botiga-pro' ),
                'section'         => 'woocommerce_product_catalog',
                'active_callback' => 'botiga_callback_shop_archive_sidebar_slide',
                'priority'        => 31
            )
        )
    );

    $wp_customize->add_setting(
        'shop_archive_sidebar_filter_in_desktop',
        array(
            'default'           => 1,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'shop_archive_sidebar_filter_in_desktop',
            array(
                'label'           => esc_html__( 'Sidebar Filter in Desktop', 'botiga-pro' ),
                'section'         => 'woocommerce_product_catalog',
                'active_callback' => 'botiga_callback_shop_archive_sidebar_slide',
                'priority'        => 32
            )
        )
    );

    $wp_customize->add_setting( 
        'shop_archive_sidebar_top_columns',
        array(
            'default'           => '4',
            'sanitize_callback' => 'botiga_sanitize_text'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Radio_Buttons( 
            $wp_customize, 
            'shop_archive_sidebar_top_columns',
            array(
                'label'           => esc_html__( 'Sidebar Top Columns', 'botiga-pro' ),
                'section'         => 'woocommerce_product_catalog',
                'choices'         => array(
                    '1' => esc_html__( '1', 'botiga-pro' ),
                    '2' => esc_html__( '2', 'botiga-pro' ),
                    '3' => esc_html__( '3', 'botiga-pro' ),
                    '4' => esc_html__( '4', 'botiga-pro' ),
                ),
                'active_callback' => 'botiga_callback_shop_archive_sidebar_top',
                'priority'        => 31
            )
        ) 
    );

    // Pagination Type
    $wp_customize->add_setting( 'shop_archive_pagination_divider1',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Divider_Control( 
            $wp_customize, 
            'shop_archive_pagination_divider1',
            array(
                'section'           => 'woocommerce_product_catalog',
                'priority'          => 91
            )
        )
    );

    $wp_customize->add_setting( 
        'shop_archive_pagination_title',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Text_Control( 
            $wp_customize, 
            'shop_archive_pagination_title',
            array(
                'label'           => esc_html__( 'Pagination', 'botiga-pro' ),
                'section'         => 'woocommerce_product_catalog',
                'priority'        => 91
            )
        )
    );

    $wp_customize->add_setting( 
        'shop_archive_pagination_type', 
        array(
            'sanitize_callback' => 'botiga_sanitize_select',
            'default'           => 'default'
        ) 
    );
    $wp_customize->add_control( 
        'shop_archive_pagination_type', 
        array(
            'type'      => 'select',
            'section'   => 'woocommerce_product_catalog',
            'label'     => esc_html__( 'Type', 'botiga-pro' ),
            'choices'   => array(
                'default'         => esc_html__( 'Default', 'botiga-pro' ),
                'load-more'       => esc_html__( 'Load More Button', 'botiga-pro' ),
                'infinite-scroll' => esc_html__( 'Infinite Scroll', 'botiga-pro' ),
            ),
            'priority'  => 91
        ) 
    );

    // Cart
    $wp_customize->add_setting( 
        'shop_cart_table_content_layout_style', 
        array(
            'sanitize_callback' => 'botiga_sanitize_select',
            'default'           => 'layout1'
        ) 
    );
    $wp_customize->add_control( 
        'shop_cart_table_content_layout_style', 
        array(
            'type'        => 'select',
            'section'     => 'botiga_section_shop_cart',
            'label'       => esc_html__( 'Table Content Style', 'botiga-pro' ),
            'description' => esc_html__( 'Controls the product tables layout style from cart and wishlist pages.', 'botiga-pro' ),
            'choices'     => array(
                'layout1' => esc_html__( 'Layout 1', 'botiga-pro' ),
                'layout2' => esc_html__( 'Layout 2', 'botiga-pro' )
            ),
            'priority'    => 21
        ) 
    );

    $wp_customize->add_setting(
        'shop_cart_sticky_totals_box',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'shop_cart_sticky_totals_box',
            array(
                'label'             => esc_html__( 'Sticky cart totals box', 'botiga-pro' ),
                'section'           => 'botiga_section_shop_cart',
                'active_callback'   => 'botiga_callback_shop_cart_layout',
                'priority'          => 49
            )
        )
    );

    $wp_customize->add_setting(
        'mini_cart_style',
        array(
            'default'           => 'default',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control(
        new Botiga_Radio_Images(
            $wp_customize,
            'mini_cart_style',
            array(
                'label'     => esc_html__( 'Mini Cart Style', 'botiga-pro' ),
                'section'   => 'botiga_section_shop_cart',
                'cols'      => 2,
                'choices'  => array(
                    'default' => array(
                        'label' => esc_html__( 'Default', 'botiga-pro' ),
                        'url'   => '%s/assets/img/mini-cart-style1.svg'
                    ),
                    'side' => array(
                        'label' => esc_html__( 'Side', 'botiga-pro' ),
                        'url'   => '%s/assets/img/mini-cart-style2.svg'
                    ),      
                ),
                'priority'   => 61
            )
        )
    );

    $wp_customize->add_setting(
        'enable_mini_cart_quantity',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'enable_mini_cart_quantity',
            array(
                'label'    => esc_html__( 'Mini Cart Quantity', 'botiga' ),
                'section'  => 'botiga_section_shop_cart',
                'priority' => 70
            )
        )
    );

    $wp_customize->add_setting(
        'side_mini_cart_ajax_addtc_open',
        array(
            'default'           => 1,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'side_mini_cart_ajax_addtc_open',
            array(
                'label'             => esc_html__( 'Open On Ajax Add To Cart', 'botiga-pro' ),
                'description'       => esc_html__( 'If the default WooCommerce setting "Ajax add to cart" is enabled, open the side mini cart automatically when a product is added to cart.', 'botiga-pro' ),
                'section'           => 'botiga_section_shop_cart',
                'active_callback'   => 'botiga_callback_mini_cart_layout_is_side',
                'priority'          => 61
            )
        )
    );

    // Floating Mini Cart Icon
    $wp_customize->add_setting(
        'side_mini_cart_floating_icon',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'side_mini_cart_floating_icon',
            array(
                'label'             => esc_html__( 'Floating Mini Cart Icon', 'botiga-pro' ),
                'section'           => 'botiga_section_shop_cart',
                'active_callback'   => 'botiga_callback_mini_cart_layout_is_side',
                'priority'          => 61
            )
        )
    );

    // Learn more about the feature (Floating Mini Cart Icon)
    $wp_customize->add_setting(
        'side_mini_cart_floating_icon_info',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        new Botiga_Text_Control(
            $wp_customize,
            'side_mini_cart_floating_icon_info',
            array(
                'description'       => esc_html__( 'Displays a floating mini cart icon that opens the side mini cart when clicked. Learn more about this feature in our documentation by clicking on the below link.', 'botiga-pro' ),
                'link_title'        => esc_html__( 'Learn more', 'botiga-pro' ),
                'link'              => 'https://docs.athemes.com/article/floating-mini-cart-icon/',
                'check_white_label' => true,
                'section'           => 'botiga_section_shop_cart',
                'priority'          => 61
            )
        )
    );

    // Floating Mini Cart Icon Go To Section Link
    $wp_customize->add_setting( 'side_mini_cart_floating_icon_goto_section',
        array(
            'default' 			=> '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( new Botiga_Text_Control( $wp_customize, 'side_mini_cart_floating_icon_goto_section',
            array(
                'description' 	=> '<span class="customize-control-title" style="font-style: normal;"></span><a class="botiga-to-widget-area-link" href="javascript:wp.customize.section( \'side_mini_cart_floating_icon_section\' ).focus();">' . esc_html__( 'Floating Mini Cart Icon Settings', 'botiga-pro' ) . '<span class="dashicons dashicons-arrow-right-alt2"></span></a>',
                'section' 		=> 'botiga_section_shop_cart',
                'active_callback'   => 'botiga_callback_mini_cart_floating_icon_enabled',
                'priority' 		=> 61
            )
        )
    );

    // Floating Mini Cart Icon Section
    $wp_customize->add_section(
        'side_mini_cart_floating_icon_section',
        array(
            'title'         => esc_html__( 'Floating Mini Cart Icon', 'botiga-pro'),
            'priority'      => 135,
        )
    );

    // Floating Mini Cart Icon Tabs
    $wp_customize->add_setting(
        'side_mini_cart_floating_icon_tabs',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control(
        new Botiga_Tab_Control (
            $wp_customize,
            'side_mini_cart_floating_icon_tabs',
            array(
                'label' 				=> '',
                'section'       		=> 'side_mini_cart_floating_icon_section',
                'controls_general'		=> json_encode(
                    array(
                        '#customize-control-side_mini_cart_floating_icon_display',
                        '#customize-control-side_mini_cart_floating_icon_icon',
                        '#customize-control-side_mini_cart_floating_icon_custom_image',
                        '#customize-control-side_mini_cart_floating_icon_size',
                        '#customize-control-side_mini_cart_floating_icon_position',
                        '#customize-control-side_mini_cart_floating_icon_corner_offset'
                    )
                ),
                'controls_design'		=> json_encode(
                    array(
                        '#customize-control-side_mini_cart_floating_icon_icon_color',
                        '#customize-control-side_mini_cart_floating_icon_background_color',
                        '#customize-control-side_mini_cart_floating_icon_border_radius',
                        '#customize-control-side_mini_cart_floating_icon_shadow',
                        '#customize-control-side_mini_cart_floating_icon_counter_color',
                        '#customize-control-side_mini_cart_floating_icon_counter_background_color'
                    )
                ),
                'priority' 				=> 21
            )
        )
    );

    /*
     * General (Floating Mini Cart Icon Tabs)
     */

    // Floating Mini Cart Icon Display
    $wp_customize->add_setting( 
        'side_mini_cart_floating_icon_display', 
        array(
            'sanitize_callback' => 'botiga_sanitize_select',
            'default'           => 'cart-not-empty'
        ) 
    );
    $wp_customize->add_control( 
        'side_mini_cart_floating_icon_display', 
        array(
            'type'      => 'select',
            'section'   => 'side_mini_cart_floating_icon_section',
            'label'     => esc_html__( 'Display', 'botiga-pro' ),
            'choices'   => array(
                'cart-not-empty' => esc_html__( 'When cart is not empty', 'botiga-pro' ),
                'always'         => esc_html__( 'Always', 'botiga-pro' )
            ),
            'priority'  => 30
        ) 
    );

    // Floating Mini Cart Icon
    $wp_customize->add_setting(
        'side_mini_cart_floating_icon_icon',
        array(
            'default'           => 'icon-cart',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control(
        new Botiga_Radio_Images(
            $wp_customize,
            'side_mini_cart_floating_icon_icon',
            array(
                'label'    	=> esc_html__( 'Icon', 'botiga-pro' ),
                'section'  	=> 'side_mini_cart_floating_icon_section',
                'cols'		=> 4,
                'class'     => 'botiga-radio-images-medium',
                'choices'  	=> array(			
                    'icon-cart'  => array(
                        'label'  => esc_html__( 'Icon 1', 'botiga-pro' ),
                        'url'    => '%s/assets/img/cart-icon1.svg'
                    ),
                    'icon-cart2' => array(
                        'label'  => esc_html__( 'Icon 2', 'botiga-pro' ),
                        'url'    => '%s/assets/img/cart-icon2.svg'
                    ),
                    'icon-cart3' => array(
                        'label'  => esc_html__( 'Icon 3', 'botiga-pro' ),
                        'url'    => '%s/assets/img/cart-icon3.svg'
                    ),
                    'icon-cart4' => array(
                        'label'  => esc_html__( 'Icon 4', 'botiga-pro' ),
                        'url'    => '%s/assets/img/cart-icon4.svg'
                    ),
                    'icon-cart5' => array(
                        'label'  => esc_html__( 'Icon 5', 'botiga-pro' ),
                        'url'    => '%s/assets/img/cart-icon5.svg'
                    ),
                    'icon-custom' => array(
                        'label'  => esc_html__( 'Custom Icon', 'botiga-pro' ),
                        'url'    => '%s/assets/img/upload-custom-icon.svg'
                    )
                ),
                'priority'		  => 35
            )
        )
    );

    // Custom My Account Icon - Image
    $wp_customize->add_setting( 
        'side_mini_cart_floating_icon_custom_image',
        array(
            'default'           => '',
            'sanitize_callback' => 'absint',
        ) 
    );
    $wp_customize->add_control( 
        new WP_Customize_Media_Control( 
            $wp_customize, 
            'side_mini_cart_floating_icon_custom_image',
            array(
                'label'           => '',
                'section'         => 'side_mini_cart_floating_icon_section',
                'mime_type'       => 'image',
                'active_callback' => 'side_mini_cart_floating_icon_custom',
                'priority'        => 35
            )
        )
    );

    // Floating Mini Cart Icon Size
    $wp_customize->add_setting( 
        'side_mini_cart_floating_icon_size', 
        array(
            'default'           => 18,
            'transport'         => 'postMessage',
            'sanitize_callback' => 'absint'
        ) 
    );          
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'side_mini_cart_floating_icon_size',
            array(
                'label'         => esc_html__( 'Icon Size', 'botiga-pro' ),
                'section'       => 'side_mini_cart_floating_icon_section',
                'is_responsive' => 0,
                'settings'      => array (
                    'size_desktop'      => 'side_mini_cart_floating_icon_size',
                ),
                'input_attrs' => array (
                    'min'   => 13,
                    'max'   => 20,
                    'step'  => 1
                ),
                'priority'      => 36
            )
        ) 
    );

    // Floating Mini Cart Icon Position
    $wp_customize->add_setting( 'side_mini_cart_floating_icon_position',
        array(
            'default' 			=> 'right',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control( new Botiga_Radio_Buttons( $wp_customize, 'side_mini_cart_floating_icon_position',
        array(
            'label' 	=> esc_html__( 'Position', 'botiga-pro' ),
            'section' 	=> 'side_mini_cart_floating_icon_section',
            'choices' 	=> array(
                'left' 	  => esc_html__( 'Left', 'botiga-pro' ),
                'right'   => esc_html__( 'Right', 'botiga-pro' ),
            ),
            'priority'	 => 40
        )
    ) );

    // Floating Mini Cart Icon Position Offset
    $wp_customize->add_setting( 
        'side_mini_cart_floating_icon_corner_offset_desktop', 
        array(
            'default'           => 30,
            'transport'         => 'postMessage',
            'sanitize_callback' => 'absint'
        ) 
    ); 
    $wp_customize->add_setting( 
        'side_mini_cart_floating_icon_corner_offset_tablet', 
        array(
            'default'           => 30,
            'transport'         => 'postMessage',
            'sanitize_callback' => 'absint'
        ) 
    );
    $wp_customize->add_setting( 
        'side_mini_cart_floating_icon_corner_offset_mobile', 
        array(
            'default'           => 30,
            'transport'         => 'postMessage',
            'sanitize_callback' => 'absint'
        ) 
    ); 
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'side_mini_cart_floating_icon_corner_offset',
            array(
                'label'         => esc_html__( 'Corner Offset', 'botiga-pro' ),
                'description'   => esc_html__( 'Controls the distance from corner.', 'botiga-pro' ),
                'section'       => 'side_mini_cart_floating_icon_section',
                'is_responsive' => 1,
                'settings'      => array (
                    'size_desktop'      => 'side_mini_cart_floating_icon_corner_offset_desktop',
                    'size_tablet'       => 'side_mini_cart_floating_icon_corner_offset_tablet',
                    'size_mobile'       => 'side_mini_cart_floating_icon_corner_offset_mobile'
                ),
                'input_attrs' => array (
                    'min'   => 0,
                    'max'   => 200,
                    'step'  => 1
                ),
                'priority'      => 45
            )
        ) 
    );

    /*
     * Style (Floating Mini Cart Icon Tabs)
     */

    // Floating Mini Cart Icon Color
    $wp_customize->add_setting(
        'side_mini_cart_floating_icon_icon_color',
        array(
            'default'           => '#FFF',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'side_mini_cart_floating_icon_icon_color',
            array(
                'label'             => esc_html__( 'Icon Color', 'botiga-pro' ),
                'section'           => 'side_mini_cart_floating_icon_section',
                'priority'          => 50
            )
        )
    );

    // Floating Mini Cart Icon Background Color
    $wp_customize->add_setting(
        'side_mini_cart_floating_icon_background_color',
        array(
            'default'           => '#212121',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'side_mini_cart_floating_icon_background_color',
            array(
                'label'             => esc_html__( 'Background Color', 'botiga-pro' ),
                'section'           => 'side_mini_cart_floating_icon_section',
                'priority'          => 55
            )
        )
    );

    // Floating Mini Cart Icon Counter Colors
    $wp_customize->add_setting(
        'side_mini_cart_floating_icon_counter_color',
        array(
            'default'           => '#FFF',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'side_mini_cart_floating_icon_counter_color',
            array(
                'label'             => esc_html__( 'Counter Color', 'botiga-pro' ),
                'section'           => 'side_mini_cart_floating_icon_section',
                'priority'          => 60
            )
        )
    );

    // Floating Mini Cart Icon Counter Background
    $wp_customize->add_setting(
        'side_mini_cart_floating_icon_counter_background_color',
        array(
            'default'           => '#757575',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'side_mini_cart_floating_icon_counter_background_color',
            array(
                'label'             => esc_html__( 'Counter Background Color', 'botiga-pro' ),
                'section'           => 'side_mini_cart_floating_icon_section',
                'priority'          => 65
            )
        )
    );

    // Floating Mini Cart Icon Border Radius
    $wp_customize->add_setting( 
        'side_mini_cart_floating_icon_border_radius', 
        array(
            'default'           => 35,
            'transport'         => 'postMessage',
            'sanitize_callback' => 'absint'
        ) 
    );          
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'side_mini_cart_floating_icon_border_radius',
            array(
                'label'         => esc_html__( 'Border Radius', 'botiga-pro' ),
                'section'       => 'side_mini_cart_floating_icon_section',
                'is_responsive' => 0,
                'settings'      => array (
                    'size_desktop'      => 'side_mini_cart_floating_icon_border_radius',
                ),
                'input_attrs' => array (
                    'min'   => 0,
                    'max'   => 35,
                    'step'  => 1
                ),
                'priority'      => 70
            )
        ) 
    );

    // Floating Mini Cart Icon Display Shadow
    $wp_customize->add_setting(
        'side_mini_cart_floating_icon_shadow',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'side_mini_cart_floating_icon_shadow',
            array(
                'label'             => esc_html__( 'Display Shadow', 'botiga-pro' ),
                'section'           => 'side_mini_cart_floating_icon_section',
                'priority'          => 75
            )
        )
    );

    // Checkout
    $free_layouts = $wp_customize->get_control( 'shop_checkout_layout' )->choices;
    $wp_customize->get_control( 'shop_checkout_layout' )->cols = 3;
    $wp_customize->get_control( 'shop_checkout_layout' )->choices = array_merge(
        $free_layouts,
        array(
            'layout3' => array(
                'label' => esc_html__( 'Layout 3 (Multi Step)', 'botiga-pro' ),
                'url'   => '%s/assets/img/checkout3.svg'
            )       
        ),
        array(
            'layout4' => array(
                'label' => esc_html__( 'Layout 4 (Shopify Multi Step)', 'botiga-pro' ),
                'url'   => '%s/assets/img/checkout4.svg'
            )       
        ),
        array(
            'layout5' => array(
                'label' => esc_html__( 'Layout 5 (Shopify One Step)', 'botiga-pro' ),
                'url'   => '%s/assets/img/checkout5.svg'
            )       
        ),
    );
    $wp_customize->get_control( 'shop_checkout_layout' )->priority = 1;
    $wp_customize->get_control( 'shop_checkout_show_coupon_form' )->priority = 1;
    
    $wp_customize->add_setting(
        'checkout_sticky_totals_box',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'checkout_sticky_totals_box',
            array(
                'label'             => esc_html__( 'Sticky Checkout Totals Box', 'botiga-pro' ),
                'section'           => 'woocommerce_checkout',
                'active_callback'   => 'botiga_callback_shop_checkout_layout',
                'priority'          => 1
            )
        )
    );

    $wp_customize->add_setting(
        'checkout_distraction_free',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'checkout_distraction_free',
            array(
                'label'             => esc_html__( 'Distraction Free Checkout', 'botiga-pro' ),
                'section'           => 'woocommerce_checkout',
                'priority'          => 1
            )
        )
    );

    /**
     * Styling
     */

    // Shop Header Styles
    $wp_customize->add_setting( 
        'shop_archive_header_styling_layout', 
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control(
        new Botiga_Accordion_Control(
            $wp_customize,
            'shop_archive_header_styling_layout',
            array(
                'label'         => esc_html__( 'Layout', 'botiga-pro' ),
                'section'       => 'woocommerce_product_catalog',
                'until'         => 'shop_archive_header_button_border_radius',
                'priority'      => 271
            )
        )
    );

    $wp_customize->add_setting( 
        'shop_archive_header_title1',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Text_Control( 
            $wp_customize, 
            'shop_archive_header_title1',
            array(
                'label'         => esc_html__( 'Header Style', 'botiga-pro' ),
                'section'       => 'woocommerce_product_catalog',
                'priority'      => 271
            )
        )
    );

    $wp_customize->add_setting(
        'shop_archive_header_background_color',
        array(
            'default'           => '#FFF',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'shop_archive_header_background_color',
            array(
                'label'             => esc_html__( 'Background Color', 'botiga-pro' ),
                'section'           => 'woocommerce_product_catalog',
                'priority'          => 271
            )
        )
    );

    $wp_customize->add_setting( 
        'shop_archive_header_background_image',
        array(
            'default'           => '',
            'sanitize_callback' => 'absint',
        ) 
    );
    $wp_customize->add_control( 
        new WP_Customize_Media_Control( 
            $wp_customize, 
            'shop_archive_header_background_image',
            array(
                'label'           => __( 'Background Image', 'botiga' ),
                'section'         => 'woocommerce_product_catalog',
                'mime_type'       => 'image',
                'priority'	      => 271
            )
        )
    );

    $wp_customize->add_setting( 
        'shop_archive_header_background_size',
        array(
            'default'           => 'cover',
            'sanitize_callback' => 'botiga_sanitize_select',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        'shop_archive_header_background_size',
        array(
            'type' 		      => 'select',
            'label' 	      => esc_html__( 'Background Size', 'botiga' ),
            'choices'         => array(
                'cover'   => esc_html__( 'Cover', 'botiga' ),
                'contain' => esc_html__( 'Contain', 'botiga' )
            ),
            'section' 	      => 'woocommerce_product_catalog',
            'active_callback' => function(){ return get_theme_mod( 'shop_archive_header_background_image' ) ? true : false; },
            'priority'        => 271
        )
    );
    
    $wp_customize->add_setting( 
        'shop_archive_header_background_position',
        array(
            'default'           => 'center',
            'sanitize_callback' => 'botiga_sanitize_select',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        'shop_archive_header_background_position',
        array(
            'type' 		      => 'select',
            'label' 	      => esc_html__( 'Background Position', 'botiga' ),
            'choices'         => array(
                'top'    => esc_html__( 'Top', 'botiga' ),
                'center' => esc_html__( 'Center', 'botiga' ),
                'bottom' => esc_html__( 'Bottom', 'botiga' )
            ),
            'section' 	      => 'woocommerce_product_catalog',
            'active_callback' => function(){ return get_theme_mod( 'shop_archive_header_background_image' ) ? true : false; },
            'priority'        => 271
        )
    );
    
    $wp_customize->add_setting( 
        'shop_archive_header_background_repeat',
        array(
            'default'           => 'no-repeat',
            'sanitize_callback' => 'botiga_sanitize_select',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        'shop_archive_header_background_repeat',
        array(
            'type' 		      => 'select',
            'label' 	      => esc_html__( 'Background Repeat', 'botiga' ),
            'choices'         => array(
                'no-repeat' => esc_html__( 'No Repeat', 'botiga' ),
                'repeat'    => esc_html__( 'Repeat', 'botiga' )
            ),
            'section' 	      => 'woocommerce_product_catalog',
            'active_callback' => function(){ return get_theme_mod( 'shop_archive_header_background_image' ) ? true : false; },
            'priority'        => 271
        )
    );

    $wp_customize->add_setting(
        'shop_archive_header_title_color',
        array(
            'default'           => '#212121',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'shop_archive_header_title_color',
            array(
                'label'             => esc_html__( 'Title Color', 'botiga-pro' ),
                'section'           => 'woocommerce_product_catalog',
                'priority'          => 271
            )
        )
    );

    $wp_customize->add_setting(
        'shop_archive_header_description_color',
        array(
            'default'           => '#212121',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'shop_archive_header_description_color',
            array(
                'label'             => esc_html__( 'Description Color', 'botiga-pro' ),
                'section'           => 'woocommerce_product_catalog',
                'priority'          => 271
            )
        )
    );

    $wp_customize->add_setting(
        'shop_archive_header_border_color',
        array(
            'default'           => 'transparent',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'shop_archive_header_border_color',
            array(
                'label'             => esc_html__( 'Border Color', 'botiga-pro' ),
                'section'           => 'woocommerce_product_catalog',
                'priority'          => 271
            )
        )
    );

    if( class_exists( 'Botiga_Dimensions_Control' ) ) {
        $wp_customize->add_setting( 
            'shop_archive_header_border_size_desktop',
            array(
                'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
                'sanitize_callback' => 'botiga_sanitize_text',
                'transport'         => 'postMessage'
            ) 
        );
        $wp_customize->add_control( 
            new Botiga_Dimensions_Control( 
                $wp_customize, 
                'shop_archive_header_border_size',
                array(
                    'label'           	=> __( 'Border Size', 'botiga' ),
                    'section'         	=> 'woocommerce_product_catalog',
                    'sides'             => array(
                        'top'    => true,
                        'right'  => true,
                        'bottom' => true,
                        'left'   => true
                    ),
                    'units'              => array( 'px' ),
                    'link_values_toggle' => true,
                    'is_responsive'   	 => false,
                    'settings'        	 => array(
                        'desktop' => 'shop_archive_header_border_size_desktop'
                    ),
                    'priority'	      	 => 271
                )
            )
        );
    }

    $wp_customize->add_setting( 
        'shop_archive_header_padding_top', 
        array(
            'default'           => 80,
            'transport'         => 'postMessage',
            'sanitize_callback' => 'absint',
        ) 
    );          
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'shop_archive_header_padding_top',
            array(
                'label'         => esc_html__( 'Top Spacing', 'botiga-pro' ),
                'section'       => 'woocommerce_product_catalog',
                'is_responsive' => 0,
                'settings'      => array (
                    'size_desktop'      => 'shop_archive_header_padding_top',
                ),
                'input_attrs' => array (
                    'min'   => 0,
                    'max'   => 200,
                    'step'  => 1
                ),
                'priority'      => 271
            )
        ) 
    );

    $wp_customize->add_setting( 
        'shop_archive_header_padding_bottom', 
        array(
            'default'           => 80,
            'transport'         => 'postMessage',
            'sanitize_callback' => 'absint',
        ) 
    );          
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'shop_archive_header_padding_bottom',
            array(
                'label'         => esc_html__( 'Bottom Spacing', 'botiga-pro' ),
                'section'       => 'woocommerce_product_catalog',
                'is_responsive' => 0,
                'settings'      => array (
                    'size_desktop'      => 'shop_archive_header_padding_bottom',
                ),
                'input_attrs' => array (
                    'min'   => 0,
                    'max'   => 200,
                    'step'  => 1
                ),
                'priority'      => 271
            )
        ) 
    );

    $wp_customize->add_setting( 
        'shop_archive_header_title2',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Text_Control( 
            $wp_customize, 
            'shop_archive_header_title2',
            array(
                'label'         => esc_html__( 'Header Style - Category Buttons', 'botiga-pro' ),
                'section'       => 'woocommerce_product_catalog',
                'priority'      => 271
            )
        )
    );

    $wp_customize->add_setting(
        'shop_archive_header_button_color',
        array(
            'default'           => '#212121',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_setting(
        'shop_archive_header_button_color_hover',
        array(
            'default'           => '#FFF',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Color_Group(
            $wp_customize,
            'shop_archive_header_button',
            array(
                'label'    => esc_html__( 'Text Color', 'botiga-pro' ),
                'section'  => 'woocommerce_product_catalog',
                'settings' => array(
                    'normal' => 'shop_archive_header_button_color',
                    'hover'  => 'shop_archive_header_button_color_hover',
                ),
                'priority' => 271
            )
        )
    );

    $wp_customize->add_setting(
        'shop_archive_header_button_background_color',
        array(
            'default'           => '#FFF',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_setting(
        'shop_archive_header_button_background_color_hover',
        array(
            'default'           => '#212121',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Color_Group(
            $wp_customize,
            'shop_archive_header_button_background',
            array(
                'label'    => esc_html__( 'Background Color', 'botiga-pro' ),
                'section'  => 'woocommerce_product_catalog',
                'settings' => array(
                    'normal' => 'shop_archive_header_button_background_color',
                    'hover'  => 'shop_archive_header_button_background_color_hover',
                ),
                'priority' => 271
            )
        )
    );

    $wp_customize->add_setting(
        'shop_archive_header_button_border_color',
        array(
            'default'           => '#212121',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_setting(
        'shop_archive_header_button_border_color_hover',
        array(
            'default'           => '#212121',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Color_Group(
            $wp_customize,
            'shop_archive_header_button_border',
            array(
                'label'    => esc_html__( 'Border Color', 'botiga-pro' ),
                'section'  => 'woocommerce_product_catalog',
                'settings' => array(
                    'normal' => 'shop_archive_header_button_border_color',
                    'hover'  => 'shop_archive_header_button_border_color_hover',
                ),
                'priority' => 271
            )
        )
    );

    $wp_customize->add_setting( 
        'shop_archive_header_button_border_radius', 
        array(
            'default'           => 35,
            'transport'         => 'postMessage',
            'sanitize_callback' => 'absint',
        ) 
    );          
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'shop_archive_header_button_border_radius',
            array(
                'label'         => esc_html__( 'Border Radius', 'botiga-pro' ),
                'section'       => 'woocommerce_product_catalog',
                'is_responsive' => 0,
                'settings'      => array (
                    'size_desktop'      => 'shop_archive_header_button_border_radius',
                ),
                'input_attrs' => array (
                    'min'   => 0,
                    'max'   => 35,
                    'step'  => 1
                ),
                'priority'      => 271
            )
        ) 
    );

    // Columns gap
    $wp_customize->add_setting( 
        'shop_archive_columns_gap_title3',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Text_Control( 
            $wp_customize, 
            'shop_archive_columns_gap_title3',
            array(
                'label'         => esc_html__( 'Columns', 'botiga-pro' ),
                'section'       => 'woocommerce_product_catalog',
                'priority'      => 1
            )
        )
    );

    $wp_customize->add_setting( 
        'shop_archive_columns_gap_desktop', 
        array(
            'default'           => 30,
            'transport'         => 'postMessage',
            'sanitize_callback' => 'absint'
        ) 
    );
    $wp_customize->add_setting( 
        'shop_archive_columns_gap_tablet', 
        array(
            'default'           => 30,
            'transport'         => 'postMessage',
            'sanitize_callback' => 'absint'
        ) 
    );
    $wp_customize->add_setting( 
        'shop_archive_columns_gap_mobile', 
        array(
            'default'           => 20,
            'transport'         => 'postMessage',
            'sanitize_callback' => 'absint'
        ) 
    );          
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'shop_archive_columns_gap_desktop',
            array(
                'label'         => esc_html__( 'Products Gap', 'botiga-pro' ),
                'section'       => 'woocommerce_product_catalog',
                'is_responsive' => 1,
                'settings'      => array (
                    'size_desktop'      => 'shop_archive_columns_gap_desktop',
                    'size_tablet'       => 'shop_archive_columns_gap_tablet',
                    'size_mobile'       => 'shop_archive_columns_gap_mobile'
                ),
                'input_attrs' => array (
                    'min'   => 0,
                    'max'   => 200,
                    'step'  => 1
                ),
                'priority'      => 1
            )
        ) 
    );

    // Product Stock
    $wp_customize->add_setting(
        'shop_product_stock',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'shop_product_stock',
            array(
                'label'    => esc_html__( 'Product Stock', 'botiga-pro' ),
                'section'  => 'woocommerce_product_catalog',
                'priority' => 120
            )
        )
    );

    // Product Quantity
    $wp_customize->add_setting(
        'shop_product_quantity',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'shop_product_quantity',
            array(
                'label'    => esc_html__( 'Product Quantity', 'botiga-pro' ),
                'section'  => 'woocommerce_product_catalog',
                'priority' => 120
            )
        )
    );

    // Grid & List View
    $wp_customize->add_setting(
        'shop_grid_list_view',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'shop_grid_list_view',
            array(
                'label'    => esc_html__( 'Grid & List View', 'botiga-pro' ),
                'section'  => 'woocommerce_product_catalog',
                'priority' => 81
            )
        )
    );

    // Pagination (Posts Per Page)
    $wp_customize->add_setting(
        'shop_pagination_ppp',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'shop_pagination_ppp',
            array(
                'label'    => esc_html__( 'Posts Per Page', 'botiga-pro' ),
                'section'  => 'woocommerce_product_catalog',
                'priority' => 82
            )
        )
    );

    // Image Swap
    $wp_customize->add_setting(
        'shop_product_image_swap',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'shop_product_image_swap',
            array(
                'label'             => esc_html__( 'Product Image Swap', 'botiga-pro' ),
                'description'       => esc_html__( 'Swap product image when mouse over. The product needs to have more than one image to get this feature working.', 'botiga-pro' ),
                'section'           => 'woocommerce_product_catalog',
                'priority'          => 120
            )
        )
    );

}
add_action( 'customize_register', 'botiga_pro_woocommerce_options', 999 );