<?php
/**
 * Hooks
 *
 * @package Botiga_Pro
 */

function botiga_hooks_section_description() {
    $desc = sprintf(
        __( 'Using these fields, you can insert custom HTML or shortcodes in various positions across the theme. Also, some <a href="%s" target="_blank">text markup variables</a> are available.', 'botiga-pro' ),
        'https://docs.athemes.com/article/437-pro-hooks'
    );

    if( defined( 'BOTIGA_AWL_ACTIVE' ) ) {
        $desc = __( 'Using these fields, you can insert custom HTML or shortcodes in various positions across the website.', 'botiga-pro' );
    }

    return wp_kses_post( $desc );
}

function botiga_hook_options( $wp_customize ) {
    $wp_customize->add_panel(
        'botiga_panel_hooks',
        array(
            'title'    => esc_html__( 'Hooks', 'botiga-pro' ),
            'priority' => 190,
        )
    );

    // General 
    $wp_customize->add_section(
        'botiga_section_hooks_general',
        array(
            'title'      => esc_html__( 'General', 'botiga-pro' ),
            'panel'      => 'botiga_panel_hooks',
            'description'   => botiga_hooks_section_description()
        )
    );

    $wp_customize->add_setting(
        'botiga_hook_wp_head',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_wp_head', 
        array(
            'label'           => esc_html__( 'wp_head', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: wp_head', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_general',
            'priority'        => 10
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_wp_body_open',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_wp_body_open', 
        array(
            'label'           => esc_html__( 'wp_body_open', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: wp_body_open', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_general',
            'priority'        => 20
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_before_site',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_before_site', 
        array(
            'label'           => esc_html__( 'Before Site', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_before_site', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_general',
            'priority'        => 30
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_after_site',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_after_site', 
        array(
            'label'           => esc_html__( 'After Site', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_after_site', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_general',
            'priority'        => 40
        ) 
    );

    // Header
    $wp_customize->add_section(
        'botiga_section_hooks_header',
        array(
            'title'      => esc_html__( 'Header', 'botiga-pro' ),
            'panel'      => 'botiga_panel_hooks',
            'description'   => botiga_hooks_section_description()
        )
    );

    $wp_customize->add_setting(
        'botiga_hook_before_header',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_before_header', 
        array(
            'label'           => esc_html__( 'Before Header', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_before_header', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_header',
            'priority'        => 10
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_after_header',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_after_header', 
        array(
            'label'           => esc_html__( 'After Header', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_after_header', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_header',
            'priority'        => 20
        ) 
    );

    // Content
    $wp_customize->add_section(
        'botiga_section_hooks_content',
        array(
            'title'      => esc_html__( 'Content', 'botiga-pro' ),
            'panel'      => 'botiga_panel_hooks',
            'description'   => botiga_hooks_section_description()
        )
    );

    $wp_customize->add_setting(
        'botiga_hook_before_page_header',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_before_page_header', 
        array(
            'label'           => esc_html__( 'Before Page Header', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_before_page_header', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_content',
            'priority'        => 10
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_after_page_header',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_after_page_header', 
        array(
            'label'           => esc_html__( 'After Page Header', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_after_page_header', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_content',
            'priority'        => 20
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_before_main_wrapper',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_before_main_wrapper', 
        array(
            'label'           => esc_html__( 'Before Main Wrapper', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_before_main_wrapper', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_content',
            'priority'        => 30
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_after_main_wrapper',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_after_main_wrapper', 
        array(
            'label'           => esc_html__( 'After Main Wrapper', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_after_main_wrapper', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_content',
            'priority'        => 40
        ) 
    );

    // WooCommerce
    if( class_exists( 'Woocommerce' ) ) {

        $wp_customize->add_section(
            'botiga_section_hooks_woocommerce',
            array(
                'title'      => esc_html__( 'WooCommerce', 'botiga-pro' ),
                'panel'      => 'botiga_panel_hooks',
                'description'   => botiga_hooks_section_description()
            )
        );

        // Shop General
        $wp_customize->add_setting( 'botiga_section_hooks_woocommerce_shop_general', 
            array(
                'sanitize_callback' => 'esc_attr'
            )
        );
        $wp_customize->add_control(
            new Botiga_Accordion_Control(
                $wp_customize,
                'botiga_section_hooks_woocommerce_shop_general',
                array(
                    'label'         => esc_html__( 'General', 'botiga-pro' ),
                    'section'       => 'botiga_section_hooks_woocommerce',
                    'until'         => 'botiga_hook_woocommerce_after_main_content',
                    'priority'      => 10
                )
            )
        );
    
        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_main_content',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_main_content', 
            array(
                'label'           => esc_html__( 'Before Main Content', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_main_content', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 20
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_main_content',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_main_content', 
            array(
                'label'           => esc_html__( 'After Main Content', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_main_content', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 30
            ) 
        );

        // Shop Archive
        $wp_customize->add_setting( 'botiga_section_hooks_woocommerce_shop_archive', 
            array(
                'sanitize_callback' => 'esc_attr'
            )
        );
        $wp_customize->add_control(
            new Botiga_Accordion_Control(
                $wp_customize,
                'botiga_section_hooks_woocommerce_shop_archive',
                array(
                    'label'         => esc_html__( 'Shop Archive', 'botiga-pro' ),
                    'section'       => 'botiga_section_hooks_woocommerce',
                    'until'         => 'botiga_hook_woocommerce_after_shop_loop_item_title',
                    'priority'      => 40
                )
            )
        );
        
        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_page_header_shop_loop',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_page_header_shop_loop', 
            array(
                'label'           => esc_html__( 'Before Header Shop Loop', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_page_header_shop_loop', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 40
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_page_header_shop_loop',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_page_header_shop_loop', 
            array(
                'label'           => esc_html__( 'After Page Header Shop Loop', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_page_header_shop_loop', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 40
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_shop_loop',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_shop_loop', 
            array(
                'label'           => esc_html__( 'Before Shop Loop', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_shop_loop', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 40
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_shop_loop',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_shop_loop', 
            array(
                'label'           => esc_html__( 'After Shop Loop', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_shop_loop', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 50
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_shop_loop_item',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_shop_loop_item', 
            array(
                'label'           => esc_html__( 'Before Shop Loop Item', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_shop_loop_item', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 60
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_shop_loop_item',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_shop_loop_item', 
            array(
                'label'           => esc_html__( 'After Shop Loop Item', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_shop_loop_item', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 60
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_shop_loop_item_title',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_shop_loop_item_title', 
            array(
                'label'           => esc_html__( 'Before Shop Loop Item Title', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_shop_loop_item_title', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 70
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_shop_loop_item_title',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_shop_loop_item_title', 
            array(
                'label'           => esc_html__( 'After Shop Loop Item Title', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_shop_loop_item_title', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 80
            ) 
        );

        // Shop Single
        $wp_customize->add_setting( 'botiga_section_hooks_woocommerce_shop_single', 
            array(
                'sanitize_callback' => 'esc_attr'
            )
        );
        $wp_customize->add_control(
            new Botiga_Accordion_Control(
                $wp_customize,
                'botiga_section_hooks_woocommerce_shop_single',
                array(
                    'label'         => esc_html__( 'Shop Single', 'botiga-pro' ),
                    'section'       => 'botiga_section_hooks_woocommerce',
                    'until'         => 'botiga_hook_woocommerce_product_meta_end',
                    'priority'      => 90
                )
            )
        );
    
        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_single_product',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_single_product', 
            array(
                'label'           => esc_html__( 'Before Single Product', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_single_product', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 100
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_single_product',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_single_product', 
            array(
                'label'           => esc_html__( 'After Single Product', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_single_product', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 110
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_single_product_summary',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_single_product_summary', 
            array(
                'label'           => esc_html__( 'Before Single Product Summary', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_single_product_summary', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 120
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_single_product_summary',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_single_product_summary', 
            array(
                'label'           => esc_html__( 'After Single Product Summary', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_single_product_summary', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 130
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_add_to_cart_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_add_to_cart_form', 
            array(
                'label'           => esc_html__( 'Before Add To Cart Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_add_to_cart_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 140
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_add_to_cart_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_add_to_cart_form', 
            array(
                'label'           => esc_html__( 'After Add To Cart Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_add_to_cart_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 150
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_add_to_cart_button',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_add_to_cart_button', 
            array(
                'label'           => esc_html__( 'Before Add To Cart Button', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_add_to_cart_button', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 160
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_add_to_cart_button',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_add_to_cart_button', 
            array(
                'label'           => esc_html__( 'After Add To Cart Button', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_add_to_cart_button', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 170
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_add_to_cart_quantity',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_add_to_cart_quantity', 
            array(
                'label'           => esc_html__( 'Before Add To Cart Quantity', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_add_to_cart_quantity', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 180
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_add_to_cart_quantity',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_add_to_cart_quantity', 
            array(
                'label'           => esc_html__( 'After Add To Cart Quantity', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_add_to_cart_quantity', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 190
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_product_meta_start',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_product_meta_start', 
            array(
                'label'           => esc_html__( 'Product Meta Start', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: botiga_hook_woocommerce_product_meta_start', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 200
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_product_meta_end',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_product_meta_end', 
            array(
                'label'           => esc_html__( 'Product Meta End', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: botiga_hook_woocommerce_product_meta_end', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 210
            ) 
        );

        // Shop Cart
        $wp_customize->add_setting( 'botiga_section_hooks_woocommerce_shop_cart', 
            array(
                'sanitize_callback' => 'esc_attr'
            )
        );
        $wp_customize->add_control(
            new Botiga_Accordion_Control(
                $wp_customize,
                'botiga_section_hooks_woocommerce_shop_cart',
                array(
                    'label'         => esc_html__( 'Shop Cart', 'botiga-pro' ),
                    'section'       => 'botiga_section_hooks_woocommerce',
                    'until'         => 'botiga_hook_woocommerce_before_cart_collaterals',
                    'priority'      => 210
                )
            )
        );
    
        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_cart',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_cart', 
            array(
                'label'           => esc_html__( 'Before Cart', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_cart', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 220
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_cart',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_cart', 
            array(
                'label'           => esc_html__( 'After Cart', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_cart', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 230
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_cart_table',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_cart_table', 
            array(
                'label'           => esc_html__( 'Before Cart Table', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_cart_table', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 240
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_cart_table',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_cart_table', 
            array(
                'label'           => esc_html__( 'After Cart Table', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_cart_table', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 250
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_cart_contents',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_cart_contents', 
            array(
                'label'           => esc_html__( 'Before Cart Contents', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_cart_contents', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 260
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_cart_contents',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_cart_contents', 
            array(
                'label'           => esc_html__( 'After Cart Contents', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_cart_contents', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 270
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_cart_collaterals',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_cart_collaterals', 
            array(
                'label'           => esc_html__( 'Before Cart Collaterals', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_cart_collaterals', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 280
            ) 
        );

        // Shop Checkout
        $wp_customize->add_setting( 'botiga_section_hooks_woocommerce_shop_checkout', 
            array(
                'sanitize_callback' => 'esc_attr'
            )
        );
        $wp_customize->add_control(
            new Botiga_Accordion_Control(
                $wp_customize,
                'botiga_section_hooks_woocommerce_shop_checkout',
                array(
                    'label'         => esc_html__( 'Shop Checkout', 'botiga-pro' ),
                    'section'       => 'botiga_section_hooks_woocommerce',
                    'until'         => 'botiga_hook_woocommerce_before_thankyou',
                    'priority'      => 300
                )
            )
        );
    
        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_checkout_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_checkout_form', 
            array(
                'label'           => esc_html__( 'Before Checkout Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_checkout_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 310
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_checkout_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_checkout_form', 
            array(
                'label'           => esc_html__( 'After Checkout Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_checkout_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 320
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_checkout_before_customer_details',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_checkout_before_customer_details', 
            array(
                'label'           => esc_html__( 'Before Customer Details', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_checkout_before_customer_details', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 330
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_checkout_after_customer_details',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_checkout_after_customer_details', 
            array(
                'label'           => esc_html__( 'After Customer Details', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_checkout_after_customer_details', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 340
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_checkout_before_order_review',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_checkout_before_order_review', 
            array(
                'label'           => esc_html__( 'Before Order Review', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_checkout_before_order_review', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 350
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_checkout_after_order_review',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_checkout_after_order_review', 
            array(
                'label'           => esc_html__( 'After Order Review', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_checkout_after_order_review', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 360
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_checkout_billing_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_checkout_billing_form', 
            array(
                'label'           => esc_html__( 'Before Checkout Billing Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_checkout_billing_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 370
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_checkout_billing_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_checkout_billing_form', 
            array(
                'label'           => esc_html__( 'After Checkout Billing Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_checkout_billing_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 380
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_checkout_registration_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_checkout_registration_form', 
            array(
                'label'           => esc_html__( 'Before Billing Registration Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_checkout_registration_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 390
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_checkout_registration_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_checkout_registration_form', 
            array(
                'label'           => esc_html__( 'After Billing Registration Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_checkout_registration_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 400
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_checkout_shipping_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_checkout_shipping_form', 
            array(
                'label'           => esc_html__( 'Before Checkout Shipping Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_checkout_shipping_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 410
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_checkout_shipping_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_checkout_shipping_form', 
            array(
                'label'           => esc_html__( 'After Checkout Shipping Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_checkout_shipping_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 420
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_order_notes',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_order_notes', 
            array(
                'label'           => esc_html__( 'Before Order Notes', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_order_notes', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 430
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_order_notes',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_order_notes', 
            array(
                'label'           => esc_html__( 'After Order Notes', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_order_notes', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 440
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_checkout_before_terms_and_conditions',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_checkout_before_terms_and_conditions', 
            array(
                'label'           => esc_html__( 'Before Terms And Conditions', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_checkout_before_terms_and_conditions', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 450
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_checkout_after_terms_and_conditions',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_checkout_after_terms_and_conditions', 
            array(
                'label'           => esc_html__( 'After Terms And Conditions', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_checkout_after_terms_and_conditions', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 460
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_thankyou',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_thankyou', 
            array(
                'label'           => esc_html__( 'Before Thank You', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_thankyou', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 470
            ) 
        );

        // Shop Checkout
        $wp_customize->add_setting( 'botiga_section_hooks_woocommerce_shop_myaccount', 
            array(
                'sanitize_callback' => 'esc_attr'
            )
        );
        $wp_customize->add_control(
            new Botiga_Accordion_Control(
                $wp_customize,
                'botiga_section_hooks_woocommerce_shop_myaccount',
                array(
                    'label'         => esc_html__( 'Shop My Account', 'botiga-pro' ),
                    'section'       => 'botiga_section_hooks_woocommerce',
                    'until'         => 'botiga_hook_woocommerce_after_account_orders',
                    'priority'      => 490
                )
            )
        );
    
        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_my_account',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_my_account', 
            array(
                'label'           => esc_html__( 'Before My Account', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_my_account', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 500
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_my_account',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_my_account', 
            array(
                'label'           => esc_html__( 'After My Account', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_my_account', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 510
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_account_downloads',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_account_downloads', 
            array(
                'label'           => esc_html__( 'Before Account Downloads', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_account_downloads', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 520
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_account_downloads',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_account_downloads', 
            array(
                'label'           => esc_html__( 'After Account Downloads', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_account_downloads', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 530
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_edit_account_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_edit_account_form', 
            array(
                'label'           => esc_html__( 'Before Edit Account Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_edit_account_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 540
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_edit_account_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_edit_account_form', 
            array(
                'label'           => esc_html__( 'After Edit Account Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_edit_account_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 550
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_edit_account_address_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_edit_account_address_form', 
            array(
                'label'           => esc_html__( 'Before Edit Account Address Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_edit_account_address_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 560
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_edit_account_address_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_edit_account_address_form', 
            array(
                'label'           => esc_html__( 'After Edit Account Address Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_edit_account_address_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 570
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_customer_login_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_customer_login_form', 
            array(
                'label'           => esc_html__( 'Before Customer Login Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_customer_login_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 580
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_customer_login_form',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_customer_login_form', 
            array(
                'label'           => esc_html__( 'After Customer Login Form', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_customer_login_form', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 590
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_account_navigation',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_account_navigation', 
            array(
                'label'           => esc_html__( 'Before Account Navigation', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_account_navigation', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 600
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_account_navigation',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_account_navigation', 
            array(
                'label'           => esc_html__( 'After Account Navigation', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_account_navigation', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 610
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_before_account_orders',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_before_account_orders', 
            array(
                'label'           => esc_html__( 'Before Account Orders', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_before_account_orders', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 620
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_woocommerce_after_account_orders',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_woocommerce_after_account_orders', 
            array(
                'label'           => esc_html__( 'After Account Orders', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: woocommerce_after_account_orders', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_woocommerce',
                'priority'        => 630
            ) 
        );

    }

    // Sidebar
    $wp_customize->add_section(
        'botiga_section_hooks_sidebar',
        array(
            'title'      => esc_html__( 'Sidebar', 'botiga-pro' ),
            'panel'      => 'botiga_panel_hooks',
            'description'   => botiga_hooks_section_description()
        )
    );

    $wp_customize->add_setting(
        'botiga_hook_before_sidebar',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_before_sidebar', 
        array(
            'label'           => esc_html__( 'Before Sidebar', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_before_sidebar', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_sidebar',
            'priority'        => 10
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_after_sidebar',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_after_sidebar', 
        array(
            'label'           => esc_html__( 'After Sidebar', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_after_sidebar', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_sidebar',
            'priority'        => 20
        ) 
    );

    // Footer
    $wp_customize->add_section(
        'botiga_section_hooks_footer',
        array(
            'title'      => esc_html__( 'Footer', 'botiga-pro' ),
            'panel'      => 'botiga_panel_hooks',
            'description'   => botiga_hooks_section_description()
        )
    );

    $wp_customize->add_setting(
        'botiga_hook_footer_before',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_footer_before', 
        array(
            'label'           => esc_html__( 'Before Footer', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_footer_before', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_footer',
            'priority'        => 10
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_footer_after',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_footer_after', 
        array(
            'label'           => esc_html__( 'After Footer', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_footer_after', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_footer',
            'priority'        => 20
        ) 
    );

    if( class_exists( 'Botiga_Modules' ) && Botiga_Modules::is_module_active( 'hf-builder' ) ) {
        $wp_customize->add_setting(
            'botiga_hook_bhfb_footer_inner_before',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_bhfb_footer_inner_before', 
            array(
                'label'           => esc_html__( 'Footer Builder Inner Before', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: botiga_bhfb_footer_inner_before', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_footer',
                'priority'        => 20
            ) 
        );

        $wp_customize->add_setting(
            'botiga_hook_bhfb_footer_inner_after',
            array(
                'sanitize_callback' => 'botiga_sanitize_text',
                'default'           => '',
            )       
        );
        $wp_customize->add_control( 
            'botiga_hook_bhfb_footer_inner_after', 
            array(
                'label'           => esc_html__( 'Footer Builder Inner After', 'botiga-pro' ),
                'description'     => esc_html__( 'Hook: botiga_bhfb_footer_inner_after', 'botiga-pro' ),
                'type'            => 'textarea',
                'section'         => 'botiga_section_hooks_footer',
                'priority'        => 20
            ) 
        );
    }

    $wp_customize->add_setting(
        'botiga_hook_before_footer_widgets',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_before_footer_widgets', 
        array(
            'label'           => esc_html__( 'Before Footer Widgets Area', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_before_footer_widgets', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_footer',
            'priority'        => 30
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_after_footer_widgets',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_after_footer_widgets', 
        array(
            'label'           => esc_html__( 'After Footer Widgets Area', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_after_footer_widgets', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_footer',
            'priority'        => 40
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_footer_widgets_content_start',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_footer_widgets_content_start', 
        array(
            'label'           => esc_html__( 'Footer Widgets Content Start', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_footer_widgets_content_start', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_footer',
            'priority'        => 50
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_footer_widgets_content_end',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_footer_widgets_content_end', 
        array(
            'label'           => esc_html__( 'Footer Widgets Content End', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_footer_widgets_content_end', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_footer',
            'priority'        => 60
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_before_footer_copyright',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_before_footer_copyright', 
        array(
            'label'           => esc_html__( 'Before Footer Copyright Area', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_before_footer_copyright', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_footer',
            'priority'        => 70
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_after_footer_copyright',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_after_footer_copyright', 
        array(
            'label'           => esc_html__( 'After Footer Copyright Area', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_after_footer_copyright', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_footer',
            'priority'        => 80
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_footer_copyright_content_start',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_footer_copyright_content_start', 
        array(
            'label'           => esc_html__( 'Footer Copyright Content Start', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_footer_copyright_content_start', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_footer',
            'priority'        => 90
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_footer_copyright_content_end',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_footer_copyright_content_end', 
        array(
            'label'           => esc_html__( 'Footer Copyright Content End', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: botiga_footer_copyright_content_end', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_footer',
            'priority'        => 100
        ) 
    );

    $wp_customize->add_setting(
        'botiga_hook_wp_footer',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default'           => '',
        )       
    );
    $wp_customize->add_control( 
        'botiga_hook_wp_footer', 
        array(
            'label'           => esc_html__( 'Wp Footer', 'botiga-pro' ),
            'description'     => esc_html__( 'Hook: wp_footer', 'botiga-pro' ),
            'type'            => 'textarea',
            'section'         => 'botiga_section_hooks_footer',
            'priority'        => 110
        ) 
    );
    
}
add_action( 'customize_register', 'botiga_hook_options', 999 );