<?php
/**
 * Header Icons Customizer options
 *
 * @package Botiga_Pro
 */

/**
 * Header icons customizer options
 */
function botiga_pro_header_icons_options( $wp_customize ) {
    
    // Header Icons Section
    $wp_customize->add_section(
        'botiga_section_header_icons',
        array(
            'title'      => esc_html__( 'Header Icons', 'botiga-pro' ),
            'panel'      => 'botiga_panel_header'
        )
    );

    // Search Icon
    $wp_customize->add_setting(
        'search_icon',
        array(
            'default'           => 'icon-search',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control(
        new Botiga_Radio_Images(
            $wp_customize,
            'search_icon',
            array(
                'label'    	=> esc_html__( 'Search Icon', 'botiga-pro' ),
                'section'  	=> 'botiga_section_header_icons',
                'cols'		=> 4,
                'class'     => 'botiga-radio-images-medium',
                'choices'  	=> array(			
                    'icon-search'  => array(
                        'label'  => esc_html__( 'Icon 1', 'botiga-pro' ),
                        'url'    => '%s/assets/img/search-icon1.svg'
                    ),
                    'icon-custom' => array(
                        'label'  => esc_html__( 'Custom Icon', 'botiga-pro' ),
                        'url'    => '%s/assets/img/upload-custom-icon.svg'
                    )
                ),
                'priority'		  => 20
            )
        )
    );

    // Custom Search Icon - Image
    $wp_customize->add_setting( 
        'search_icon_custom_image',
        array(
            'default'           => '',
            'sanitize_callback' => 'absint',
        ) 
    );
    $wp_customize->add_control( 
        new WP_Customize_Media_Control( 
            $wp_customize, 
            'search_icon_custom_image',
            array(
                'label'           => '',
                'section'         => 'botiga_section_header_icons',
                'mime_type'       => 'image',
                'active_callback' => function() { return botiga_callback_header_icon_custom( 'search' ); },
                'priority'	      => 20
            )
        )
    );

    // Divider
    $wp_customize->add_setting( 'header_icons_divider_1',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Divider_Control( 
            $wp_customize, 
            'header_icons_divider_1',
            array(
                'section' 		=> 'botiga_section_header_icons',
                'priority'			=> 30
            )
        )
    );

    // Cart Icon
    $wp_customize->add_setting(
        'cart_icon',
        array(
            'default'           => 'icon-cart',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control(
        new Botiga_Radio_Images(
            $wp_customize,
            'cart_icon',
            array(
                'label'    	=> esc_html__( 'Cart Icon', 'botiga-pro' ),
                'section'  	=> 'botiga_section_header_icons',
                'cols'		=> 4,
                'class'     => 'botiga-radio-images-medium',
                'choices'  	=> array(			
                    'icon-cart'  => array(
                        'label'  => esc_html__( 'Icon 1', 'botiga-pro' ),
                        'url'    => '%s/assets/img/cart-icon1.svg'
                    ),
                    'icon-cart2' => array(
                        'label'  => esc_html__( 'Icon 2', 'botiga-pro' ),
                        'url'    => '%s/assets/img/cart-icon2.svg'
                    ),
                    'icon-cart3' => array(
                        'label'  => esc_html__( 'Icon 3', 'botiga-pro' ),
                        'url'    => '%s/assets/img/cart-icon3.svg'
                    ),
                    'icon-cart4' => array(
                        'label'  => esc_html__( 'Icon 4', 'botiga-pro' ),
                        'url'    => '%s/assets/img/cart-icon4.svg'
                    ),
                    'icon-cart5' => array(
                        'label'  => esc_html__( 'Icon 5', 'botiga-pro' ),
                        'url'    => '%s/assets/img/cart-icon5.svg'
                    ),
                    'icon-custom' => array(
                        'label'  => esc_html__( 'Custom Icon', 'botiga-pro' ),
                        'url'    => '%s/assets/img/upload-custom-icon.svg'
                    )
                ),
                'priority'		  => 40
            )
        )
    );

    // Custom Cart Icon - Image
    $wp_customize->add_setting( 
        'cart_icon_custom_image',
        array(
            'default'           => '',
            'sanitize_callback' => 'absint',
        ) 
    );
    $wp_customize->add_control( 
        new WP_Customize_Media_Control( 
            $wp_customize, 
            'cart_icon_custom_image',
            array(
                'label'           => '',
                'section'         => 'botiga_section_header_icons',
                'mime_type'       => 'image',
                'active_callback' => function() { return botiga_callback_header_icon_custom( 'cart' ); },
                'priority'	      => 40
            )
        )
    );

    // Divider
    $wp_customize->add_setting( 'header_icons_divider_2',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Divider_Control( 
            $wp_customize, 
            'header_icons_divider_2',
            array(
                'section' 		=> 'botiga_section_header_icons',
                'priority'			=> 50
            )
        )
    );

    // My Account Icon
    $wp_customize->add_setting(
        'account_icon',
        array(
            'default'           => 'icon-user',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control(
        new Botiga_Radio_Images(
            $wp_customize,
            'account_icon',
            array(
                'label'    	=> esc_html__( 'Account Icon', 'botiga-pro' ),
                'section'  	=> 'botiga_section_header_icons',
                'cols'		=> 4,
                'class'     => 'botiga-radio-images-medium',
                'choices'  	=> array(			
                    'icon-user'  => array(
                        'label'  => esc_html__( 'Icon 1', 'botiga-pro' ),
                        'url'    => '%s/assets/img/account-icon1.svg'
                    ),
                    'icon-user2' => array(
                        'label'  => esc_html__( 'Icon 2', 'botiga-pro' ),
                        'url'    => '%s/assets/img/account-icon2.svg'
                    ),
                    'icon-user3' => array(
                        'label'  => esc_html__( 'Icon 3', 'botiga-pro' ),
                        'url'    => '%s/assets/img/account-icon3.svg'
                    ),
                    'icon-custom' => array(
                        'label'  => esc_html__( 'Custom Icon', 'botiga-pro' ),
                        'url'    => '%s/assets/img/upload-custom-icon.svg'
                    )
                ),
                'priority'		  => 60
            )
        )
    );

    // Custom My Account Icon - Image
    $wp_customize->add_setting( 
        'account_icon_custom_image',
        array(
            'default'           => '',
            'sanitize_callback' => 'absint',
        ) 
    );
    $wp_customize->add_control( 
        new WP_Customize_Media_Control( 
            $wp_customize, 
            'account_icon_custom_image',
            array(
                'label'           => '',
                'section'         => 'botiga_section_header_icons',
                'mime_type'       => 'image',
                'active_callback' => function() { return botiga_callback_header_icon_custom( 'account' ); },
                'priority'	      => 60
            )
        )
    );

    // Divider
    $wp_customize->add_setting( 'header_icons_divider_3',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Divider_Control( 
            $wp_customize, 
            'header_icons_divider_3',
            array(
                'section' 		=> 'botiga_section_header_icons',
                'priority'			=> 70
            )
        )
    );

    // Wishlist Icon
    $wp_customize->add_setting(
        'wishlist_icon',
        array(
            'default'           => 'icon-wishlist',
            'sanitize_callback' => 'sanitize_key',
        )
    );
    $wp_customize->add_control(
        new Botiga_Radio_Images(
            $wp_customize,
            'wishlist_icon',
            array(
                'label'    	=> esc_html__( 'Wishlist Icon', 'botiga-pro' ),
                'section'  	=> 'botiga_section_header_icons',
                'cols'		=> 4,
                'class'     => 'botiga-radio-images-medium',
                'choices'  	=> array(			
                    'icon-wishlist'  => array(
                        'label'  => esc_html__( 'Icon 1', 'botiga-pro' ),
                        'url'    => '%s/assets/img/wishlist-icon1.svg'
                    ),
                    'icon-wishlist2'  => array(
                        'label'  => esc_html__( 'Icon 2', 'botiga-pro' ),
                        'url'    => '%s/assets/img/wishlist-icon2.svg'
                    ),
                    'icon-custom' => array(
                        'label'  => esc_html__( 'Custom Icon', 'botiga-pro' ),
                        'url'    => '%s/assets/img/upload-custom-icon.svg'
                    )
                ),
                'priority'		  => 80
            )
        )
    );

    // Custom Wishlist Icon - Image
    $wp_customize->add_setting( 
        'wishlist_icon_custom_image',
        array(
            'default'           => '',
            'sanitize_callback' => 'absint',
        ) 
    );
    $wp_customize->add_control( 
        new WP_Customize_Media_Control( 
            $wp_customize, 
            'wishlist_icon_custom_image',
            array(
                'label'           => '',
                'section'         => 'botiga_section_header_icons',
                'mime_type'       => 'image',
                'active_callback' => function() { return botiga_callback_header_icon_custom( 'wishlist' ); },
                'priority'	      => 80
            )
        )
    );
    
}
add_action( 'customize_register', 'botiga_pro_header_icons_options', 999 );