<?php
/**
 * Blog Single Customizer options
 *
 * @package Botiga_Pro
 */

function botiga_pro_blog_single_options( $wp_customize ) {

    // Tabs control
    $controls_general     = json_decode( $wp_customize->get_control( 'botiga_blog_single_tabs' )->controls_general );
    $new_controls_general = array( '#customize-control-blog_single_sidebar','#customize-control-single_post_reading_progress_divider1','#customize-control-single_post_reading_progress','#customize-control-single_post_reading_progress_position','#customize-control-single_post_reading_progress_height','#customize-control-single_post_reading_progress_comments','#customize-control-single_post_share_box','#customize-control-single_post_share_box_divider1','#customize-control-single_post_share_box_sharing_title','#customize-control-single_post_share_box_title','#customize-control-single_post_share_box_networks' );
    $wp_customize->get_control( 'botiga_blog_single_tabs' )->controls_general = json_encode( array_merge( $controls_general, $new_controls_general ) );
    
    $controls_design     = json_decode( $wp_customize->get_control( 'botiga_blog_single_tabs' )->controls_design );
    $new_controls_design = array( '#customize-control-single_post_reading_progress_divider2','#customize-control-single_post_reading_progress_style_title','#customize-control-single_post_reading_progress_background_color','#customize-control-single_post_reading_progress_foreground_color' );
    $wp_customize->get_control( 'botiga_blog_single_tabs' )->controls_design = json_encode( array_merge( $controls_design, $new_controls_design ) );

    // Blog Single Sidebar
    $wp_customize->add_setting( 
        'blog_single_sidebar', 
        array(
            'default'           => '',
            'sanitize_callback' => 'botiga_sanitize_select',
        ) 
    );
    $wp_customize->add_control( 
        'blog_single_sidebar', 
        array(
            'type'            => 'select',
            'section'         => 'botiga_section_blog_singles',
            'label'           => esc_html__( 'Sidebar', 'botiga-pro' ),
            'choices'         => botiga_pro_get_registered_sidebars(),
            'active_callback' => 'botiga_callback_sidebar_single_post',
            'priority'        => 41,
        ) 
    );

	// Reading time
	$wp_customize->get_control( 'single_post_meta_elements' )->choices =  array(
		'botiga_posted_on' 			=> esc_html__( 'Post date', 'botiga-pro' ),
		'botiga_posted_by' 			=> esc_html__( 'Post author', 'botiga-pro' ),
		'botiga_post_categories'	=> esc_html__( 'Post categories', 'botiga-pro' ),
		'botiga_entry_comments' 	=> esc_html__( 'Post comments', 'botiga-pro' ),
        // Pro features below
		'botiga_post_reading_time'  => esc_html__( 'Reading time', 'botiga-pro' )
	);

    // Reading Progress Bar
    $wp_customize->add_setting( 'single_post_reading_progress_divider1',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Divider_Control( 
            $wp_customize, 
            'single_post_reading_progress_divider1',
            array(
                'section' 		    => 'botiga_section_blog_singles',
                'active_callback' 	=> 'botiga_callback_single_post_show_reading_progress_bar',
                'priority' 		    => 45
            )
        )
    );

    $wp_customize->add_setting(
        'single_post_reading_progress',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'single_post_reading_progress',
            array(
                'label'         	=> esc_html__( 'Reading Progress Bar', 'botiga-pro' ),
                'section'       	=> 'botiga_section_blog_singles',
                'priority' 			=> 45
            )
        )
    );

    $wp_customize->add_setting( 
        'single_post_reading_progress_position',
        array(
            'default' 			=> 'top',
            'sanitize_callback' => 'botiga_sanitize_text'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Radio_Buttons( 
            $wp_customize, 
            'single_post_reading_progress_position',
            array(
                'label' 	=> esc_html__( 'Bar Position', 'botiga-pro' ),
                'section' 	=> 'botiga_section_blog_singles',
                'choices' 	=> array(
                    'top' 		=> esc_html__( 'Top', 'botiga-pro' ),
                    'bottom' 	=> esc_html__( 'Bottom', 'botiga-pro' ),
                ),
                'active_callback' 	=> 'botiga_callback_single_post_show_reading_progress_bar',
                'priority' 			=> 45
            )
        ) 
    );

    $wp_customize->add_setting( 
        'single_post_reading_progress_height', 
        array(
            'default'   		=> 6,
            'transport'			=> 'postMessage',
            'sanitize_callback' => 'absint',
        ) 
    );			
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'single_post_reading_progress_height',
            array(
                'label' 		=> esc_html__( 'Bar Height', 'botiga-pro' ),
                'section' 		=> 'botiga_section_blog_singles',
                'is_responsive'	=> 0,
                'settings' 		=> array (
                    'size_desktop' 		=> 'single_post_reading_progress_height',
                ),
                'input_attrs' => array (
                    'min'	=> 0,
                    'max'	=> 15,
                    'step'  => 1
                ),
                'active_callback' 	=> 'botiga_callback_single_post_show_reading_progress_bar',
                'priority'     => 45
            )
        ) 
    );

    $wp_customize->add_setting(
        'single_post_reading_progress_comments',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'single_post_reading_progress_comments',
            array(
                'label'         	=> esc_html__( 'Include Comments Area', 'botiga-pro' ),
                'section'       	=> 'botiga_section_blog_singles',
                'active_callback' 	=> 'botiga_callback_single_post_show_reading_progress_bar',
                'priority' 			=> 45
            )
        )
    );

    $wp_customize->add_setting( 'single_post_reading_progress_divider2',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Divider_Control( 
            $wp_customize, 
            'single_post_reading_progress_divider2',
            array(
                'section' 		    => 'botiga_section_blog_singles',
                'active_callback' 	=> 'botiga_callback_single_post_show_reading_progress_bar',
                'priority' 		    => 310
            )
        )
    );

    $wp_customize->add_setting( 
        'single_post_reading_progress_style_title',
        array(
            'default' 			=> '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Text_Control( 
            $wp_customize, 
            'single_post_reading_progress_style_title',
            array(
                'label'			  => esc_html__( 'Reading Progress Bar', 'botiga-pro' ),
                'section' 		  => 'botiga_section_blog_singles',
                'active_callback' 	=> 'botiga_callback_single_post_show_reading_progress_bar',
                'priority'	 	  => 310
            )
        )
    );

    $wp_customize->add_setting(
        'single_post_reading_progress_background_color',
        array(
            'default'           => 'transparent',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'single_post_reading_progress_background_color',
            array(
                'label'         	=> esc_html__( 'Background Color', 'botiga-pro' ),
                'section'       	=> 'botiga_section_blog_singles',
                'active_callback' 	=> 'botiga_callback_single_post_show_reading_progress_bar',
                'priority' 			=> 310
            )
        )
    );

    $wp_customize->add_setting(
        'single_post_reading_progress_foreground_color',
        array(
            'default'           => '#212121',
            'sanitize_callback' => 'botiga_sanitize_hex_rgba',
            'transport'         => 'postMessage'
        )
    );
    $wp_customize->add_control(
        new Botiga_Alpha_Color(
            $wp_customize,
            'single_post_reading_progress_foreground_color',
            array(
                'label'         	=> esc_html__( 'Foreground Color', 'botiga-pro' ),
                'section'       	=> 'botiga_section_blog_singles',
                'active_callback' 	=> 'botiga_callback_single_post_show_reading_progress_bar',
                'priority' 			=> 310
            )
        )
    );

    // Related posts as slider
    $wp_customize->add_setting(
        'single_post_related_posts_slider',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'single_post_related_posts_slider',
            array(
                'label'         	=> esc_html__( 'Related posts slider', 'botiga-pro' ),
                'section'       	=> 'botiga_section_blog_singles',
                'active_callback'   => 'botiga_callback_single_post_show_related_posts',
                'priority' 			=> 310
            )
        )
    );

    // Related posts slider nav
    $wp_customize->add_setting( 
        'single_post_related_posts_slider_nav',
        array(
            'default' 			=> 'always-show',
            'sanitize_callback' => 'botiga_sanitize_text'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Radio_Buttons( 
            $wp_customize, 
            'single_post_related_posts_slider_nav',
            array(
                'label' 	      => esc_html__( 'Related posts slider navigation', 'botiga-pro' ),
                'section' 	      => 'botiga_section_blog_singles',
                'active_callback' => 'botiga_callback_single_post_related_posts_slider_navigation',
                'choices'         => array(
                    'always-show' => esc_html__( 'Always show', 'botiga-pro' ),
                    'hover-show'  => esc_html__( 'Show on hover', 'botiga-pro' ),
                ),
                'priority' 		  => 310
            )
        ) 
    );

    // Related posts number
    $wp_customize->add_setting( 
        'single_post_related_posts_number', 
        array(
            'default'   		=> 3,
            'sanitize_callback' => 'botiga_sanitize_text',
        ) 
    );			
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'single_post_related_posts_number',
            array(
                'label' 		=> esc_html__( 'Number of posts', 'botiga-pro' ),
                'section' 		=> 'botiga_section_blog_singles',
                'active_callback'   => 'botiga_callback_single_post_show_related_posts',
                'is_responsive'	=> 0,
                'settings' 		=> array (
                    'size_desktop' 		=> 'single_post_related_posts_number',
                ),
                'input_attrs' => array (
                    'min'	=> 1,
                    'max'	=> 25,
                    'step'  => 1,
                    'unit'  => '',
                ),
                'priority'      => 310
            )
        )
    );

    // Related post columns number
    $wp_customize->add_setting( 
        'single_post_related_posts_columns_number', 
        array(
            'default'   		=> 3,
            'sanitize_callback' => 'botiga_sanitize_text',
        ) 
    );			
    $wp_customize->add_control( 
        new Botiga_Responsive_Slider( 
            $wp_customize, 
            'single_post_related_posts_columns_number',
            array(
                'label' 		=> esc_html__( 'Number of columns', 'botiga-pro' ),
                'section' 		=> 'botiga_section_blog_singles',
                'active_callback'   => 'botiga_callback_single_post_show_related_posts',
                'is_responsive'	=> 0,
                'settings' 		=> array (
                    'size_desktop' 		=> 'single_post_related_posts_columns_number',
                ),
                'input_attrs' => array (
                    'min'	=> 1,
                    'max'	=> 6,
                    'step'  => 1,
                    'unit'  => '',
                ),
                'priority' 		=> 310
            )
        )
    );

    // Share box
    $wp_customize->add_setting(
        'single_post_share_box',
        array(
            'default'           => 0,
            'sanitize_callback' => 'botiga_sanitize_checkbox',
        )
    );
    $wp_customize->add_control(
        new Botiga_Toggle_Control(
            $wp_customize,
            'single_post_share_box',
            array(
                'label'         	=> esc_html__( 'Share Box', 'botiga-pro' ),
                'section'       	=> 'botiga_section_blog_singles',
                'priority' 			=> 241
            )
        )
    );

    // Share Box Divider
    $wp_customize->add_setting( 'single_post_share_box_divider1',
        array(
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Divider_Control( 
            $wp_customize, 
            'single_post_share_box_divider1',
            array(
                'section' 		    => 'botiga_section_blog_singles',
                'active_callback' 	=> 'botiga_callback_single_post_share_box',
                'priority' 		    => 319
            )
        )
    );

    // Share Box Title
    $wp_customize->add_setting( 'single_post_share_box_sharing_title',
        array(
            'default' 			=> '',
            'sanitize_callback' => 'esc_attr',
            
        )
    );
    $wp_customize->add_control( new Botiga_Text_Control( $wp_customize, 'single_post_share_box_sharing_title',
            array(
                'label'           => esc_html__( 'Post sharing', 'botiga-pro' ),
                'section'         => 'botiga_section_blog_singles',
                'active_callback' => 'botiga_callback_single_post_share_box',
                'priority'        => 319
            )
        )
    );

    // Share Box Title
    $wp_customize->add_setting(
        'single_post_share_box_title',
        array(
            'sanitize_callback' => 'botiga_sanitize_text',
            'default' 			=> esc_html__( 'SHARE', 'botiga-pro' ),
        )       
    );
    $wp_customize->add_control( 'single_post_share_box_title', array(
        'label'       		=> esc_html__( 'Sharing title', 'botiga-pro' ),
        'type'        		=> 'text',
        'section'     		=> 'botiga_section_blog_singles',
        'priority'			=> 320,
        'active_callback' 	=> 'botiga_callback_single_post_share_box'
    ) );

    // Share Box Networks
    $wp_customize->add_setting( 'single_post_share_box_networks', array(
        'default'  			=> array( 'facebook', 'twitter', 'linkedin' ),
        'sanitize_callback'	=> 'botiga_sanitize_single_post_share_box_networks'
    ) );
    $wp_customize->add_control( new \Kirki\Control\Sortable( $wp_customize, 'single_post_share_box_networks', array(
        'label'   		=> esc_html__( 'Social Networks', 'botiga-pro' ),
        'section' => 'botiga_section_blog_singles',
        'choices' => array(
            'facebook' 			=> esc_html__( 'Facebook', 'botiga-pro' ),
            'twitter' 			=> esc_html__( 'Twitter', 'botiga-pro' ),
            'linkedin'			=> esc_html__( 'Linkedin', 'botiga-pro' ),
            'pinterest' 		=> esc_html__( 'Pinterest', 'botiga-pro' ),
            'whatsapp' 			=> esc_html__( 'Whatsapp', 'botiga-pro' ),
            'telegram' 			=> esc_html__( 'Telegram', 'botiga-pro' ),
            'vk' 				=> esc_html__( 'VK', 'botiga-pro' ),
            'weibo' 			=> esc_html__( 'Weibo', 'botiga-pro' ),
            'reddit' 			=> esc_html__( 'Reddit', 'botiga-pro' ),
            'ok' 				=> esc_html__( 'Ok', 'botiga-pro' ),
            'xing' 				=> esc_html__( 'Xing', 'botiga-pro' ),
            'mail' 				=> esc_html__( 'Mail', 'botiga-pro' ),
            'copyclipboard'     => esc_html__( 'Copy To Clipboard', 'botiga-pro' )
        ),
        'priority'			=> 330,
        'active_callback' 	=> 'botiga_callback_single_post_share_box'
    ) ) );
}
add_action( 'customize_register', 'botiga_pro_blog_single_options', 999 );