<?php
/**
 * Active callback functions
 * Check function names to avoid theme update conflicts (function already declared)
 * Some of these functions were removed from free theme (1.0.8) to here
 * 
 * @package Botiga_Pro
 */

/**
 * Single post show reading progress bar
 */
if( ! function_exists( 'botiga_callback_single_post_show_reading_progress_bar' ) ) {
    function botiga_callback_single_post_show_reading_progress_bar() {
        $enable = get_theme_mod( 'single_post_reading_progress', 0 );

        if ( $enable ) {
            return true;
        } else {
            return false;
        }   	
    }
}

/**
 * Single post show related posts
 */
if( ! function_exists( 'botiga_callback_single_post_show_related_posts' ) ) {
    function botiga_callback_single_post_show_related_posts() {
        $enable = get_theme_mod( 'single_post_show_related_posts', 0 );

        if ( $enable ) {
            return true;
        } else {
            return false;
        }   	
    }
}

/**
 * Single post related posts slider show
 */
if( ! function_exists( 'botiga_callback_single_post_related_posts_slider_navigation' ) ) {
    function botiga_callback_single_post_related_posts_slider_navigation() {
        $related_posts = get_theme_mod( 'single_post_show_related_posts', 0 );
        $slider        = get_theme_mod( 'single_post_related_posts_slider', 0 );

        if ( $related_posts && $slider ) {
            return true;
        } else {
            return false;
        }   	
    }
}

/**
 * Header
 */
if( ! function_exists( 'botiga_callback_header_layout_is_6' ) ) {
    function botiga_callback_header_layout_is_6() {
        $layout = get_theme_mod( 'header_layout_desktop', 'header_layout_1' );
        
        if ( 'header_layout_6' === $layout ) {
            return true;
        } else { 
            return false;
        }
    }
}

if( ! function_exists( 'botiga_callback_header_layout_is_7' ) ) {
    function botiga_callback_header_layout_is_7() {
        $layout = get_theme_mod( 'header_layout_desktop', 'header_layout_1' );
        
        if ( 'header_layout_7' === $layout ) {
            return true;
        } else { 
            return false;
        }
    }
}

if( ! function_exists( 'botiga_callback_header_layout_is_7_8' ) ) {
    function botiga_callback_header_layout_is_7_8() {
        $layout = get_theme_mod( 'header_layout_desktop', 'header_layout_1' );
        
        if ( 'header_layout_7' === $layout || 'header_layout_8' === $layout ) {
            return true;
        } else { 
            return false;
        }
    }
}

if( ! function_exists( 'botiga_login_register_has_welcome_message' ) ) {
    function botiga_login_register_has_welcome_message() {
        $enable = get_theme_mod( 'login_register_show_welcome_message', 1 );

        if ( $enable ) {
            return true;
        } else {
            return false;
        } 
    }
}

/**
 * Header Builder
 */
if( ! function_exists( 'botiga_bhfb_search_layout_is_hidden' ) ) {
    function botiga_bhfb_search_layout_is_hidden() {
        $layout = get_theme_mod( 'bhfb_search_layout', 'hidden' );

        if ( $layout === 'hidden' ) {
            return true;
        } else {
            return false;
        } 
    }
}

if( ! function_exists( 'botiga_bhfb_search_layout_is_visible' ) ) {
    function botiga_bhfb_search_layout_is_visible() {
        $layout = get_theme_mod( 'bhfb_search_layout', 'hidden' );

        if ( $layout === 'visible' ) {
            return true;
        } else {
            return false;
        } 
    }
}

/**
 * Sticky Header
 */
if( ! function_exists( 'botiga_sticky_header_enabled' ) ) {
    function botiga_sticky_header_enabled() {
        $enable = get_theme_mod( 'enable_sticky_header', 0 );

        if ( $enable ) {
            return true;
        } else {
            return false;
        } 
    }
}

/**
 * Header Icons
 */
if( ! function_exists( 'botiga_callback_header_icon_search_custom_type' ) ) {
    function botiga_callback_header_icon_search_custom_type( $icon ) {
        switch ( $icon ) {
            case 'search':
                $value = get_theme_mod( 'search_icon', 'icon-search' );
                break;

            case 'cart':
                $value = get_theme_mod( 'cart_icon', 'icon-cart' );
                break;

            case 'account':
                $value = get_theme_mod( 'account_icon', 'icon-user' );
                break;

            case 'wishlist':
                $value = get_theme_mod( 'wishlist_icon', 'icon-wishlist' );
                break;
            
        }
        
        if ( $value === 'icon-custom' ) {
            return true;
        } else {
            return false;
        } 
    }
}

if( ! function_exists( 'botiga_callback_header_icon_custom' ) ) {
    function botiga_callback_header_icon_custom( $icon ) {
        switch ( $icon ) {
            case 'search':
                $value = get_theme_mod( 'search_icon', 'icon-search' );
                break;

            case 'cart':
                $value = get_theme_mod( 'cart_icon', 'icon-cart' );
                break;

            case 'account':
                $value = get_theme_mod( 'account_icon', 'icon-user' );
                break;

            case 'wishlist':
                $value = get_theme_mod( 'wishlist_icon', 'icon-wishlist' );
                break;
            
        }

        if ( $value === 'icon-custom' ) {
            return true;
        } else {
            return false;
        } 
    }
}

/**
 * WooCommerce cart sticky totals box
 */
if( ! function_exists( 'botiga_callback_shop_cart_layout' ) ) {
    function botiga_callback_shop_cart_layout() {
        $layout = get_theme_mod( 'shop_cart_layout', 'layout1' );

        if ( $layout !== 'layout1' ) {
            return true;
        } else {
            return false;
        }
    }
}

/**
 * WooCommerce mini cart style
 */
if( ! function_exists( 'botiga_callback_mini_cart_layout_is_side' ) ) {
    function botiga_callback_mini_cart_layout_is_side() {
        $style = get_theme_mod( 'mini_cart_style', 'default' );

        if ( $style === 'side' ) {
            return true;
        } else {
            return false;
        }
    }
}

/**
 * WooCommerce mini cart floating mini cart icon
 */
if( ! function_exists( 'botiga_callback_mini_cart_floating_icon_enabled' ) ) {
    function botiga_callback_mini_cart_floating_icon_enabled() {
        $style         = get_theme_mod( 'mini_cart_style', 'default' );
        $floating_icon = get_theme_mod( 'side_mini_cart_floating_icon', 0 );

        if ( $style === 'side' && $floating_icon ) {
            return true;
        } else {
            return false;
        }
    }
}

/**
 * WooCommerce checkout sticky totals box
 */
if( ! function_exists( 'botiga_callback_shop_checkout_layout' ) ) {
    function botiga_callback_shop_checkout_layout() {
        $layout = get_theme_mod( 'shop_checkout_layout', 'layout1' );

        if ( in_array( $layout, array( 'layout1', 'layout4', 'layout5' ) ) ) {
            return true;
        } else {
            return false;
        }
    }
}

/**
 * WooCommerce single product image layout
 */
if( ! function_exists( 'botiga_callback_single_product_gallery_image_layout' ) ) {
    function botiga_callback_single_product_gallery_image_layout() {
        $layout = get_theme_mod( 'single_product_gallery', 'gallery-default' );

        if ( 'gallery-showcase' === $layout || 'gallery-full-width' === $layout ) {
            return true;
        } else {
            return false;
        }	
    }
}

/**
 * WooCommerce single tabs
 */
if( ! function_exists( 'botiga_callback_single_tabs_border_color_active' ) ) {
    function botiga_callback_single_tabs_border_color_active() {
        $layout = get_theme_mod( 'single_product_tabs_layout', 'style1' );

        if( ! in_array( $layout, array( 'style3', 'style5', 'style6' ) ) ) {
            return true;
        } else {
            return false;
        }
    }
}

if( ! function_exists( 'botiga_callback_single_tabs_background_color' ) ) {
    function botiga_callback_single_tabs_background_color() {
        $layout = get_theme_mod( 'single_product_tabs_layout', 'style1' );

        if( ! in_array( $layout, array( 'style1', 'style2', 'style6' ) ) ) {
            return true;
        } else {
            return false;
        }
    }
}

if( ! function_exists( 'botiga_single_product_tabs_alignment' ) ) {
    function botiga_single_product_tabs_alignment() {
        $layout = get_theme_mod( 'single_product_tabs_layout', 'style1' );

        if( ! in_array( $layout, array( 'style6' ) ) ) {
            return true;
        } else {
            return false;
        }
    }
}

if( ! function_exists( 'botiga_single_product_tabs_is_accordion_layout' ) ) {
    function botiga_single_product_tabs_is_accordion_layout() {
        $layout = get_theme_mod( 'single_product_tabs_layout', 'style1' );

        if( in_array( $layout, array( 'style6' ) ) ) {
            return true;
        } else {
            return false;
        }
    }
}

/**
 * WooCommerce single upsell, related and recently viewed products
 * if at least one is active, then return true.
 */
if( ! function_exists( 'botiga_callback_single_product_sections_active' ) ) {
    function botiga_callback_single_product_sections_active() {
        $upsell   = get_theme_mod( 'single_upsell_products', 1 );
        $related  = get_theme_mod( 'single_related_products', 1 );
        $recently = get_theme_mod( 'single_recently_viewed_products', 0 );

        if( $upsell || $related || $recently ) {
            return true;
        } else {
            return false;
        }
    }
}

/**
 * WooCommerce single upsell products
 */
if( ! function_exists( 'botiga_callback_single_product_upsell_active' ) ) {
    function botiga_callback_single_product_upsell_active() {
        $enabled = get_theme_mod( 'single_upsell_products', 1 );

        if( $enabled ) {
            return true;
        } else {
            return false;
        }
    }
}

/**
 * WooCommerce single related products
 */
if( ! function_exists( 'botiga_callback_single_product_related_active' ) ) {
    function botiga_callback_single_product_related_active() {
        $enabled = get_theme_mod( 'single_related_products', 1 );

        if( $enabled ) {
            return true;
        } else {
            return false;
        }
    }
}

/**
 * WooCommerce single recently_viewed products
 */
if( ! function_exists( 'botiga_callback_single_product_recently_viewed_active' ) ) {
    function botiga_callback_single_product_recently_viewed_active() {
        $enabled = get_theme_mod( 'single_recently_viewed_products', 0 );

        if( $enabled ) {
            return true;
        } else {
            return false;
        }
    }
}

/**
 * WooCommerce single image gallery
 */
if( ! function_exists( 'botiga_callback_single_product_gallery_layout' ) ) {
    function botiga_callback_single_product_gallery_layout() {
        $layout = get_theme_mod( 'single_product_gallery', 'gallery-default' );

        if( ! in_array( $layout, array( 'gallery-grid', 'gallery-scrolling', 'gallery-showcase', 'gallery-full-width' ) ) ) {
            return true;
        } else {
            return false;
        }
    }
}

/**
 * WooCommerce product catalog sidebar
 */
if( ! function_exists( 'botiga_callback_shop_archive_sidebar_slide' ) ) {
    function botiga_callback_shop_archive_sidebar_slide() {
        $sidebar = get_theme_mod( 'shop_archive_sidebar', 'no-sidebar' );

        if ( 'sidebar-slide' === $sidebar ) {
            return true;
        } else {
            return false;
        }	
    }
}

if( ! function_exists( 'botiga_callback_shop_archive_sidebar_top' ) ) {
    function botiga_callback_shop_archive_sidebar_top() {
        $sidebar = get_theme_mod( 'shop_archive_sidebar', 'no-sidebar' );

        if ( 'sidebar-top' === $sidebar ) {
            return true;
        } else {
            return false;
        }	
    }
}

/**
 * Woocommerce single show related products
 */
if( ! function_exists( 'botiga_callback_shop_single_show_related_products' ) ) {
    function botiga_callback_shop_single_show_related_products() {
        $enable = get_theme_mod( 'single_related_products', 0 );

        if ( $enable ) {
            return true;
        } else {
            return false;
        }   	
    }
}

/**
 * Woocommerce single related products slider show
 */
if( ! function_exists( 'botiga_callback_shop_single_related_products_slider_navigation' ) ) {
    function botiga_callback_shop_single_related_products_slider_navigation() {
        $related_products = get_theme_mod( 'single_related_products', 0 );
        $slider           = get_theme_mod( 'shop_single_related_products_slider', 0 );

        if ( $related_products && $slider ) {
            return true;
        } else {
            return false;
        }   	
    }
}

/**
 * Woocommerce single show upsell products
 */
if( ! function_exists( 'botiga_callback_shop_single_show_upsell_products' ) ) {
    function botiga_callback_shop_single_show_upsell_products() {
        $enable = get_theme_mod( 'single_upsell_products', 0 );

        if ( $enable ) {
            return true;
        } else {
            return false;
        }   	
    }
}

/**
 * Woocommerce single upsell products slider show
 */
if( ! function_exists( 'botiga_callback_shop_single_upsell_products_slider_navigation' ) ) {
    function botiga_callback_shop_single_upsell_products_slider_navigation() {
        $upsell_products = get_theme_mod( 'single_upsell_products', 0 );
        $slider          = get_theme_mod( 'shop_single_upsell_products_slider', 0 );

        if ( $upsell_products && $slider ) {
            return true;
        } else {
            return false;
        }   	
    }
}

/**
 * Woocommerce single show recently viewed products
 */
if( ! function_exists( 'botiga_callback_shop_single_show_recently_viewed_products' ) ) {
    function botiga_callback_shop_single_show_recently_viewed_products() {
        $enable = get_theme_mod( 'single_recently_viewed_products', 0 );

        if ( $enable ) {
            return true;
        } else {
            return false;
        }   	
    }
}

/**
 * Woocommerce single recently viewed products slider show
 */
if( ! function_exists( 'botiga_callback_shop_single_recently_viewed_products_slider_navigation' ) ) {
    function botiga_callback_shop_single_recently_viewed_products_slider_navigation() {
        $products = get_theme_mod( 'single_recently_viewed_products', 0 );
        $slider   = get_theme_mod( 'shop_single_recently_viewed_products_slider', 0 );

        if ( $products && $slider ) {
            return true;
        } else {
            return false;
        }   	
    }
}

/**
 * WooCommerce product catalog page header style
 */
if( ! function_exists( 'botiga_callback_shop_archive_header_style_alignment' ) ) {
    function botiga_callback_shop_archive_header_style_alignment() {
        $style = get_theme_mod( 'shop_archive_header_style', 'style1' );

        if ( 'style2' !== $style ) {
            return true;
        } else {
            return false;
        }	
    }
}

/**
 * WooCommerce product catalog wishlist
 */
if( ! function_exists( 'botiga_callback_shop_product_wishlist_layout' ) ) {
    function botiga_callback_shop_product_wishlist_layout() {

        $wishlist_enable = Botiga_Modules::is_module_active( 'wishlist' );
        $wishlist_layout = get_theme_mod( 'shop_product_wishlist_layout', 'layout1' );

        if ( $wishlist_enable && 'layout1' !== $wishlist_layout ) {
            return true;
        } else {
            return false;
        }

    }
}

if( ! function_exists( 'botiga_callback_shop_product_wishlist_tooltip' ) ) {
    function botiga_callback_shop_product_wishlist_tooltip() {

        $wishlist_enable  = Botiga_Modules::is_module_active( 'wishlist' );
        $wishlist_tooltip = get_theme_mod( 'shop_product_wishlist_tooltip', 0 );
        $wishlist_layout  = get_theme_mod( 'shop_product_wishlist_layout', 'layout1' );

        if ( $wishlist_enable && $wishlist_tooltip && 'layout1' !== $wishlist_layout ) {
            return true;
        } else {
            return false;
        }

    }
}

/**
 * Modal Popup
 */
if( ! function_exists( 'botiga_callback_modal_popup' ) ) {
    function botiga_callback_modal_popup() {
        $enable       = Botiga_Modules::is_module_active( 'modal-popup' );

        if( $enable ) {
            return true;
        } else {
            return false;
        }
    }
}

if( ! function_exists( 'botiga_callback_modal_popup_not_layout_3' ) ) {
    function botiga_callback_modal_popup_not_layout_3() {
        $enable       = Botiga_Modules::is_module_active( 'modal-popup' );
        $content_type = get_theme_mod( 'modal_popup_content_type', 'default' );
        $layout       = get_theme_mod( 'modal_popup_layout', 'style1' );

        if( $enable && 'default' === $content_type && 'style3' !== $layout ) {
            return true;
        } else {
            return false;
        }
    }
}

if( ! function_exists( 'botiga_callback_modal_popup_display_post_types' ) ) {
    function botiga_callback_modal_popup_display_post_types() {
        $enable = Botiga_Modules::is_module_active( 'modal-popup' );
        $type   = get_theme_mod( 'modal_popup_display', 'all' );

        if( $enable && 'post-types' === $type ) {
            return true;
        } else {
            return false;
        }
    }
}

if( ! function_exists( 'botiga_callback_modal_popup_display_posts_in' ) ) {
    function botiga_callback_modal_popup_display_posts_in() {
        $enable = Botiga_Modules::is_module_active( 'modal-popup' );
        $type   = get_theme_mod( 'modal_popup_display', 'all' );

        if( $enable && 'posts-in' === $type ) {
            return true;
        } else {
            return false;
        }
    }
}

if( ! function_exists( 'botiga_callback_modal_popup_display_posts_and_types' ) ) {
    function botiga_callback_modal_popup_display_posts_and_types() {
        $enable = Botiga_Modules::is_module_active( 'modal-popup' );
        $type   = get_theme_mod( 'modal_popup_display', 'all' );

        if( $enable && ( 'post-types' === $type || 'posts-in' === $type ) ) {
            return true;
        } else {
            return false;
        }
    }
}

if( ! function_exists( 'botiga_callback_modal_popup_content_type_is_default' ) ) {
    function botiga_callback_modal_popup_content_type_is_default() {
        $enable = Botiga_Modules::is_module_active( 'modal-popup' );
        $type   = get_theme_mod( 'modal_popup_content_type', 'default' );

        if( $enable && 'default' === $type ) {
            return true;
        } else {
            return false;
        }
    }
}

if( ! function_exists( 'botiga_callback_modal_popup_content_type_is_content_block' ) ) {
    function botiga_callback_modal_popup_content_type_is_content_block() {
        $enable = Botiga_Modules::is_module_active( 'modal-popup' );
        $type   = get_theme_mod( 'modal_popup_content_type', 'default' );

        if( $enable && 'content-block' === $type ) {
            return true;
        } else {
            return false;
        }
    }
}

/**
 * Blog Single
 */
if( ! function_exists( 'botiga_callback_single_post_share_box' ) ) {
    function botiga_callback_single_post_share_box() {
        $enable = get_theme_mod( 'single_post_share_box', 0 );

        if ( $enable ) {
            return true;
        } else {
            return false;
        }		
    }
}

/**
 * Mega Menu
 */
if( ! function_exists( 'botiga_mega_menu_module_active' ) ) {
    function botiga_mega_menu_module_active() {
        $enable = Botiga_Modules::is_module_active( 'mega-menu' );

        if ( $enable ) {
            return true;
        } else {
            return false;
        }		
    }
}

/**
 * Shop sidebar
 */
if( ! function_exists( 'botiga_callback_shop_sidebar' ) ) {
    function botiga_callback_shop_sidebar() {
        $sidebar = get_theme_mod( 'shop_archive_sidebar', 'no-sidebar' );

        if ( $sidebar !== 'no-sidebar' ) {
            return true;
        } else {
            return false;
        }   
    }
}

/**
 * Shop single sidebar
 */
if( ! function_exists( 'botiga_callback_shop_single_sidebar' ) ) {
    function botiga_callback_shop_single_sidebar() {
        $sidebar = get_theme_mod( 'single_product_sidebar', 'no-sidebar' );

        if ( $sidebar !== 'no-sidebar' ) {
            return true;
        } else {
            return false;
        }   
    }
}

/**
 * Quick Links
 */
if( ! function_exists( 'botiga_callback_quick_links' ) ) {
    function botiga_callback_quick_links() {
        $enable = get_theme_mod( 'enable_quick_links', 0 );
    
        if ( $enable ) {
            return true;
        } else {
            return false;
        }		
    }
}

/**
 * Side Mini Cart Floating Icon Custom
 */
if( ! function_exists( 'side_mini_cart_floating_icon_custom' ) ) {
    function side_mini_cart_floating_icon_custom() {
        $icon = get_theme_mod( 'side_mini_cart_floating_icon_icon', 'icon-cart' );
        if ( $icon === 'icon-custom' ) {
            return true;
        } else {
            return false;
        }
    }
}