<?php
/**
 * Product Brand Image Metabox
 *
 * @package Botiga
 */
if ( class_exists( 'Botiga_Metabox' ) ) {

	class Botiga_Product_Brand_Image_Metabox extends Botiga_Metabox {

		public function __construct() {
			add_action( 'botiga_metabox_options', array( $this, 'add_product_brand_image_metabox_options' ) );
		}

		public function add_product_brand_image_metabox_options() {

			$this->add_section( 'brand_image', array(
				'post_type' => array( 'product' ),
				'title'     => esc_html__( 'Brand Image', 'botiga-pro' ),
			) );

			$this->add_field( '_botiga_brand_image_id', array(
				'section' => 'brand_image',
				'type'    => 'media',
				'title'   => esc_html__( 'Brand Image', 'botiga-pro' ),
			) );

		}
	}

	new Botiga_Product_Brand_Image_Metabox();

}