/**
 * Botiga Variation Gallery
 * 
 * jQuery dependent: true
 * 
 */

'use strict';

var botiga = botiga || {};

botiga.variationGallery = {

    init: function( $quickview ) {

        var $wrapper = $quickview || jQuery('.product-gallery-summary');

        if ( ! $wrapper.length ) {
            return;
        }

        var $variations = $wrapper.find('.variations_form');

        if ( ! $variations.length ) {
            return;
        }

        var $onSale = $wrapper.find('.onsale');

        $variations.on( 'found_variation', function( event, variation ) {
            
            var $galleries = $wrapper.find('.woocommerce-product-gallery');

            if ( variation.variation_gallery_images ) {

                $galleries.addClass('hidden');

                var $hasVariantGallery = jQuery( '.product-gallery-variant-'+ variation.variation_id );

                if ( $hasVariantGallery.length ) {

                    $hasVariantGallery.removeClass('hidden');

                } else {

                    var template = '';

                    template += '<div class="woocommerce-product-gallery product-gallery-variant-'+ variation.variation_id +'" style="opacity: 0; transition: opacity .25s ease-in-out;">';
                    template += '<figure class="woocommerce-product-gallery__wrapper">';
                    variation.variation_gallery_images.forEach( function( item ) {
                        template += '<div data-thumb="'+ item.gallery_thumbnail_src +'" data-thumb-alt="'+ item.alt +'" class="woocommerce-product-gallery__image">';
                        template += '<a href="'+ item.url +'">';
                        template += '<img width="'+ item.src_w +'" height="'+ item.src_h +'" src="'+ item.src +'" alt="'+ item.alt +'" title="'+ item.title +'" data-caption="'+ item.caption +'" data-src="'+ item.src +'" data-large_image="'+ item.full_src +'" data-large_image_width="'+ item.full_src_w +'" data-large_image_height="'+ item.full_src_h +'" srcset="'+ item.srcset +'" sizes="'+ item.sizes +'" class="wp-post-image" loading="lazy" />';
                        template += '</a>';
                        template += '</div>';
                    });
                    template += ( $onSale.length ) ? '<span class="onsale">'+ $onSale.text() +'</span>' : '';
                    template += '</figure>';
                    template += '</div>';

                    var $gallery = jQuery(template);

                    if ( $quickview ) {
                        $wrapper.find('.gallery-quickview').prepend($gallery);
                    } else {
                        $wrapper.prepend($gallery);
                    }

                    $gallery.trigger( 'wc-product-gallery-before-init', [ $gallery.get(0), wc_single_product_params ] );
                    $gallery.wc_product_gallery( wc_single_product_params );
                    $gallery.trigger( 'wc-product-gallery-after-init', [ $gallery.get(0), wc_single_product_params ] );
                    $gallery.find('.flex-control-nav').removeClass('flex-control-nav');

                }

            } else if ( $galleries.length > 1 ) {
                
                $galleries.addClass('hidden');
                $galleries.last().removeClass('hidden');

            }

        });

        $variations.on( 'reset_data', function() {

            var $galleries = $wrapper.find('.woocommerce-product-gallery');
            
            if ( $galleries.length > 1 ) {
                
                $galleries.addClass('hidden');
                $galleries.last().removeClass('hidden');

            }

        });

    },
    
}

jQuery( document ).ready(function(){
    botiga.variationGallery.init();
} );