/**
 * Botiga Size Chart
 * 
 * jQuery dependent: true
 * 
 */

'use strict';

var botiga = botiga || {};

botiga.sizeChart = {
    
    init: function( $wrapper ) {
        
        var $sizeChart = ( $wrapper ) ? $wrapper.find('.botiga-product-size-chart') : jQuery('.botiga-product-size-chart');

        if ( ! $sizeChart.length ) {
            return;
        }

        var $body    = jQuery('body');
        var $button  = $sizeChart.find('.botiga-product-size-chart-button a');
        var $modal   = $sizeChart.find('.botiga-product-size-chart-modal');

        $button.on('click', function( e ) {
            e.preventDefault();
            $body.addClass('botiga-product-size-chart-modal-open');
        });

        $modal.on('click', function( e ) {

            e.preventDefault();

            var $target  = jQuery(e.target);
            var $content = $sizeChart.find('.botiga-product-size-chart-modal-content');

            if ( $target.is( $modal ) || $target.closest('.botiga-product-size-chart-modal-close').length ) {

                $content.scrollTop(0);
                $body.removeClass('botiga-product-size-chart-modal-open');

            }

        });

        var $tabs   = $sizeChart.find('.botiga-product-size-chart-modal-tab');
        var $tables = $sizeChart.find('.botiga-product-size-chart-modal-table');

        if ( $tabs.length && $tables.length ) {

            $tabs.each( function() {

                var $tab = jQuery(this);

                $tab.on('click', function() {

                    $tab.addClass('active').siblings().removeClass('active');

                    $tables.eq($tab.index()).addClass('active').siblings().removeClass('active');

                });

            });

        }

    },

}

jQuery( document ).ready(function(){
    botiga.sizeChart.init();
} );