/**
 * Single Post TOC
 */

'use strict';

var botiga = botiga || {};

botiga.singlePostTOC = {

    // To ensure better compatibility with plugins like WP Rocket that has
    // options to defer/lazy-load JS files, each JS script should have your own 
    // 'domReady' function. This way the script has no dependecies and can be loaded standalone.
    domReady: function( fn ) {
		if ( typeof fn !== 'function' ) {
			return;
		}
	
		if ( document.readyState === 'interactive' || document.readyState === 'complete' ) {
			return fn();
		}
	
		document.addEventListener( 'DOMContentLoaded', fn, false );
	},
    
    init: function() {
        this.intObservers();
        this.events();
    },

    events: function() {
        var _self = this;

        // Sticky Expand Button
        const stickyExpandButton = document.querySelector( '.botiga-toc-sticky-expand' );
        stickyExpandButton.addEventListener( 'click', function(e){
            e.preventDefault();

            document.body.classList.add( 'botiga-single-post-toc-sticky-expanded' );
        } );

        // Sticky Collapse TOC
        document.addEventListener( 'click', function(e){
            if( e.target.closest( '.botiga-toc-sticky-wrapper' ) === null ) {
                document.body.classList.add( 'botiga-single-post-toc-sticky-expanded-removing' );
                document.body.classList.remove( 'botiga-single-post-toc-sticky-expanded' );
                setTimeout(function(){
                    document.body.classList.remove( 'botiga-single-post-toc-sticky-expanded-removing' );
                }, 500);
            }
        } );

        // Collapse TOC on mobile when click on links
        if( window.matchMedia( '(max-width: 780px)' ).matches ) {
            const links = document.querySelectorAll( '.botiga-single-post-toc__list-link' );
            if( links.length ) {
                for( const link of links ) {
                    link.addEventListener( 'click', function(e){
                        document.body.classList.remove( 'botiga-single-post-toc-sticky-expanded' );           
                    } );
                }
            }
        }

        // Back to top button
        // Remove all sticky effect while scrolling to top
        const backToTopButton = document.querySelector( '.back-to-top' );
        if( backToTopButton !== null ) {
            backToTopButton.addEventListener( 'click', function(e){
                document.body.classList.add( 'botiga-toc-remove-all-transitions' );
                setTimeout(function(){
                    document.body.classList.remove( 'botiga-toc-remove-all-transitions' );
                }, 1000);
            } );
        }
    },

    // Attach observers to elements
    intObservers: function() {
        const 
            tocStickyWrapper       = document.getElementsByClassName( 'botiga-toc-sticky-wrapper' )[0],
            tocStickyWrapperHeight = tocStickyWrapper.getBoundingClientRect().height;
        
        let tocObserver = new IntersectionObserver( this.obsTocStickyClass.bind( this ), {
            root: null, // browser viewport
            rootMargin: tocStickyWrapperHeight + 'px',
            threshold: 1.0
        } );

        tocObserver.observe( tocStickyWrapper );

        // Remove toc sticky class when footer is visible
        let footerObserver = new IntersectionObserver( this.obsTocStickyClass.bind( this ), {
            root: null, // browser viewport
            rootMargin: '0px',
            threshold: 0
        } );

        let footerElement = document.querySelector( '.footer-widgets' );

        if( footerElement === null ) {
            if( document.body.classList.contains( 'has-bhfb-builder' ) ) {
                footerElement = document.querySelector( '.bhfb-footer' );
            } else {
                footerElement = document.querySelector( '.site-footer' );
            }
        }

        footerObserver.observe( footerElement );
    },

    // Observers callback
    obsTocStickyClass: function( entries ) {
        const tocStickyWrapper = document.getElementsByClassName( 'botiga-toc-sticky-wrapper' )[0],
            _self = this;

        entries.forEach( entry => {
            const 
                tocStickyWrapperHeight = tocStickyWrapper.getBoundingClientRect().height;

            if ( entry.isIntersecting ) {
                _self.removeStickyClasses();
            } else {
                if( window.pageYOffset >= tocStickyWrapper.getBoundingClientRect().top + tocStickyWrapperHeight ) {
                    document.body.classList.add( 'botiga-single-post-toc-sticky' );
                    tocStickyWrapper.style.height = `${ tocStickyWrapperHeight }px`;
                } else {
                    _self.removeStickyClasses();
                }
            }
        } );
    },
    
    // Remove sticky classes
    removeStickyClasses: function() {
        const bodyClassList = document.body.classList;

        bodyClassList.add( 'botiga-single-post-toc-sticky-removing' );
        bodyClassList.remove( 'botiga-single-post-toc-sticky' );
        bodyClassList.remove( 'botiga-single-post-toc-sticky-expanded' );
        setTimeout(function(){
            bodyClassList.remove( 'botiga-single-post-toc-sticky-removing' );
        }, 500);
    }
}

// Initialize when document is ready
botiga.singlePostTOC.domReady( botiga.singlePostTOC.init() );