/**
 * Botiga Reading Progress
 */

'use strict';

var botiga = botiga || {};

botiga.readingProgress = {

    // To ensure better compatibility with plugins like WP Rocket that has
    // options to defer/lazy-load JS files, each JS script should have your own 
    // 'domReady' function. This way the script has no dependecies and can be loaded standalone.
    domReady: function( fn ) {
		if ( typeof fn !== 'function' ) {
			return;
		}
	
		if ( document.readyState === 'interactive' || document.readyState === 'complete' ) {
			return fn();
		}
	
		document.addEventListener( 'DOMContentLoaded', fn, false );
	},

    init: function() {
        const _this             = this,
            includeComments     = parseInt( document.getElementsByClassName( 'botiga-reading-progress' )[0].getAttribute( 'data-inc-comments' ) ),
            headerOffsetHeight  = document.getElementById( 'masthead' ) !== null ? document.getElementById( 'masthead' ).offsetHeight : 0;

        let contentOffsetHeight = 0;

        if( includeComments ) {
            const elements = [ 'botiga-share-box', 'post-navigation', 'single-post-author', 'botiga-related-posts', 'comments-title', 'comment-list' ];

            for( let i=0;i<elements.length;i++ ) {
                const element = document.getElementsByClassName( elements[i] )[0];
                if( typeof element !== 'undefined' ) {
                    contentOffsetHeight = contentOffsetHeight + this.outerHeight( element );
                }
            }
        }

        window.addEventListener( 'scroll', function() {
            _this.progressBarWidth( headerOffsetHeight, contentOffsetHeight );   
        } );
    },

    progressBarWidth: function( headerOffsetHeight, contentOffsetHeight ) {
        const postTopOffset = Math.abs( ( document.querySelector( 'article.post' ).getBoundingClientRect().top - headerOffsetHeight ) - window.innerHeight );

        if( postTopOffset < 0 ) {
            document.body.style.setProperty( 
                '--botiga-reading-progress',
                '0%'
            );
        } else {
            let progress = (Math.abs( postTopOffset ) / ( document.querySelector( 'article.post' ).offsetHeight + contentOffsetHeight )) * 100;

            // Do not overtake 100
            if( progress >= 100 ) {
                progress = 100;
            }

            document.body.style.setProperty( 
                '--botiga-reading-progress',
                `${progress}%`
            );
        }

        if( window.pageYOffset < 100 ) {
            document.body.classList.add( 'hide-reading-progress' );
        } else {
            document.body.classList.remove( 'hide-reading-progress' );
        }
    },

    throttle: function(fn, wait) {
        var time = Date.now();
        return function() {
            if ((time + wait - Date.now()) < 0) {
                fn();
                time = Date.now();
            }
        }
    },

    outerHeight: function(el) {
        var height = el.offsetHeight;
        var style = getComputedStyle(el);
      
        height += parseInt(style.marginTop) + parseInt(style.marginBottom);
        return height;
    }
}

botiga.readingProgress.domReady( botiga.readingProgress.init() );