/**
 * Google Autocomplete
 * 
 */
(function($){

    'use strict';

    var botiga = botiga || {};

    botiga.googleAutocomplete = {

        init: function() {

            if ( $('#billing_country').length ) {
                this.autocompleteAddress( 'billing' );
            }

            if ( $('#shipping_country').length ) {
                this.autocompleteAddress( 'shipping' );
            }

            return this;

        },

        autocompleteAddress: function( type ) {

            var $fieldCountry  = $('#'+ type +'_country');
            var $fieldAddress1 = $('#'+ type +'_address_1');
            var $fieldAddress2 = $('#'+ type +'_address_2');
            var $fieldCity     = $('#'+ type +'_city');
            var $fieldState    = $('#'+ type +'_state');
            var $fieldPostcode = $('#'+ type +'_postcode');

            var autocomplete = new google.maps.places.Autocomplete( $fieldAddress1.get(0), {
                componentRestrictions: {
                    country: $fieldCountry.val().toLowerCase(),
                },
                fields: ['address_components'],
                types: ['address'],
            });

            $fieldCountry.on( 'change', function() {
                autocomplete.setOptions({
                    componentRestrictions: {
                        country: jQuery(this).val().toLowerCase(),
                    },
                });
            });

            autocomplete.addListener('place_changed', function() {

                var place      = this.getPlace();
                var number     = '';
                var address1   = '';
                var address2   = '';
                var postcode   = '';
                var city       = '';
                var state      = '';
                var state_name = '';

                for (var component of place.address_components) {

                    var componentType = component.types[0];

                    switch ( componentType ) {
                        case 'street_number':
                            number = component.long_name;
                        break;

                        case 'route':
                            address1 = component.long_name;
                        break;

                        case 'postal_code':
                            postcode = component.long_name;
                        break;

                        case 'locality':
                        case 'sublocality':
                        case 'sublocality_level_1':
                            city = component.long_name;
                        break;

                        case 'political':
                        case 'administrative_area_level_2':
                        case 'administrative_area_level_3':
                            if ( ! city ) {
                                city = component.long_name;
                            }
                        break;

                        case 'administrative_area_level_1':
                            state = component.long_name;
                        break;
                    }

                }

                if ( $fieldAddress1.length ) {
                    if ( number ) {
                        address1 = number +' '+ address1;
                    }
                    $fieldAddress1.val( address1 );
                }

                if ( $fieldPostcode.length ) {
                    $fieldPostcode.val( postcode );
                }

                if ( $fieldCity.length ) {
                    $fieldCity.val( city );
                }

                if ( $fieldState.length ) {
                    $fieldState.val( state );
                    var state_found = false;
                    $fieldState.find('option').each(function() {
                        var $option = $(this);
                        if ( $option.val() === state || $option.text() === state ) {
                            $fieldState.val( $option.val() );
                            state_found = true;
                        }
                    });
                    if ( ! state_found ) {
                        $fieldState.find('option').each(function() {
                            var $option = $(this);
                            if ( $option.val() === city || $option.text() === city ) {
                                $fieldState.val( $option.val() );
                                state_found = true;
                            }
                        });
                    }
                    $fieldState.trigger('change');
                }

                $(document).trigger('update_checkout');


            }, false);

        },

    };

    window.botigaGoogleAutoComplete = function() {
        botiga.googleAutocomplete.init();
    }

})(jQuery);
