<?php
/**
 * Custom Botiga WooCommerce Template Functions
 * 
 * @package Botiga_Pro
 */

if ( ! function_exists( 'botiga_woocommerce_catalog_ordering' ) ) {

	/**
	 * Output the product sorting options.
	 */
	function botiga_woocommerce_catalog_ordering() {
		$show_default_orderby    = 'menu_order' === apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby', 'menu_order' ) );
		$catalog_orderby_options = apply_filters(
			'woocommerce_catalog_orderby',
			array(
				'menu_order' => __( 'Default sorting', 'woocommerce' ),
				'popularity' => __( 'Sort by popularity', 'woocommerce' ),
				'rating'     => __( 'Sort by average rating', 'woocommerce' ),
				'date'       => __( 'Sort by latest', 'woocommerce' ),
				'price'      => __( 'Sort by price: low to high', 'woocommerce' ),
				'price-desc' => __( 'Sort by price: high to low', 'woocommerce' ),
			)
		);

		$default_orderby = wc_get_loop_prop( 'is_search' ) ? 'relevance' : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby', '' ) );
		// phpcs:disable WordPress.Security.NonceVerification.Recommended
		$orderby = isset( $_GET['orderby'] ) ? wc_clean( wp_unslash( $_GET['orderby'] ) ) : $default_orderby;
		// phpcs:enable WordPress.Security.NonceVerification.Recommended

		if ( wc_get_loop_prop( 'is_search' ) ) {
			$catalog_orderby_options = array_merge( array( 'relevance' => __( 'Relevance', 'woocommerce' ) ), $catalog_orderby_options );

			unset( $catalog_orderby_options['menu_order'] );
		}

		if ( ! $show_default_orderby ) {
			unset( $catalog_orderby_options['menu_order'] );
		}

		if ( ! wc_review_ratings_enabled() ) {
			unset( $catalog_orderby_options['rating'] );
		}

		if ( ! array_key_exists( $orderby, $catalog_orderby_options ) ) {
			$orderby = current( array_keys( $catalog_orderby_options ) );
		}

		wc_get_template(
			'loop/orderby.php',
			array(
				'catalog_orderby_options' => $catalog_orderby_options,
				'orderby'                 => $orderby,
				'show_default_orderby'    => $show_default_orderby,
			)
		);
	}
}

if ( ! function_exists( 'botiga_woocommerce_result_count' ) ) {

	/**
	 * Output the result count text (Showing x - x of x results).
	 */
	function botiga_woocommerce_result_count( $args ) {
		$args = wp_parse_args(
            apply_filters( 'botiga_woocommerce_result_count_args', $args ),
            array(
                'total'    => wc_get_loop_prop( 'total' ),
                'per_page' => wc_get_loop_prop( 'per_page' ),
                'current'  => wc_get_loop_prop( 'current_page' ),
            )
        );

		wc_get_template( 'loop/result-count.php', $args );
	}
}

if ( ! function_exists( 'botiga_woocommerce_pagination' ) ) {

	/**
	 * Output the pagination.
	 */
	function botiga_woocommerce_pagination( $args ) {
        $args = wp_parse_args(
            apply_filters( 'botiga_woocommerce_pagination_args', $args ),
            array(
                'total'   => wc_get_loop_prop( 'total_pages' ),
                'current' => wc_get_loop_prop( 'current_page' ),
                'base'    => esc_url_raw( add_query_arg( 'product-page', '%#%', false ) ),
                'format'  => '?product-page=%#%',
            )
        );

		wc_get_template( 'loop/pagination.php', $args );
	}
}