<?php
/**
 * Single Product Trust Badge
 * 
 * @package Botiga_Pro
 */

/**
 * Extend single product elements defaults with new options
 * 
 */
function botiga_pro_single_product_trust_badge_default_components( $components ) {
    $components[] = 'botiga_single_product_trust_badge_image';

    return $components;
}
add_filter( 'botiga_default_single_product_components', 'botiga_pro_single_product_trust_badge_default_components', 12 );

/**
 * Trust badge output 
 * 
 */
function botiga_single_product_trust_badge_image() {
    $trust_badge_image = get_theme_mod( 'botiga_single_product_trust_badge_image', '' );

    if( $trust_badge_image ) { ?>
        <div class="botiga-trust-badge-wrapper">
            <strong class="botiga-trust-badge-title"><?php esc_html_e( 'Guaranteed Safe Checkout', 'botiga-pro' ); ?></strong>
            <img src="<?php echo esc_url( $trust_badge_image ); ?>" alt="<?php esc_attr_e( 'Guaranteed Safe Checkout', 'botiga-pro' ); ?>"  />
        </div>
        <?php
    }
}

/**
 * Trust badge custom css
 * 
 */
function botiga_trust_badge_custom_css( $css ) {
    $trust_badge_image = get_theme_mod( 'botiga_single_product_trust_badge_image', '' ); 

    if( $trust_badge_image ) {
        $css .= '
            .botiga-trust-badge-wrapper {
                position: relative;
                padding: 15px;
                text-align: center;
                border: 1px solid #e2e2e2;
            }
            
            .botiga-trust-badge-wrapper .botiga-trust-badge-title {
                position: absolute;
                top: -0.9em;
                left: 50%;
                padding: 0 20px;
                white-space: nowrap;
                -webkit-transform: translate3d(-50%, 0, 0);
                        transform: translate3d(-50%, 0, 0);
            }
            
            @media (max-width: 320px) {
                .botiga-trust-badge-wrapper .botiga-trust-badge-title {
                    padding: 0 10px;
                }
            }
        ';
        
        $css .= Botiga_Custom_CSS::get_border_color_rgba_css( 'color_heading_4', '#212121', '.botiga-trust-badge-wrapper', 0.15 );
        $css .= Botiga_Custom_CSS::get_background_color_css( 'background_color', '#FFF', '.botiga-trust-badge-wrapper .botiga-trust-badge-title' );
    }

    return $css;
}
add_filter( 'botiga_custom_css_output', 'botiga_trust_badge_custom_css' );