<?php
/**
 * Shop Pagination
 * 
 * @package Botiga_Pro
 */

/**
 * Enqueue CSS and JS
 */
function botiga_woo_pagination_enqueue_scripts() {
    if( ! botiga_is_woo_pagination_needed() ) {
        return;
    }

    wp_enqueue_script( 'botiga-pagination', BOTIGA_PRO_URI . 'assets/js/botiga-pagination.min.js', array(), BOTIGA_PRO_VERSION, true );
}
add_action( 'wp_enqueue_scripts', 'botiga_woo_pagination_enqueue_scripts', 10 );

/**
 * Identify the type of navigation with a body class
 */
function botiga_woo_pagination_active_body_class( $classes ) {
    if( ! botiga_is_woo_pagination_needed() ) {
        return $classes;
    }

    $classes[] = 'botiga-pagination-load-more';

    return $classes;
}
add_filter( 'body_class', 'botiga_woo_pagination_active_body_class' );

/**
 * Insert button HTML through hook
 */
function botiga_woo_pagination_hooks() {
    if( ! botiga_is_woo_pagination_needed() ) {
        return;
    }

    // Add woo pagination load more/infinite-scroll button
    add_action( 'woocommerce_after_shop_loop', 'botiga_woo_pagination_load_more_button' );

}
add_action( 'wp', 'botiga_woo_pagination_hooks' );

/**
 * Pagination Button
 */
function botiga_woo_pagination_load_more_button() { 
    $total_pages                  = wc_get_loop_prop( 'total_pages' );
    $shop_archive_pagination_type = get_theme_mod( 'shop_archive_pagination_type', 'default' ); 
    
    if( $total_pages <= 1 ) {
        return;
    }
    
    ?>

    <div class="botiga-pagination-wrapper">
        <a href="javascript:void(0);" class="botiga-pagination-button<?php echo ( $shop_archive_pagination_type === 'infinite-scroll' ) ? ' loading-anim' : ' button'; ?>" role="button" data-current-page="1" data-total-pages="<?php echo esc_attr( $total_pages ); ?>" data-pagination-type="<?php echo esc_attr( $shop_archive_pagination_type ); ?>">
            <span class="botiga-pagination-button__label">
                <?php echo esc_html__( 'Load More', 'botiga-pro' ); ?>
            </span>
            <span class="botiga-pagination-button__loader">
                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 512 512" aria-hidden="true" focusable="false">
                    <path fill="#FFF" d="M288 39.056v16.659c0 10.804 7.281 20.159 17.686 23.066C383.204 100.434 440 171.518 440 256c0 101.689-82.295 184-184 184-101.689 0-184-82.295-184-184 0-84.47 56.786-155.564 134.312-177.219C216.719 75.874 224 66.517 224 55.712V39.064c0-15.709-14.834-27.153-30.046-23.234C86.603 43.482 7.394 141.206 8.003 257.332c.72 137.052 111.477 246.956 248.531 246.667C393.255 503.711 504 392.788 504 256c0-115.633-79.14-212.779-186.211-240.236C302.678 11.889 288 23.456 288 39.056z" />
                </svg>
            </span>
        </a>
    </div>
    <?php
}

/**
 * Check if should run the pagination code
 */
function botiga_is_woo_pagination_needed() {
    if( ! is_shop() && ! is_product_category() && ! is_product_tag() && ! is_product_taxonomy() ) {
        return false;
    }

    $shop_archive_pagination_type = get_theme_mod( 'shop_archive_pagination_type', 'default' );
    if( 'default' === $shop_archive_pagination_type ) {
        return false;
    }

    if ( ! wc_get_loop_prop( 'is_paginated' ) || ! woocommerce_products_will_display() ) {
        return false;
    }

    return true;
}