<?php
/**
 * Product Stock
 * 
 * @package Botiga_Pro
 */

/**
 * Main hook
 */
function botiga_shop_product_stock() {

    $shop_product_stock = get_theme_mod( 'shop_product_stock', 0 );

    if( ! $shop_product_stock ) {
        return;
    }

    add_action( 'woocommerce_after_shop_loop_item', 'botiga_add_product_stock_to_loop_items', 99 );

}
add_action( 'wp', 'botiga_shop_product_stock' );

/**
 * Add product stock to loop items
 */
function botiga_add_product_stock_to_loop_items( $product ) {

    if ( ! $product ) {
        global $product;
    }

    $stock_format      = get_option( 'woocommerce_stock_format' );
    $stock_amount      = $product->get_stock_quantity();
    $out_of_stock      = ( ! $product->managing_stock() && ! $product->is_in_stock() ) ? true : false;
    $out_of_stock_text = ! get_theme_mod( 'out_of_stock_text', '' ) ? __( 'Out of Stock', 'botiga-pro' ) : get_theme_mod( 'out_of_stock_text', '' );
    $in_stock_text     = __( 'In Stock', 'botiga-pro' );
    $backorder_text    = __( 'Available on backorder', 'botiga-pro' );
    $low_stock_amount  = wc_get_low_stock_amount( $product );

    $output = '';

    $extra_atts = array();
    $classes    = array( 'botiga-product-stock' );

    $extra_atts[] = 'data-in-stock-text="' . esc_attr( $in_stock_text ) . '"';
    $extra_atts[] = 'data-out-of-stock-text="' . esc_attr( $out_of_stock_text ) . '"';
    $extra_atts[] = 'data-backorder-text="' . esc_attr( $backorder_text ) . '"';

    $extra_atts   = implode( ' ', $extra_atts );

    if ( ! empty( $stock_amount ) && $stock_amount <= $low_stock_amount ) {
        $low_stock_class = ( $stock_format !== 'no_amount' ) ? ' botiga-product-stock-low' : '';
        $classes[] = $low_stock_class;

        $output .= '<span>'. wc_format_stock_for_display( $product ) .'</span>';
    } else if ( ! empty( $stock_amount ) && $stock_amount > $low_stock_amount ) {
        $output .= '<span>'. wc_format_stock_for_display( $product ) .'</span>';
    } else if ( ! empty( $stock_amount ) || empty( $out_of_stock ) ) {
        if( $product->is_on_backorder() ) {
            $output .= '<span>'. esc_html( $backorder_text ) .'</span>';
        } else {
            $output .= '<span>'. esc_html( $in_stock_text ) .'</span>';
        }
    } else if ( ! empty( $out_of_stock ) ) {
        $classes[] = 'botiga-product-stock-low';
        $output .= '<span>'. esc_html( $out_of_stock_text ) .'</span>';
    }

    $output = sprintf( '<div class="%1$s"%2$s>%3$s</div>', esc_attr( implode( ' ', $classes ) ), $extra_atts, $output );
    echo $output; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- previously escaped
        
}
