<?php
/**
 * Product Quantity
 * 
 * @package Botiga_Pro
 */

/**
 * Main hook
 * 
 */
function botiga_shop_product_quantity() {

    $shop_product_quantity = get_theme_mod( 'shop_product_quantity', 0 );

    if ( ! $shop_product_quantity ) {
        return;
    }

    add_filter( 'woocommerce_loop_add_to_cart_link', 'botiga_add_quantity_to_loop_add_to_cart', 10, 2 );

}
add_action( 'wp', 'botiga_shop_product_quantity' );

/**
 * Add quantity to loop add to cart
 * 
 */
function botiga_add_quantity_to_loop_add_to_cart( $html, $product ) {

    if ( empty( $product ) ) {
        global $product;
    }

    $button_layout = get_theme_mod( 'shop_product_add_to_cart_layout', 'layout3' );

    if ( $product && $product->is_type( 'simple' ) && $product->is_purchasable() && $product->is_in_stock() && ! $product->is_sold_individually() ) {
        $html = woocommerce_quantity_input( array(), $product, false ) . $html;
    }

    return $html;

}