<?php 
/**
 * Wishlist Customizer Options
 */
$wp_customize->add_section(
    'botiga_section_wishlist',
    array(
        'title'    => esc_html__( 'Wishlist', 'botiga-pro'),
        'priority' => 130,
    )
);

$wp_customize->add_setting(
    'shop_product_wishlist_tab',
    array(
        'default'           => '',
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control(
    new Botiga_Tab_Control (
        $wp_customize,
        'shop_product_wishlist_tab',
        array(
            'label'            => '',
            'section'          => 'botiga_section_wishlist',
            'controls_general' => json_encode( array(
                '#customize-control-shop_product_wishlist_layout',
                '#customize-control-shop_product_wishlist_info',
                '#customize-control-shop_product_wishlist_tooltip',
                '#customize-control-shop_product_wishlist_tooltip_text',
                '#customize-control-shop_product_wishlist_show_on_hover',
                '#customize-control-shop_archive_pro_divider3',
                '#customize-control-shop_archive_wishlist_title1',
                '#customize-control-shop_archive_wishlist_create_page',
                '#customize-control-shop_archive_pro_divider4'
            ) ),
            'controls_design'  => json_encode( array( '
                #customize-control-shop_product_wishlist_icon_active_color',
                '#customize-control-shop_product_wishlist_icon_background_color'
            ) ),
            'priority'         => -1
        )
    )
);

$wp_customize->add_setting(
    'shop_product_wishlist_layout',
    array(
        'default'           => 'layout1',
        'sanitize_callback' => 'sanitize_key',
    )
);
$wp_customize->add_control(
    new Botiga_Radio_Images(
        $wp_customize,
        'shop_product_wishlist_layout',
        array(
            'label'       => esc_html__( 'Wishlist', 'botiga-pro' ),
            'desc_below'  => true,
            'section'     => 'botiga_section_wishlist',
            'cols'        => 3,
            'choices'  => array(
                'layout1' => array(
                    'label' => esc_html__( 'Layout 1', 'botiga-pro' ),
                    'url'   => '%s/assets/img/wl1.svg'
                ),
                'layout2' => array(
                    'label' => esc_html__( 'Layout 2', 'botiga-pro' ),
                    'url'   => '%s/assets/img/wl2.svg'
                ),  
                'layout3' => array(
                    'label' => esc_html__( 'Layout 3', 'botiga-pro' ),
                    'url'   => '%s/assets/img/wl3.svg'
                ),                                      
            ),
            'priority'     => 10
        )
    )
);

$wp_customize->add_setting(
    'shop_product_wishlist_info',
    array(
        'default'           => '',
        'sanitize_callback' => 'esc_attr',
    )
);
$wp_customize->add_control(
    new Botiga_Text_Control(
        $wp_customize,
        'shop_product_wishlist_info',
        array(
            'description'       => esc_html__( 'Learn more about this feature in our documentation by clicking on the below link.', 'botiga-pro' ),
            'link_title'        => esc_html__( 'Learn more', 'botiga-pro' ),
            'link'              => 'https://docs.athemes.com/article/389-pro-wishlist',
            'section'           => 'botiga_section_wishlist',
            'check_white_label' => true,
            'priority'          => 111
        )
    )
);

$wp_customize->add_setting(
    'shop_product_wishlist_tooltip',
    array(
        'default'           => 0,
        'sanitize_callback' => 'botiga_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    new Botiga_Toggle_Control(
        $wp_customize,
        'shop_product_wishlist_tooltip',
        array(
            'label'             => esc_html__( 'Wishlist Tooltip', 'botiga-pro' ),
            'section'           => 'botiga_section_wishlist',
            'active_callback'   => 'botiga_callback_shop_product_wishlist_layout',
            'priority'          => 11
        )
    )
);

$wp_customize->add_setting(
    'shop_product_wishlist_tooltip_text',
    array(
        'sanitize_callback' => 'botiga_sanitize_text',
        'default'           => '',
    )       
);
$wp_customize->add_control( 
    'shop_product_wishlist_tooltip_text', 
    array(
        'label'           => esc_html__( 'Tooltip Text', 'botiga-pro' ),
        'type'            => 'text',
        'section'         => 'botiga_section_wishlist',
        'active_callback' => 'botiga_callback_shop_product_wishlist_tooltip',
        'priority'        => 12
    ) 
);

$wp_customize->add_setting(
    'shop_product_wishlist_show_on_hover',
    array(
        'default'           => 0,
        'sanitize_callback' => 'botiga_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    new Botiga_Toggle_Control(
        $wp_customize,
        'shop_product_wishlist_show_on_hover',
        array(
            'label'             => esc_html__( 'Show On Hover', 'botiga-pro' ),
            'section'           => 'botiga_section_wishlist',
            'active_callback'   => 'botiga_callback_shop_product_wishlist_layout',
            'priority'          => 12
        )
    )
);

// Wishlist Page Settings
$wp_customize->add_setting( 'shop_archive_pro_divider3',
    array(
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'shop_archive_pro_divider3',
        array(
            'section'           => 'botiga_section_wishlist',
            'active_callback'   => 'botiga_callback_shop_product_wishlist_layout',
            'priority'          => 13
        )
    )
);

$wp_customize->add_setting( 
    'shop_archive_wishlist_title1',
    array(
        'default'           => '',
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control( 
    new Botiga_Text_Control( 
        $wp_customize, 
        'shop_archive_wishlist_title1',
        array(
            'label'         => esc_html__( 'Wishlist Page Settings', 'botiga-pro' ),
            'section'       => 'botiga_section_wishlist',
            'active_callback'   => 'botiga_callback_shop_product_wishlist_layout',
            'priority'      => 14
        )
    )
);

if( class_exists( 'Botiga_Create_Page_Control' ) ) {
    $wp_customize->add_setting( 
        'shop_archive_wishlist_create_page',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control( 
        new Botiga_Create_Page_Control( 
            $wp_customize, 
            'shop_archive_wishlist_create_page',
            array(
                'label'           => esc_html__( 'Create Wishlist Page', 'botiga-pro' ),
                'page_title'      => esc_html__( 'My Wishlist', 'botiga-pro' ),
                'page_meta_key'   => '_wp_page_template',
                'page_meta_value' => 'page-templates/template-wishlist.php',
                'option_name'     => 'botiga_wishlist_page_id',
                'section'         => 'botiga_section_wishlist',
                'active_callback' => 'botiga_callback_shop_product_wishlist_layout',
                'priority'        => 15
            )
        )
    );
}

$wp_customize->add_setting( 'shop_archive_pro_divider4',
    array(
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'shop_archive_pro_divider4',
        array(
            'section'           => 'botiga_section_wishlist',
            'active_callback'   => 'botiga_callback_shop_product_wishlist_layout',
            'priority'          => 16
        )
    )
);

$wp_customize->add_setting(
    'shop_product_wishlist_icon_active_color',
    array(
        'default'           => '#fda5a5',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control(
    new Botiga_Alpha_Color(
        $wp_customize,
        'shop_product_wishlist_icon_active_color',
        array(
            'label'             => esc_html__( 'Active Icon Color', 'botiga-pro' ),
            'section'           => 'botiga_section_wishlist',
            'priority'          => 17
        )
    )
);

$wp_customize->add_setting(
    'shop_product_wishlist_icon_background_color',
    array(
        'default'           => 'rgba(255,255,255,0)',
        'sanitize_callback' => 'botiga_sanitize_hex_rgba',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control(
    new Botiga_Alpha_Color(
        $wp_customize,
        'shop_product_wishlist_icon_background_color',
        array(
            'label'             => esc_html__( 'Icon Background Color', 'botiga-pro' ),
            'section'           => 'botiga_section_wishlist',
            'priority'          => 17
        )
    )
);