<?php
/**
 *  Product Video
 * 
 * @package Botiga_Pro
 */

if ( class_exists( 'Botiga_Modules' ) && ! Botiga_Modules::is_module_active( 'video-gallery' ) ) {
    return;
}

require BOTIGA_PRO_DIR . 'inc/modules/video-gallery/video-gallery-metabox.php';

class Botiga_Product_Video{

    public $count = 0;

    public $embeded = false;

    public $restore_filters = array();

    public function __construct() {

        add_action( 'wp', array( $this, 'botiga_shop_archive_product_video_init' ) );

        // Quick view video gallery support
        add_filter( 'botiga_quick_view_image_gallery_classes', array( $this, 'botiga_single_product_video_classes' ) );
        add_filter( 'botiga_quick_view_image_thumbnail_html', array( $this, 'botiga_single_product_video' ), 10, 2 );

    }

    /**
     * Product video init.
     */
    public function botiga_shop_archive_product_video_init() {

        add_action( 'woocommerce_before_shop_loop_item', array( $this, 'botiga_shop_archive_product_video' ), 5 );
        add_action( 'woocommerce_after_shop_loop_item', array( $this, 'botiga_shop_archive_product_video_restore_filters' ), 25 );
        
        add_filter( 'wp_enqueue_scripts', array( $this, 'wp_enqueue_scripts' ) );
        add_filter( 'woocommerce_single_product_image_gallery_classes', array( $this, 'botiga_single_product_video_classes' ) );
        add_filter( 'woocommerce_single_product_image_thumbnail_html', array( $this, 'botiga_single_product_video' ), 10, 2 );


    }

    public function wp_enqueue_scripts() {
        wp_register_script( 'botiga-video-gallery', BOTIGA_PRO_URI . 'assets/js/botiga-video-gallery.min.js', array(), BOTIGA_PRO_VERSION, true );
    }

    /**
     * Shop archive product video.
     */
    public function botiga_shop_archive_product_video() {

        $post_id               = ( ! empty( $product ) ) ? $product->get_id() : get_the_ID();
        $enable_featured_video = get_post_meta( $post_id, '_botiga_enable_featured_video', true );
        $featured_video_url    = get_post_meta( $post_id, '_botiga_featured_video_url', true );

        if ( ! empty( $enable_featured_video ) && ! empty( $featured_video_url ) ) {
    
            wp_enqueue_script( 'botiga-video-gallery' );

            $video_autoplay     = get_post_meta( $post_id, '_botiga_featured_video_autoplay', true );
            $video_aspect_ratio = get_post_meta( $post_id, '_botiga_video_aspect_ratio', true );
            $video_aspect_ratio = ( ! empty( $video_aspect_ratio ) ) ? $video_aspect_ratio : '16-9';
            $aspect_ratio_class = ( $video_aspect_ratio !== 'auto' ) ? 'botiga-video-ratio botiga-video-ratio-'. $video_aspect_ratio : 'botiga-video-ratio-auto';

            // Unset all "before_shop_loop_item_title" filters (quickview, thumbnail, wishlist, sale etc.)
            $remove_filters = array(
                'botiga_quick_view_button',
                'botiga_wishlist_button',
                'woocommerce_show_product_loop_sale_flash',
                'botiga_template_loop_product_second_thumbnail',
                'woocommerce_template_loop_product_thumbnail',
            );

            global $wp_filter;
            
            $hook = 'woocommerce_before_shop_loop_item_title';

            foreach ( $remove_filters as $callback ) {

                $priority = has_filter( $hook, $callback );

                if ( $priority !== FALSE ) {

                    $filter = $wp_filter[ $hook ]->callbacks[ $priority ][ $callback ];

                    $this->restore_filters[] = array(
                        'callback'      => $filter['function'],
                        'accepted_args' => $filter['accepted_args'],
                        'priority'      => $priority,
                    );

                    remove_filter( $hook, $callback, $priority );

                }

            }

            $file_type = wp_check_filetype( $featured_video_url, wp_get_mime_types() );
            $ext_type  = wp_ext2type( $file_type['ext'] );

            if ( in_array( $ext_type, array( 'video', 'audio' ) ) ) {
                
                $autoplay_atts = ( ! empty( $video_autoplay ) ) ? ' autoplay muted loop' : ' controls';

                if ( $ext_type === 'video' ) {

                    echo '<div class="botiga-product-video '. esc_attr( $aspect_ratio_class ) .'">';
                    echo '<video'. esc_attr( $autoplay_atts ) .'>';
                    echo '<source src="'. esc_url( $featured_video_url ) .'"" type="'. esc_attr( $file_type['type'] ) .'" />';
                    echo '</video>';
                    echo '</div>';

                } else if ( $ext_type === 'audio' ) {

                    echo '<div class="botiga-product-audio">';
                    echo '<audio'. esc_attr( $autoplay_atts ) .'>';
                    echo '<source src="'. esc_url( $featured_video_url ) .'"" type="'. esc_attr( $file_type['type'] ) .'" />';
                    echo '</audio>';
                    echo '</div>';

                }

            } else {

                $oembed_data = _wp_oembed_get_object()->get_data( $featured_video_url );

                if ( ! empty( $oembed_data ) ) {

                    $provider = strtolower( $oembed_data->provider_name );

                    if ( ! empty( $video_autoplay ) && in_array( $provider, array( 'youtube', 'vimeo', 'dailymotion' ) ) ) {

                        preg_match( '/<iframe.*src=\"(.*)\".*><\/iframe>/isU', $oembed_data->html, $matches );
                        
                        if ( ! empty( $matches[0] ) && ! empty( $matches[1] ) ) {
                            $autoplay_args = array( 'autoplay' => '1', 'mute' => '1', 'muted' => '1', 'controls' => '0', 'byline' => '0', 'title' => '0' );
                            $oembed_data->html = str_replace( $matches[1], add_query_arg( $autoplay_args, $matches[1] ), $oembed_data->html );
                        }
                    
                    }

                    echo '<div class="botiga-product-video '. esc_attr( $aspect_ratio_class ) .'">';
                    echo _wp_oembed_get_object()->data2html( $oembed_data, $featured_video_url );
                    echo '</div>';

                }

            }

        }
    
    }
    
    /**
     * Restore shop item title filters.
     */
    public function botiga_shop_archive_product_video_restore_filters() {

        if ( ! empty( $this->restore_filters ) ) {
            foreach ( $this->restore_filters as $filter ) {
                add_filter( 'woocommerce_before_shop_loop_item_title', $filter['callback'], $filter['priority'], $filter['accepted_args'] );
            }
            $this->restore_filters = array();
        }

    }

    /**
     * Single product video classes.
     */
    public function botiga_single_product_video_classes( $classes ) {

        global $product;

        $post_id                  = ( ! empty( $product ) ) ? $product->get_id() : get_the_ID();
        $enable_gallery           = get_post_meta( $post_id, '_botiga_enable_gallery', true );
        $videos_in_gallery        = (array) get_post_meta( $post_id, '_botiga_videos_in_gallery', true );
        $upload_videos_in_gallery = (array) get_post_meta( $post_id, '_botiga_upload_videos_in_gallery', true );
        $selected_videos          = array_filter( array_merge( $videos_in_gallery, $upload_videos_in_gallery ) );

        if ( ! empty( $enable_gallery ) && ! empty( $selected_videos ) ) {
            $classes[] = 'botiga-product-video-gallery';
        }

        return $classes;

    }

    /**
     * Single video gallery.
     */
    public function botiga_single_product_video( $html, $post_thumbnail_id ) {

        global $product;

        $post_id                  = ( ! empty( $product ) ) ? $product->get_id() : get_the_ID();
        $position                 = get_post_meta( $post_id, '_botiga_video_position', true );
        $enable_gallery           = get_post_meta( $post_id, '_botiga_enable_gallery', true );
        $videos_in_gallery        = (array) get_post_meta( $post_id, '_botiga_videos_in_gallery', true );
        $upload_videos_in_gallery = (array) get_post_meta( $post_id, '_botiga_upload_videos_in_gallery', true );
        $selected_videos          = array_filter( array_merge( $videos_in_gallery, $upload_videos_in_gallery ) );

        // Append to videos after image gallery
        if ( $position === 'after' ) {
            $this->count++;
            $attachment_ids = $product->get_gallery_image_ids();
            if ( ! empty( $attachment_ids ) && count( $attachment_ids ) >= $this->count ) {
                return $html;
            }
        }

        // Clear placeholder image in video gallery.
        if ( ! empty( $enable_gallery ) && ! empty( $selected_videos ) && empty( $post_thumbnail_id ) ) {
            $html = '';
        }

        $video_html = '';

        if ( ! empty( $enable_gallery ) && ! empty( $selected_videos ) && empty( $this->embeded ) ) {

            wp_enqueue_script( 'botiga-video-gallery' );

            $video_aspect_ratio = get_post_meta( $post_id, '_botiga_video_aspect_ratio', true );
            $video_aspect_ratio = ( ! empty( $video_aspect_ratio ) ) ? $video_aspect_ratio : '16-9';
            $aspect_ratio_class = ( $video_aspect_ratio !== 'auto' ) ? 'botiga-video-ratio botiga-video-ratio-'. $video_aspect_ratio : 'botiga-video-ratio-auto';
           
            foreach ( $selected_videos as $video_url ) {

                $file_type = wp_check_filetype( $video_url, wp_get_mime_types() );
                $ext_type  = wp_ext2type( $file_type['ext'] );

                if ( in_array( $ext_type, array( 'video', 'audio' ) ) ) {

                    $placeholder = get_stylesheet_directory_uri() .'/assets/img/placeholder.svg';

                    $video_html .= '<div data-thumb="'. esc_url( $placeholder ) .'" data-video="html5" class="woocommerce-product-gallery__image">';

                        if ( $ext_type === 'video' ) {

                            $video_html .= '<div class="botiga-product-video '. esc_attr( $aspect_ratio_class ) .'">';
                            $video_html .= '<video controls>';
                            $video_html .= '<source src="'. esc_url( $video_url ) .'"" type="'. esc_attr( $file_type['type'] ) .'" />';
                            $video_html .= '</video>';
                            $video_html .= '</div>';

                        } else if ( $ext_type === 'audio' ) {

                            $video_html .= '<div class="botiga-product-audio">';
                            $video_html .= '<audio controls>';
                            $video_html .= '<source src="'. esc_url( $video_url ) .'"" type="'. esc_attr( $file_type['type'] ) .'" />';
                            $video_html .= '</audio>';
                            $video_html .= '</div>';
                        }

                    $video_html .= '</div>';

                } else {

                    $oembed_data = _wp_oembed_get_object()->get_data( $video_url, array( 'id' => 'ok' ) );

                    if ( ! empty( $oembed_data ) ) {

                        $video_html .= '<div data-thumb="'. esc_attr( $oembed_data->thumbnail_url ) .'" data-video="oembed" class="woocommerce-product-gallery__image">';
                        $video_html .= '<div class="botiga-product-video '. esc_attr( $aspect_ratio_class ) .'">';
                        $video_html .= _wp_oembed_get_object()->data2html( $oembed_data, $video_url );
                        $video_html .= '</div>';
                        $video_html .= '</div>';

                    }
            
                }

            }

            if ( ! empty( $video_html ) ) {

                $position = get_post_meta( $post_id, '_botiga_video_position', true );

                // Append to videos after or before image gallery
                if ( $position === 'after' ) {
                    $html = $html . $video_html;
                } else {
                    $html = $video_html . $html;
                }
        
                $this->embeded = true;

            }
        
        }

        return $html;

    }

}

new Botiga_Product_Video();
