<?php
/**
 * WooCommerce Shop Archive Page Header
 * Templates Builder Block
 * 
 * @package Botiga_Pro
 */

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/block-editor/tutorials/block-tutorial/writing-your-first-block-type/
 */

function botiga_register_wc_notices_block() {
    register_block_type_from_metadata( 
        BOTIGA_PRO_DIR . '/inc/modules/templates-builder/components/gutenberg/build/wc-notices/block.json',
        array(
            'render_callback' => 'botiga_wc_notices_block_callback'
        )
    );
}
add_action( 'init', 'botiga_register_wc_notices_block', 11 );

/**
 * Render callback
 * 
 */
function botiga_wc_notices_block_callback( $block_atts ) {
    $blockId    = $block_atts['blockId'];
    $custom_css = Botiga_Templates_Builder_Gutenberg_Helper::get_block_custom_css( $block_atts );
    $edit_mode  = is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy() || is_singular( 'product' ) || is_singular( 'athemes_hf' ) ? false : true;
    
    ob_start();
    if( ! $edit_mode ) {
        woocommerce_output_all_notices();
    } else { ?>
        <div class="woocommerce-notices-wrapper" style="opacity: 0.7;">
            <div class="woocommerce-message" role="alert" style="margin: 0;">
                <p style="margin: 0;"><a href="#" class="button"><?php echo esc_html__( 'Button', 'botiga-pro' ); ?></a><?php echo esc_html__( 'Messages like product added to cart, errors, etc.. will be rendered in this area.', 'botiga-pro' ); ?></p>
            </div>
        </div>
        <?php
    }
    $output = ob_get_clean();

    return sprintf(
        '<div class="%1$s botiga-tb-block botiga-tb-wc-notices"><style>%3$s</style>%2$s</div>',
        $blockId,
        $output,
        $custom_css
    );
}