<?php
/**
 * WooCommerce Single Product Additional Information
 * Templates Builder Block
 * 
 * @package Botiga_Pro
 */

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/block-editor/tutorials/block-tutorial/writing-your-first-block-type/
 */

function botiga_register_single_product_additional_information_block() {
    register_block_type_from_metadata( 
        BOTIGA_PRO_DIR . '/inc/modules/templates-builder/components/gutenberg/build/single-product-additional-information/block.json',
        array(
            'render_callback' => 'botiga_single_product_additional_information_block_callback'
        )
    );
}
add_action( 'init', 'botiga_register_single_product_additional_information_block', 11 );

/**
 * Render callback
 * 
 */
function botiga_single_product_additional_information_block_callback( $block_atts ) {
    $blockId    = $block_atts['blockId'];
    $custom_css = Botiga_Templates_Builder_Gutenberg_Helper::get_block_custom_css( $block_atts );
    $edit_mode  = is_singular( 'product' ) || is_singular( 'athemes_hf' ) ? false : true;

    ob_start();
    global $post;
    $post = Botiga_Templates_Builder_Gutenberg_Helper::get_first_post();
    setup_postdata( $post );

    if( ! $edit_mode ) {
        woocommerce_product_additional_information_tab();
    } else {
        global $product;
        wc_display_product_attributes( $product );
    }

    wp_reset_postdata();
    $output = ob_get_clean();

    // Placeholder content if output is empty
    if( $edit_mode && empty( $output ) ) {
        ob_start(); ?>

        <table class="woocommerce-product-attributes shop_attributes">
            <tbody>
                <tr class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_color">
                    <th class="woocommerce-product-attributes-item__label"><?php echo esc_html__( 'Attribute One', 'botiga-pro' ); ?></th>
                    <td class="woocommerce-product-attributes-item__value">
                        <p><?php echo esc_html__( 'Value One, Value Two', 'botiga-pro' ); ?></p>
                    </td>
                </tr>
                <tr class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_color">
                    <th class="woocommerce-product-attributes-item__label"><?php echo esc_html__( 'Attribute Two', 'botiga-pro' ); ?></th>
                    <td class="woocommerce-product-attributes-item__value">
                        <p><?php echo esc_html__( 'Value One, Value Two', 'botiga-pro' ); ?></p>
                    </td>
                </tr>
                <tr class="woocommerce-product-attributes-item woocommerce-product-attributes-item--attribute_pa_color">
                    <th class="woocommerce-product-attributes-item__label"><?php echo esc_html__( 'Attribute Three', 'botiga-pro' ); ?></th>
                    <td class="woocommerce-product-attributes-item__value">
                        <p><?php echo esc_html__( 'Value One, Value Two', 'botiga-pro' ); ?></p>
                    </td>
                </tr>
            </tbody>
        </table>

        <?php
        $output = ob_get_clean();
    }

    return sprintf(
        '<div class="%1$s botiga-tb-block botiga-tb-sp-additional-information"><style>%3$s</style>%2$s</div>',
        $blockId,
        $output,
        $custom_css
    );
}