<?php
/**
 * WooCommerce Single Product Add to Cart
 * Templates Builder Block
 * 
 * @package Botiga_Pro
 */

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/block-editor/tutorials/block-tutorial/writing-your-first-block-type/
 */
function botiga_register_single_product_add_to_cart_block() {
    register_block_type_from_metadata( 
        BOTIGA_PRO_DIR . '/inc/modules/templates-builder/components/gutenberg/build/single-product-add-to-cart/block.json',
        array(
            'render_callback' => 'botiga_single_product_add_to_cart_block_callback'
        )
    );
}
add_action( 'init', 'botiga_register_single_product_add_to_cart_block', 11 );

/**
 * Render callback
 * 
 */
function botiga_single_product_add_to_cart_block_callback( $block_atts ) {
    $blockId    = $block_atts['blockId'];
    $custom_css = Botiga_Templates_Builder_Gutenberg_Helper::get_block_custom_css( $block_atts );
    $edit_mode  = is_singular( 'product' ) || is_singular( 'athemes_hf' ) ? false : true;

    ob_start();
    echo '<div class="botiga-tb-el-block botiga-tb-el-sp-add-to-cart">';
        echo '<div class="product-gallery-summary" style="margin-bottom: 0;">';

            global $post;
            $post = Botiga_Templates_Builder_Gutenberg_Helper::get_first_post();
            setup_postdata( $post );

            if( ! $edit_mode ) {
                botiga_single_addtocart_wrapper_open();
                woocommerce_template_single_add_to_cart();
                botiga_single_addtocart_wrapper_close();
            } else {

                global $product;
                if( 'simple' === $product->get_type() ) {
                    woocommerce_simple_add_to_cart();
                } elseif( 'variable' === $product->get_type() ) {
                    woocommerce_variable_add_to_cart(); ?>

                    <div class="single-product" style="margin-top: 20px; width: 100%;">
                        <div class="variations_form cart">
                            <div class="single_variation_wrap">
                                <div class="woocommerce-variation single_variation" style="display: none;"></div>
                                <div class="woocommerce-variation-add-to-cart variations_button woocommerce-variation-add-to-cart-disabled">
                                    <div class="botiga-single-addtocart-wrapper">
                                        <div class="quantity" data-qty-initialized="true" style="max-width: 30%;">
                                            <a href="#" class="botiga-quantity-minus show" role="button">-</a>
                                            <input type="number" id="quantity_6388e1b162878" class="input-text qty text" step="1" min="1" max="3"
                                                name="quantity" value="1" title="Qty" size="4" placeholder="" inputmode="numeric"
                                                autocomplete="off">
                                            <a href="#" class="botiga-quantity-plus show" role="button">+</a>
                                        </div>

                                        <button type="submit"
                                            class="single_add_to_cart_button button alt disabled wc-variation-selection-needed"><?php echo esc_html__( 'Add To Cart', 'botiga-pro' ); ?></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php
                } elseif( 'grouped' === $product->get_type() ) {
                    woocommerce_grouped_add_to_cart();
                } elseif( 'external' === $product->get_type() ) {
                    woocommerce_external_add_to_cart();
                }

            }
            
            wp_reset_postdata();

            if( $edit_mode ) {
                echo '<script>';
                    echo 'botiga.qtyButton.init();';
                echo '</script>';
            }

        echo '</div>';
    echo '</div>';
    $output = ob_get_clean();

    return sprintf(
        '<div class="%1$s botiga-tb-block botiga-tb-sp-add-to-cart"><style>%3$s</style>%2$s</div>',
        $blockId,
        $output,
        $custom_css
    );
}