<?php
/**
 * WooCommerce Shop Archive Title
 * Templates Builder Block
 * 
 * @package Botiga_Pro
 */

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/block-editor/tutorials/block-tutorial/writing-your-first-block-type/
 */

function botiga_register_shop_archive_title_block() {
    register_block_type_from_metadata( 
        BOTIGA_PRO_DIR . '/inc/modules/templates-builder/components/gutenberg/build/shop-archive-title/block.json',
        array(
            'render_callback' => 'botiga_shop_archive_title_block_callback'
        )
    );
}
add_action( 'init', 'botiga_register_shop_archive_title_block', 11 );

/**
 * Render callback
 * 
 */
function botiga_shop_archive_title_block_callback( $block_atts ) {
    $blockId    = $block_atts['blockId'];
    $custom_css = Botiga_Templates_Builder_Gutenberg_Helper::get_block_custom_css( $block_atts );
    $edit_mode  = is_singular( 'product' ) || is_singular( 'athemes_hf' ) ? false : true;
    
    ob_start(); ?>
    <h1 class="woocommerce-products-header__title page-title has-text-color"><?php woocommerce_page_title(); ?></h1>
    <?php
    $output = ob_get_clean();

    return sprintf(
        '<div class="%1$s botiga-tb-block botiga-tb-wc-products"><style>%3$s</style>%2$s</div>',
        $blockId,
        $output,
        $custom_css
    );
}