/**
 * Helpers
 * 
 */

export function generateBlockCustomCss( blockId, blockCustomCss ) {
    let css_output = '';

	if ( blockCustomCss ) {
		for( let [key, value] of Object.entries( blockCustomCss ) ) {
			const selector = value.selector.replace( /{{WRAPPER}}/g, `.${ blockId }` );
			css_output += `${ selector } { ${ value.props } }`;
		}
	}

	if( document.querySelector(`#${ blockId }`) == null ) {
		const stylesheet = document.createElement( "style" )
		stylesheet.setAttribute( "id", blockId )
		document.head.appendChild( stylesheet )

		stylesheet.innerHTML = css_output;
	} else {
		document.querySelector(`#${ blockId }`).innerHTML = css_output;
	}
}