import { __ } from '@wordpress/i18n';
import { SelectControl, __experimentalBoxControl as BoxControl } from '@wordpress/components';
import { BotigaColorPicker } from '../index.js';
/**
 * Spacing Custom Component
 * 
 */
export default function BotigaBorder( props ) {
    const { attributes, setAttributes } = props;
    const { 
        customCss
    } = attributes;
    const idPrefix = props.idPrefix ? props.idPrefix : 'border';

    // Custom CSS Selector
    const customCssSelector = props.customCssSelector ? props.customCssSelector : '{{WRAPPER}}';

    // Defaults
    let defaults = {
        borderType: 'solid',
        borderWidth: {
            top: 1,
            left: 1,
            right: 1,
            bottom: 1
        },
        borderColor: '#CCC'
    }

    if( typeof props.defaults !== 'undefined' ) {
        defaults = props.defaults;
    }

    if( typeof customCss[ idPrefix + 'BorderType' ] !== 'undefined' ) {
        defaults.borderType = customCss[ idPrefix + 'BorderType' ].value;
    }

    if( typeof customCss[ idPrefix + 'BorderWidth' ] !== 'undefined' ) {
        defaults.borderWidth = customCss[ idPrefix + 'BorderWidth' ].value;
    }

    if( typeof customCss[ idPrefix + 'BorderColor' ] !== 'undefined' ) {
        defaults.borderColor = customCss[ idPrefix + 'BorderColor' ].value;
    }

    // Check if the props label contains '(hover)' string to display it properly
    let hoverLabel = false;
    if( typeof props.label !== 'undefined' && props.label.indexOf( '(hover)' ) !== -1 ) {
        hoverLabel = true;
    }

    return (
        <div>
            <span style={ { display: 'block', marginBottom: '0px' } }>{ props.label }</span>
            <SelectControl
                label={ false }
                value={ defaults.borderType }
                options={ [
                    { label: __( 'None', 'botiga-pro' ), value: 'none' },
                    { label: __( 'Solid', 'botiga-pro' ), value: 'solid' },
                    { label: __( 'Double', 'botiga-pro' ), value: 'double' },
                    { label: __( 'Dotted', 'botiga-pro' ), value: 'dotted' },
                    { label: __( 'Dashed', 'botiga-pro' ), value: 'dashed' },
                    { label: __( 'Groove', 'botiga-pro' ), value: 'groove' }
                ] }
                onChange={ ( value ) => { 
                    const css = {
                        [idPrefix + 'BorderType']: {
                            selector: customCssSelector,
                            props: `border-style: ${ value } !important;`,
                            value: value
                        }
                    };
                    setAttributes( { customCss: { ...customCss, ...css } } ) 
                } }
            />
            { 
                defaults.borderType != 'none' && (
                    <div className={ `botiga-dimensions-control` }>
                        <span style={ { display: 'block', marginBottom: '-18px' } }>
                            { ! hoverLabel ? __( 'Border Width', 'botiga-pro' ) : __( 'Border Width (hover)', 'botiga-pro' ) }
                        </span>
                        <BoxControl
                            label={ false }
                            values={ defaults.borderWidth }
                            isLinked={ false }
                            onChange={ ( val ) => {
                                const values = {
                                    top: typeof val.top !== 'undefined' ? val.top : defaults.borderWidth.top,
                                    right: typeof val.right !== 'undefined' ? val.right : defaults.borderWidth.right,
                                    bottom: typeof val.bottom !== 'undefined' ? val.bottom : defaults.borderWidth.bottom,
                                    left: typeof val.left !== 'undefined' ? val.left : defaults.borderWidth.left
                                }
                                const css = {
                                    [idPrefix + 'BorderWidth']: {
                                        selector: customCssSelector,
                                        props: `border-width: ${ values.top } ${ values.right } ${ values.bottom } ${ values.left } !important;`,
                                        value: val
                                    }
                                };

                                setAttributes( { customCss: { ...customCss, ...css } } )
                            } }
                        />
                        <BotigaColorPicker
                            label={ ! hoverLabel ? __( 'Border Color', 'botiga-pro' ) : __( 'Border Color (hover)', 'botiga-pro' ) }
                            idPrefix={ idPrefix }
                            withHover={ false }
                            defaults={{
                                color: defaults.borderColor,
                                colorHover: ''
                            }}
                            attributes={ attributes } 
                            setAttributes={ setAttributes } 
                            cssProp="border-color"
                            customCssSelector={ customCssSelector }
                        />
                    </div>
                )
            }
        </div>
    );
}
