<?php
/**
 * Load Elemetor components for templates
 *
 * @package Botiga
 */

if ( !class_exists( 'Botiga_Elementor_Custom_Widgets_Loader' ) ) :
	Class Botiga_Elementor_Custom_Widgets_Loader {

		/**
		 * Instance
		 */		
		private static $instance;

		/**
		 * Initiator
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self;
			}
			return self::$instance;
		}

		/**
		 * Constructor
		 */
		public function __construct() {
			if ( !class_exists( 'Elementor\Plugin' ) ) {
				return;
			}

			add_action( 'elementor/widgets/register', array( $this, 'load_widgets') );
			add_action( 'elementor/elements/categories_registered', array( $this, 'elementor_category' ) );
		}	

		/**
		 * Load all blocks
		 */
		public function load_widgets() {

			//WooCommerce
			if ( class_exists( 'WooCommerce' ) ) {

				// General
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/wc-breadcrumb.php' );
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/wc-notice.php' );
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/wc-products.php' );

				// Shop Archive
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/shop-archive-title.php' );
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/shop-archive-description.php' );
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/shop-archive-categories-links.php' );

				// Single Product
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/single-product-image.php' );
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/single-product-title.php' );
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/single-product-rating.php' );
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/single-product-short-description.php' );
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/single-product-price.php' );
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/single-product-add-to-cart.php' );
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/single-product-meta.php' );
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/single-product-sharing.php' );
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/single-product-tabs.php' );
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/single-product-description.php' );
				require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/woocommerce/single-product-additional-information.php' );
 			}

			//Misc
			require_once( BOTIGA_PRO_DIR . 'inc/modules/templates-builder/components/elementor/misc/acf-field.php' );
		}

		/**
		 * Register category
		 */
		function elementor_category( $elements_manager ) {

			if( class_exists( 'Woocommerce' ) ) {

				// Shop General
				$elements_manager->add_category( 
					'botiga-woocommerce',
					[
						'title' => __( 'Botiga WooCommerce', 'botiga-pro' ),
						'icon' => 'fa fa-plug',
					],
					2
				);

				// Shop Archive
				$elements_manager->add_category( 
					'botiga-woocommerce',
					[
						'title' => __( 'Botiga Shop Archive', 'botiga-pro' ),
						'icon' => 'fa fa-plug',
					],
					2
				);

				// Single Product
				$elements_manager->add_category( 
					'botiga-woocommerce',
					[
						'title' => __( 'Botiga Shop Single Product', 'botiga-pro' ),
						'icon' => 'fa fa-plug',
					],
					2
				);
			}
		}	
	}

	/**
	 * Initialize class
	 */
	Botiga_Elementor_Custom_Widgets_Loader::get_instance();

endif;