<?php
/**
 * Sticky Add to Cart
 * 
 * @package Botiga_Pro
 */
if ( class_exists( 'Botiga_Modules' ) && ! Botiga_Modules::is_module_active( 'sticky-add-to-cart' ) ) {
    return;
}

/**
 * Sticky add to cart customize options.
 */
if( ! function_exists( 'botiga_sticky_add_to_cart_options' ) ) {
    function botiga_sticky_add_to_cart_options( $wp_customize ) {
        require BOTIGA_PRO_DIR . 'inc/modules/sticky-add-to-cart/customizer/options.php';
    }
    add_action( 'customize_register', 'botiga_sticky_add_to_cart_options', 999 );
}

/**
 * Hooks 
 */
if( ! function_exists( 'botiga_sticky_add_to_cart_hooks' ) ) {
    function botiga_sticky_add_to_cart_hooks() {
        if ( ! is_product() ) {
            return;
        }

        $single_sticky_add_to_cart_position = get_theme_mod( 'single_sticky_add_to_cart_position', 'bottom' );

        if( $single_sticky_add_to_cart_position === 'bottom' ) {
            add_action( 'botiga_footer_before', 'botiga_single_sticky_add_to_cart' );
        } else {
            add_action( 'botiga_page_header', 'botiga_single_sticky_add_to_cart' );
        }
    }
    add_action( 'wp', 'botiga_sticky_add_to_cart_hooks' );
}

if( ! function_exists( 'botiga_single_sticky_add_to_cart' ) ) {
    function botiga_single_sticky_add_to_cart() {
        while ( have_posts() ) : the_post();
            require BOTIGA_PRO_DIR . 'inc/modules/sticky-add-to-cart/sticky-add-to-cart-content.php';
        endwhile;
    }
}

if( ! function_exists( 'botiga_sticky_add_to_cart_product_image' ) ) {
    function botiga_sticky_add_to_cart_product_image() {
        the_post_thumbnail( 'thumbnail' );
    }
}

if( ! function_exists( 'botiga_sticky_add_to_cart_product_title' ) ) {
    function botiga_sticky_add_to_cart_product_title() {
        the_title( '<h5 class="sticky-addtocart-title">', '</h5>' );
    }
}

if( ! function_exists( 'botiga_sticky_add_to_cart_product_addtocart' ) ) {
    function botiga_sticky_add_to_cart_product_addtocart() {
        global $product;
    
        switch ( $product->get_type() ) {
            case 'grouped':
                botiga_grouped_add_to_cart( $product, 'single_sticky_addtocart' );
                break;
            
            case 'variable':
                botiga_variable_add_to_cart( $product, 'single_sticky_addtocart' );
                break;
    
            case 'external':
                botiga_external_add_to_cart( $product, 'single_sticky_addtocart' );
                break;
            
            default:
                botiga_simple_add_to_cart( $product, 'single_sticky_addtocart' );
                break;
        }
    }
}