<?php 
/**
 * Sticky Add to Cart Customizer Options
 */
$controls_general = json_decode( $wp_customize->get_control( 'botiga_single_product_tabs' )->controls_general );

$new_controls_general = array(
  '#customize-control-accordion_single_product_sticky_add_to_cart',
  '#customize-control-single_sticky_add_to_cart_position',
  '#customize-control-single_sticky_add_to_cart_elements',
  '#customize-control-single_sticky_add_to_cart_elements_spacing',
  '#customize-control-single_sticky_add_to_cart_scroll_hide',
  '#customize-control-single_sticky_add_to_cart_device_visibility',
);

$wp_customize->get_control( 'botiga_single_product_tabs' )->controls_general = json_encode( array_merge( $controls_general, $new_controls_general ) );

$controls_design     = json_decode( $wp_customize->get_control( 'botiga_single_product_tabs' )->controls_design );
$new_controls_design = array(
  '#customize-control-accordion_single_product_styling_sticky_add_to_cart',
  '#customize-control-single_sticky_add_to_cart_style_color_border',
  '#customize-control-single_sticky_add_to_cart_style_color_background',
  '#customize-control-single_sticky_add_to_cart_style_color_content',
  '#customize-control-single_sticky_add_to_cart_style_color_title',
);
$wp_customize->get_control( 'botiga_single_product_tabs' )->controls_design = json_encode( array_merge( $controls_design, $new_controls_design ) );

// Sticky Add to Cart
$wp_customize->add_setting( 'accordion_single_product_sticky_add_to_cart', 
  array(
    'sanitize_callback' => 'esc_attr'
  )
);
$wp_customize->add_control(
  new Botiga_Accordion_Control(
    $wp_customize,
    'accordion_single_product_sticky_add_to_cart',
    array(
      'label'    => esc_html__( 'Sticky Add to Cart', 'botiga-pro' ),
      'section'  => 'botiga_section_single_product',
      'until'    => 'single_sticky_add_to_cart_device_visibility',
      'priority' => 113
    )
  )
);

$wp_customize->add_setting( 
  'single_sticky_add_to_cart_position',
  array(
    'default'           => 'bottom',
    'sanitize_callback' => 'botiga_sanitize_text'
  )
);
$wp_customize->add_control( 
  new Botiga_Radio_Buttons( 
    $wp_customize, 
    'single_sticky_add_to_cart_position',
    array(
      'label'      => esc_html__( 'Position', 'botiga-pro' ),
      'section'    => 'botiga_section_single_product',
      'choices'    => array(
          'top'    => esc_html__( 'Top', 'botiga-pro' ),
          'bottom' => esc_html__( 'Bottom', 'botiga-pro' ),
      ),
      'priority'   => 113
    )
  )
);

$wp_customize->add_setting( 
  'single_sticky_add_to_cart_elements', 
  array(
    'default' => array( 
      'botiga_sticky_add_to_cart_product_image', 
      'botiga_sticky_add_to_cart_product_title', 
      'botiga_single_product_price', 
      'botiga_sticky_add_to_cart_product_addtocart'
    ),
    'sanitize_callback' => 'botiga_sanitize_single_add_to_cart_elements'
  )
);
$wp_customize->add_control( 
  new \Kirki\Control\Sortable( 
    $wp_customize, 
    'single_sticky_add_to_cart_elements', 
    array(
      'label'   => esc_html__( 'Elements', 'botiga-pro' ),
      'section' => 'botiga_section_single_product',
      'choices' => array(
        'botiga_sticky_add_to_cart_product_image'     => esc_html__( 'Product Image', 'botiga-pro' ),
        'botiga_sticky_add_to_cart_product_title'     => esc_html__( 'Product Title', 'botiga-pro' ),
        'botiga_single_product_price'                 => esc_html__( 'Product Price', 'botiga-pro' ),
        'botiga_sticky_add_to_cart_product_addtocart' => esc_html__( 'Add to Cart', 'botiga-pro' )
      ),
      'priority' => 113
    )
  )
);

$wp_customize->add_setting( 
  'single_sticky_add_to_cart_elements_spacing', 
  array(
    'default'           => 35,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'botiga_sanitize_text',
  )
);      
$wp_customize->add_control( 
  new Botiga_Responsive_Slider( 
    $wp_customize, 
    'single_sticky_add_to_cart_elements_spacing',
    array(
      'label'          => esc_html__( 'Elements Spacing', 'botiga-pro' ),
      'section'        => 'botiga_section_single_product',
      'is_responsive'  => 0,
      'settings'       => array (
        'size_desktop' => 'single_sticky_add_to_cart_elements_spacing',
      ),
      'input_attrs'    => array (
        'min'          => 0,
        'max'          => 80,
        'step'         => 1
      ),
      'priority'       => 113
    )
  )
);

$wp_customize->add_setting(
  'single_sticky_add_to_cart_scroll_hide',
  array(
    'default'           => 0,
    'sanitize_callback' => 'botiga_sanitize_checkbox',
  )
);
$wp_customize->add_control(
  new Botiga_Toggle_Control(
    $wp_customize,
    'single_sticky_add_to_cart_scroll_hide',
    array(
      'label'    => esc_html__( 'Hide When Scroll to Top', 'botiga-pro' ),
      'section'  => 'botiga_section_single_product',
      'priority' => 113
    )
  )
);

$wp_customize->add_setting( 
  'single_sticky_add_to_cart_device_visibility', 
  array(
    'default'           => 'desktop-only',
    'sanitize_callback' => 'botiga_sanitize_select',
  )
);
$wp_customize->add_control( 
  'single_sticky_add_to_cart_device_visibility', 
  array(
    'type'    => 'select',
    'section' => 'botiga_section_single_product',
    'label'   => esc_html__( 'Visibility', 'botiga-pro' ),
    'choices' => array(
      'all'          => esc_html__( 'Show on all devices', 'botiga-pro' ),
      'desktop-only' => esc_html__( 'Desktop only', 'botiga-pro' ),
      'mobile-only'  => esc_html__( 'Mobile/tablet only', 'botiga-pro' ),
    ),
    'priority' => 113
  )
);

// Sticky Add To Cart
$wp_customize->add_setting( 'accordion_single_product_styling_sticky_add_to_cart', 
  array(
    'sanitize_callback' => 'esc_attr'
  )
);
$wp_customize->add_control(
  new Botiga_Accordion_Control(
    $wp_customize,
    'accordion_single_product_styling_sticky_add_to_cart',
    array(
      'label'    => esc_html__( 'Sticky Add to Cart', 'botiga-pro' ),
      'section'  => 'botiga_section_single_product',
      'until'    => 'single_sticky_add_to_cart_style_color_title',
      'priority' => 150
    )
  )
);

$wp_customize->add_setting(
  'single_sticky_add_to_cart_style_color_border',
  array(
    'default'           => '#e2e2e2',
    'sanitize_callback' => 'botiga_sanitize_hex_rgba',
    'transport'         => 'postMessage'
  )
);
$wp_customize->add_control(
  new Botiga_Alpha_Color(
    $wp_customize,
    'single_sticky_add_to_cart_style_color_border',
    array(
      'label'    => esc_html__( 'Border color', 'botiga-pro' ),
      'section'  => 'botiga_section_single_product',
      'priority' => 150
    )
  )
);

$wp_customize->add_setting(
  'single_sticky_add_to_cart_style_color_background',
  array(
    'default'           => '#FFF',
    'sanitize_callback' => 'botiga_sanitize_hex_rgba',
    'transport'         => 'postMessage'
  )
);
$wp_customize->add_control(
  new Botiga_Alpha_Color(
    $wp_customize,
    'single_sticky_add_to_cart_style_color_background',
    array(
      'label'    => esc_html__( 'Background color', 'botiga-pro' ),
      'section'  => 'botiga_section_single_product',
      'priority' => 150
    )
  )
);

$wp_customize->add_setting(
  'single_sticky_add_to_cart_style_color_content',
  array(
    'default'           => '#212121',
    'sanitize_callback' => 'botiga_sanitize_hex_rgba',
    'transport'         => 'postMessage'
  )
);
$wp_customize->add_control(
  new Botiga_Alpha_Color(
    $wp_customize,
    'single_sticky_add_to_cart_style_color_content',
    array(
      'label'    => esc_html__( 'Content color', 'botiga-pro' ),
      'section'  => 'botiga_section_single_product',
      'priority' => 150
    )
  )
);

$wp_customize->add_setting(
  'single_sticky_add_to_cart_style_color_title',
  array(
    'default'           => '#212121',
    'sanitize_callback' => 'botiga_sanitize_hex_rgba',
    'transport'         => 'postMessage'
  )
);
$wp_customize->add_control(
  new Botiga_Alpha_Color(
    $wp_customize,
    'single_sticky_add_to_cart_style_color_title',
    array(
      'label'    => esc_html__( 'Title color', 'botiga-pro' ),
      'section'  => 'botiga_section_single_product',
      'priority' => 150
    )
  )
);