<?php
/**
 * Single Product Size Chart
 * 
 * @package Botiga_Pro
 */
if ( class_exists( 'Botiga_Modules' ) && ! Botiga_Modules::is_module_active( 'size-chart' ) ) {
    return;
}

require BOTIGA_PRO_DIR . 'inc/modules/size-chart/size-chart-cpt-metabox.php';

/**
 * Size chart customize options.
 */
function botiga_size_chart_options( $wp_customize ) {
    require BOTIGA_PRO_DIR . 'inc/modules/size-chart/customizer/options.php';
}
add_action( 'customize_register', 'botiga_size_chart_options', 999 );

/**
 * Product size chart init.
 */
function botiga_single_product_size_chart_init() {

    add_action( 'wp_enqueue_scripts', 'botiga_size_chart_enqueue_scripts' );

    if ( ! is_singular( 'product' ) ) {
        return;
    }

    $_product = wc_get_product( get_the_ID() );

    if ( ! $_product ) {
        return;
    }

    if ( $_product->is_type( 'variable' ) ) {
        add_action( 'woocommerce_single_variation', 'botiga_single_product_size_chart', 15 );
    } else {
        add_action( 'woocommerce_' . $_product->get_type() . '_add_to_cart', 'botiga_single_product_size_chart' );
    }

}
add_action( 'wp', 'botiga_single_product_size_chart_init' );

/**
 * Quickview size chart support.
 */
add_action( 'botiga_quick_view_before_add_to_cart', 'botiga_single_product_size_chart' );

/**
 * Product size chart enqueue scripts.
 */
function botiga_size_chart_enqueue_scripts() {
    wp_enqueue_script( 'botiga-size-chart', BOTIGA_PRO_URI . 'assets/js/botiga-size-chart.min.js', array(), BOTIGA_PRO_VERSION, true );
}

/**
 * Product size chart.
 */
function botiga_single_product_size_chart( $product ) {

    if ( ! $product ) {
        global $product;
    }

    $size_chart_id = 0;

    // size chart by global
    $size_chart_id_global = get_theme_mod( 'single_size_chart_global', 0 );

    if ( ! empty( $size_chart_id_global ) ) {
        $size_chart_id = $size_chart_id_global;
    }

    // size chart by category
    $terms = wp_get_object_terms( $product->get_id(), 'product_cat' );

    foreach ( $terms as $term ) {
        $size_chart_term_id = get_term_meta( $term->term_id, 'size_chart_category', true );
        if ( ! empty( $size_chart_term_id ) ) {
            $size_chart_id = $size_chart_term_id;
        }
    }

    // size chart by product metabox
    $size_chart_id_metabox = get_post_meta( $product->get_id(), '_botiga_product_size_chart', true );

    if ( ! empty( $size_chart_id_metabox ) ) {
        $size_chart_id = $size_chart_id_metabox;
    }

    if ( empty( $size_chart_id ) ) {
        return;
    }

    $_post = get_post( $size_chart_id );

    if ( empty( $_post ) ) {
        return;
    }

    $title   = $_post->post_title;
    $content = $_post->post_content;
    $tabs    = get_post_meta( $_post->ID, '_cpt_botiga_size_chart_tabs', true );
    $button  = get_theme_mod( 'single_size_chart_button_title', esc_html__( 'Size Chart', 'botiga-pro' ) );

    if ( ! empty( $button ) && ( ! empty( $title ) || ! empty( $tabs ) || ! empty( $content ) ) ) {

        echo '<div class="botiga-product-size-chart">';

            echo '<div class="botiga-product-size-chart-button"><a href="#">'. botiga_pro_get_svg_icon( 'icon-size-chart' ) . esc_html( $button ) .'</a></div>';
        
            echo '<div class="botiga-product-size-chart-modal">';
        
                echo '<div class="botiga-product-size-chart-modal-inner">';
        
                    echo '<div class="botiga-product-size-chart-modal-close">'. botiga_pro_get_svg_icon( 'icon-cancel' ) .'</div>';
                    
                    if ( ! empty( $title ) ) {
                        echo '<div class="botiga-product-size-chart-modal-title">'. esc_html( $title ) .'</div>';
                    }
                    
                    if ( ! empty( $tabs ) && ! empty( array_filter( array_column( $tabs, 'name' ) ) ) ) {
                        echo '<div class="botiga-product-size-chart-modal-tabs">';
                            foreach ( $tabs as $tab_key => $tab ) {
                                $active = ( $tab_key === 0 ) ? ' active' : '';
                                if ( ! empty( $tab['name'] ) ) {
                                    echo '<div class="botiga-product-size-chart-modal-tab'. esc_attr( $active ) .'">'. esc_html( $tab['name'] ) .'</div>';
                                }
                            }
                        echo '</div>';
                    }

                    if ( ! empty( $tabs ) ) {
                        echo '<div class="botiga-product-size-chart-modal-tables">';
                            foreach ( $tabs as $tab_key => $tab ) {
                                if ( ! empty( $tab['sizes'] ) ) {
                                    $active = ( $tab_key === 0 ) ? ' active' : '';
                                    echo '<table class="botiga-product-size-chart-modal-table'. esc_attr( $active ) .'">';
                                        foreach ( $tab['sizes'] as $row_key => $rows ) {
                                            if ( $row_key === 0 ) {
                                                echo '<thead>';
                                                    echo '<tr>';
                                                    foreach ( $rows as $value ) {
                                                        echo '<th>'. esc_html( $value ) .'</th>';
                                                    }
                                                    echo '</tr>';
                                                echo '</thead>';
                                            }
                                            if ( $row_key === 0 ) {
                                                echo '<tbody>';
                                            }
                                            if ( $row_key > 0 ) {
                                                echo '<tr>';
                                                    foreach ( $rows as $value ) {
                                                        echo '<td>'. esc_html( $value ) .'</td>';
                                                    }
                                                echo '</tr>';
                                            }
                                            if ( ( count( $tab['sizes'] ) - 1 ) === $row_key ) {
                                                echo '</tbody>';
                                            }
                                        }
                                    echo '</table>';
                                }
                            }
                        echo '</div>';
                    }

                    if ( ! empty( $content ) ) {
                        echo '<div class="botiga-product-size-chart-modal-content">'. wp_kses_post( $content ) .'</div>';
                    }

                echo '</div>';

            echo '</div>';

        echo '</div>';
    
    }

}
