<?php
/**
 * Product size chart custom post type.
 */
if ( ! post_type_exists( 'size_chart' ) ) {

	$botiga_size_chart_args = array(
		'labels'              => array(
		  	'name'              => esc_html__( 'Size Chart', 'botiga-pro' ),
		),
		'public'              => true,
		'show_in_rest'        => true,
		'can_export'          => true,
		'exclude_from_search' => true,
		'has_archive'         => false,
		'show_in_nav_menus'   => false,
		'show_in_admin_bar'   => false,
		'show_in_menu'        => 'edit.php?post_type=product',
	);

	register_post_type( 'size_chart', $botiga_size_chart_args );

}

/**
 * Product size chart set admin menu position bottom.
 */
function botiga_size_chart_admin_menu_position() {

	global $submenu;

	$product_key    = 'edit.php?post_type=product';
	$size_chart_key = 'edit.php?post_type=size_chart';

	if ( ! empty( $submenu[ $product_key ] ) ) {
		foreach ( $submenu[ $product_key ] as $item_key => $item_value ) {
			if ( array_search( $size_chart_key, $item_value ) !== FALSE ) {
				unset( $submenu[ $product_key ][ $item_key ] );
				$submenu[ $product_key ][] = $item_value;
			}
		}
	}

}

add_action( 'admin_menu', 'botiga_size_chart_admin_menu_position' );

/**
 * Get size chart for customizer
 */
function botiga_get_size_charts() {

	$choices = array(			
		'' => esc_html__( 'Select a size chart', 'botiga-pro' )
	);

  	$posts = get_posts( array(
		'post_type'   => 'size_chart',
    	'post_status' => 'publish'
  	) );

  	if ( ! is_wp_error( $posts ) && ! empty( $posts ) ) {
		foreach ( $posts as $_post ) {
			$choices[ $_post->ID ] = $_post->post_title;
		}
  	}

	return $choices;

}

function botiga_size_chart_add_category_fields() {

	echo '<div class="form-field term-display-type-wrap">';
		echo '<label for="size_chart_category">'. esc_html__( 'Size Chart', 'botiga-pro' ) .'</label>';
		echo '<select id="size_chart_category" name="size_chart_category" class="postform">';
			$options = botiga_get_size_charts();
			foreach ( $options as $key => $option ) {
				echo '<option value="'. esc_attr( $key ) .'">'. esc_html( $option ) .'</option>';
			}
		echo '</select>';
	echo '</div>';

}
add_action( 'product_cat_add_form_fields', 'botiga_size_chart_add_category_fields' );

function botiga_size_chart_edit_category_fields( $term ) {

	$size_chart_category = get_term_meta( $term->term_id, 'size_chart_category', true );

	echo '<tr class="form-field term-display-type-wrap">';
		echo '<th scope="row" valign="top"><label>'. esc_html__( 'Size Chart', 'botiga-pro' ) .'</label></th>';
		echo '<td>';
			echo '<select id="size_chart_category" name="size_chart_category" class="postform">';
				$options = botiga_get_size_charts();
				foreach ( $options as $key => $option ) {
					echo '<option value="'. esc_attr( $key ) .'" '.selected( $key, $size_chart_category, false ).'>'. esc_html( $option ) .'</option>';
				}
			echo '</select>';
		echo '</td>';
	echo '</tr>';

}
add_action( 'product_cat_edit_form_fields', 'botiga_size_chart_edit_category_fields', 10 );

function botiga_size_chart_save_category_fields( $term_id, $tt_id, $taxonomy ) {

	if ( ! empty( $_POST['size_chart_category'] ) && $taxonomy === 'product_cat' ) {
		update_term_meta( $term_id, 'size_chart_category', sanitize_text_field( wp_unslash( $_POST['size_chart_category'] ) ) );
	}

}
add_action( 'created_term', 'botiga_size_chart_save_category_fields', 10, 3 );
add_action( 'edit_term', 'botiga_size_chart_save_category_fields', 10, 3 );

/**
 * Product size chart metabox.
 */
if ( class_exists( 'Botiga_Metabox' ) ) {

	class Botiga_Product_Size_Chart_Metabox extends Botiga_Metabox {

		public function __construct() {
			add_action( 'botiga_metabox_options', array( $this, 'add_product_size_chart_metabox_options' ) );
			add_filter( 'botiga_metabox_exclude_post_types_from_sidebar_section', array( $this, 'post_types_to_exclude_from_metabox_sidebar' ) );
			add_filter( 'botiga_metabox_exclude_post_types_from_general_section', array( $this, 'post_types_to_exclude_from_metabox_sidebar' ) );
		}

		public function post_types_to_exclude_from_metabox_sidebar( $post_types_arr ) {
            $post_types_arr[] = 'size_chart';

            return $post_types_arr;
        }

		public function add_product_size_chart_metabox_options() {

			$this->add_section( 'cpt_size_chart', array(
				'post_type' => array( 'size_chart' ),
			) );

			$this->add_field( '_cpt_botiga_size_chart_tabs', array(
				'section' => 'cpt_size_chart',
				'type'    => 'size-chart',
			) );

			$this->add_section( 'product_size_chart', array(
				'post_type' => array( 'product' ),
				'title'     => esc_html__( 'Size Chart', 'botiga-pro' ),
			) );

			$this->add_field( '_botiga_product_size_chart', array(
				'section' => 'product_size_chart',
				'type'    => 'size-chart-select',
				'title'   => esc_html__( 'Size Chart', 'botiga-pro' ),
			) );

		}

	}

	new Botiga_Product_Size_Chart_Metabox();

}