<?php
/**
 * Quantity Step Control
 * 
 * @package Botiga_Pro
 */
if ( class_exists( 'Botiga_Modules' ) && ! Botiga_Modules::is_module_active( 'quantity-step-control' ) ) {
    return;
}

/**
 * Quantity step control customize options.
 */
function botiga_quantity_step_control_options( $wp_customize ) {
    require BOTIGA_PRO_DIR . 'inc/modules/quantity-step-control/customizer/options.php';
}
add_action( 'customize_register', 'botiga_quantity_step_control_options', 999 );

/**
 * Quantity stock amount as float value.
 */
function botiga_quantity_stock_amount() {
    remove_filter( 'woocommerce_stock_amount', 'intval' );
    add_filter( 'woocommerce_stock_amount', 'floatval' );
}
add_action( 'init', 'botiga_quantity_stock_amount', 999 );

/**
 * Quantity input args.
 */
function botiga_quantity_input_args( $args, $product ) {

    $parent_id = $product->get_parent_id();

    if ( $parent_id > 0 ) {
        $product_id = $parent_id;
    } else {
        $product_id = $product->get_id();
    }

    // meta
    $qty_min_meta     = get_post_meta( $product_id, '_botiga_quantity_min', true );
    $qty_max_meta     = get_post_meta( $product_id, '_botiga_quantity_max', true );
    $qty_step_meta    = get_post_meta( $product_id, '_botiga_quantity_step', true );
    $qty_default_meta = get_post_meta( $product_id, '_botiga_quantity_default', true );

    // option
    $qty_min_opt     = get_theme_mod( 'shop_general_quantity_min', '' );
    $qty_max_opt     = get_theme_mod( 'shop_general_quantity_max', '' );
    $qty_step_opt    = get_theme_mod( 'shop_general_quantity_step', '' );
    $qty_default_opt = get_theme_mod( 'shop_general_quantity_default', '' );

    // maybe meta/option
    $qty_min     = ( $qty_min_meta !== '' ) ? $qty_min_meta : $qty_min_opt;
    $qty_max     = ( $qty_max_meta !== '' ) ? $qty_max_meta : $qty_max_opt;
    $qty_step    = ( $qty_step_meta !== '' ) ? $qty_step_meta : $qty_step_opt;
    $qty_default = ( $qty_default_meta !== '' ) ? $qty_default_meta : $qty_default_opt;

    // product max quantity
    if ( $qty_max === '' ) {
        $qty_max = wc_get_product( $product_id )->get_max_purchase_quantity();
    }

    if ( $qty_min !== '' ) {
        $args['min_value'] = $qty_min;
    } else if ( $qty_default !== '' ) {
        $args['min_value'] = $qty_default;
    }

    if ( $qty_max !== '' ) {
        $args['max_value'] = $qty_max;
    }

    if ( $qty_step !== '' ) {
        $args['step'] = $qty_step;
    }

    if ( $qty_default !== '' && $args['input_name'] === 'quantity' ) {
        $args['input_value'] = $qty_default;
    }

    if ( $args['min_value'] > $args['input_value'] ) {
        $args['input_value'] = $args['min_value'];
    }

    return $args;

}
add_filter( 'woocommerce_quantity_input_args', 'botiga_quantity_input_args', 10, 2 );

/**
 * Set quantity in loop add to cart
 */
function botiga_quantity_loop_add_to_cart_args( $args, $product ) {

    $qty_opt  = get_theme_mod( 'shop_general_quantity_default', '' );
    $qty_meta = get_post_meta( $product->get_id(), '_botiga_quantity_default', true );

    if ( $qty_opt !== '' ) {
        $args['quantity'] = $qty_opt;
    }

    if ( $qty_meta !== '' ) {
        $args['quantity'] = $qty_meta;
    }

    return $args;

}
add_filter( 'woocommerce_loop_add_to_cart_args', 'botiga_quantity_loop_add_to_cart_args', 10, 2 );

/**
 * Quantity available variation.
 */
function botiga_woocommerce_available_variation( $args, $product, $variation ) {

    $parent_id = $product->get_parent_id();

    if ( $parent_id > 0 ) {
        $product_id = $parent_id;
    } else {
        $product_id = $product->get_id();
    }

    // meta
    $qty_min_meta = get_post_meta( $product_id, '_botiga_quantity_min', true );
    $qty_max_meta = get_post_meta( $product_id, '_botiga_quantity_max', true );

    // option
    $qty_min_opt = get_theme_mod( 'shop_general_quantity_min', '' );
    $qty_max_opt = get_theme_mod( 'shop_general_quantity_max', '' );

    // maybe meta/option
    $qty_min = ( $qty_min_meta !== '' ) ? $qty_min_meta : $qty_min_opt;
    $qty_max = ( $qty_max_meta !== '' ) ? $qty_max_meta : $qty_max_opt;

    if ( $qty_min !== '' ) {
        $args['min_qty'] = $qty_min;
    }

    if ( $qty_max !== '' ) {
        $args['max_qty'] = $qty_max;
    }

    return $args;
}
add_filter( 'woocommerce_available_variation', 'botiga_woocommerce_available_variation', 10, 3 );

/**
 * Add quantity meta options.
 */
function botiga_quantity_add_meta_options() {

    echo '<div class="options_group">';

        $qty_min = get_theme_mod( 'shop_general_quantity_min', '' );
        $qty_min = ( $qty_min !== '' ) ? $qty_min : 0;

        woocommerce_wp_text_input(
            array( 
                'id'          => '_botiga_quantity_min', 
                'label'       => esc_html__( 'Quantity Min', 'botiga-pro' ),
                'placeholder' => esc_attr( $qty_min ),
                'desc_tip'    => 'true',
                'description' => sprintf( esc_html__( 'Set the min of changing the quantity: 0.1 0.5 100 (default: %s)', 'botiga-pro' ), $qty_min ),
            )
        );

    echo '</div>';

    echo '<div class="options_group">';

        $qty_max = get_theme_mod( 'shop_general_quantity_max', '' );
        $qty_max = ( $qty_max !== '' ) ? $qty_max : 'auto';

        woocommerce_wp_text_input(
            array( 
                'id'          => '_botiga_quantity_max', 
                'label'       => esc_html__( 'Quantity Max', 'botiga-pro' ),
                'placeholder' => esc_attr( $qty_max ),
                'desc_tip'    => 'true',
                'description' => sprintf( esc_html__( 'Set the max of changing the quantity: 0.1 0.5 100 or leave blank', 'botiga-pro' ), $qty_max ),
            )
        );

    echo '</div>';

    echo '<div class="options_group">';

        $qty_step = get_theme_mod( 'shop_general_quantity_step', '' );
        $qty_step = ( $qty_step !== '' ) ? $qty_step : 1;

        woocommerce_wp_text_input(
            array( 
                'id'          => '_botiga_quantity_step', 
                'label'       => esc_html__( 'Quantity Step', 'botiga-pro' ),
                'placeholder' => esc_attr( $qty_step ),
                'desc_tip'    => 'true',
                'description' => sprintf( esc_html__( 'Set the step of changing the quantity: 0.1 0.5 100 (default: %s)', 'botiga-pro' ), $qty_step ),
            )
        );

    echo '</div>';

    echo '<div class="options_group">';

        $qty_default = get_theme_mod( 'shop_general_quantity_default', '' );
        $qty_default = ( $qty_default !== '' ) ? $qty_default : 1;

        woocommerce_wp_text_input(
            array( 
                'id'          => '_botiga_quantity_default', 
                'label'       => esc_html__( 'Quantity Default', 'botiga-pro' ),
                'placeholder' => esc_attr( $qty_default ),
                'desc_tip'    => 'true',
                'description' => sprintf( esc_html__( 'Set the default quantity: 0.1 0.5 100 (default: %s)', 'botiga-pro' ), $qty_default ),
            )
        );

    echo '</div>';

}
add_action( 'woocommerce_product_options_inventory_product_data', 'botiga_quantity_add_meta_options' );

/**
 * Save quantity meta options.
 */
function botiga_quantity_save_meta_options( $post_id ) {

    $qty_min     = isset( $_POST[ '_botiga_quantity_min' ] ) ? sanitize_text_field( wp_unslash( $_POST[ '_botiga_quantity_min' ] ) ) : '';
    $qty_max     = isset( $_POST[ '_botiga_quantity_max' ] ) ? sanitize_text_field( wp_unslash( $_POST[ '_botiga_quantity_max' ] ) ) : '';
    $qty_step    = isset( $_POST[ '_botiga_quantity_step' ] ) ? sanitize_text_field( wp_unslash( $_POST[ '_botiga_quantity_step' ] ) ) : '';
    $qty_default = isset( $_POST[ '_botiga_quantity_default' ] ) ? sanitize_text_field( wp_unslash( $_POST[ '_botiga_quantity_default' ] ) ) : '';

    update_post_meta( $post_id, '_botiga_quantity_min', $qty_min );
    update_post_meta( $post_id, '_botiga_quantity_max', $qty_max );
    update_post_meta( $post_id, '_botiga_quantity_step', $qty_step );
    update_post_meta( $post_id, '_botiga_quantity_default', $qty_default );

}
add_action( 'woocommerce_process_product_meta', 'botiga_quantity_save_meta_options' );
