<?php 
/**
* Quantity Step Control Customizer Options
*/
$wp_customize->add_setting( 'shop_general_quantity_divider_2',
    array(
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control( new Botiga_Divider_Control( $wp_customize, 'shop_general_quantity_divider_2',
        array(
            'section'         => 'botiga_section_catalog_general',
            'priority'        => 25
        )
    )
);

$wp_customize->add_setting( 
    'shop_general_quantity_min', 
    array(
        'default'           => '',
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control( 
    'shop_general_quantity_min',
    array(
        'label'           => esc_html__( 'Quantity Min', 'botiga-pro' ),
        'type'            => 'number',
        'section'         => 'botiga_section_catalog_general',
        'input_attrs'     => array (
            'placeholder' => '0',
            'min'         => 0.1,
            'max'         => 100,
            'step'        => 0.1,
        ),
        'priority'        => 25
    )
);

$wp_customize->add_setting( 
    'shop_general_quantity_max', 
    array(
        'default'           => '',
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control( 
    'shop_general_quantity_max',
    array(
        'label'           => esc_html__( 'Quantity Max', 'botiga-pro' ),
        'type'            => 'number',
        'section'         => 'botiga_section_catalog_general',
        'input_attrs'     => array (
            'placeholder' => 'auto',
            'min'         => 0.1,
            'max'         => 100,
            'step'        => 0.1,
        ),
        'priority'        => 25
    )
);

$wp_customize->add_setting( 
    'shop_general_quantity_step', 
    array(
        'default'           => '',
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control( 
    'shop_general_quantity_step',
    array(
        'label'           => esc_html__( 'Quantity Step', 'botiga-pro' ),
        'type'            => 'number',
        'section'         => 'botiga_section_catalog_general',
        'input_attrs'     => array (
            'placeholder' => '1',
            'min'         => 0.1,
            'max'         => 100,
            'step'        => 0.1,
        ),
        'priority'        => 25
    )
);

$wp_customize->add_setting( 
    'shop_general_quantity_default', 
    array(
        'default'           => '',
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control( 
    'shop_general_quantity_default',
    array(
        'label'           => esc_html__( 'Quantity Default', 'botiga-pro' ),
        'type'            => 'number',
        'section'         => 'botiga_section_catalog_general',
        'input_attrs'     => array (
            'placeholder' => '1',
            'min'         => 0.1,
            'max'         => 100,
            'step'        => 0.1,
            'unit'        => '',
        ),
        'priority'        => 25
    )
);
