<?php 
/**
* Modal Popup Customizer Options
*/

$wp_customize->add_section(
    'botiga_section_modal_popup',
    array(
        'title'    => esc_html__( 'Modal Popup', 'botiga-pro'),
        'priority' => 185
    )
);

$wp_customize->add_setting( 'modal_popup_open_delay_desktop', array(
    'default'           => 3,
    'sanitize_callback' => 'absint'
) );            
$wp_customize->add_control( new Botiga_Responsive_Slider( $wp_customize, 'modal_popup_open_delay',
    array(
        'label'            => esc_html__( 'Display Modal Delay (seconds)', 'botiga-pro' ),
        'section'          => 'botiga_section_modal_popup',
        'is_responsive'    => 0,
        'settings'         => array (
            'size_desktop' => 'modal_popup_open_delay_desktop'
        ),
        'input_attrs'      => array (
            'min'          => 0,
            'max'          => 60,
            'unit'         => '',
        ),
        'priority'         => 10,
    )
) );

$wp_customize->add_setting( 'modal_popup_max_width_desktop', array(
    'default'           => 800,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
) );            
$wp_customize->add_setting( 'modal_popup_max_width_tablet', array(
    'default'           => 550,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
) );
$wp_customize->add_setting( 'modal_popup_max_width_mobile', array(
    'default'           => 300,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
) );            

$wp_customize->add_control( new Botiga_Responsive_Slider( $wp_customize, 'modal_popup_max_width',
    array(
        'label'            => esc_html__( 'Popup Max Width (px)', 'botiga-pro' ),
        'section'          => 'botiga_section_modal_popup',
        'is_responsive'    => 1,
        'settings'         => array (
            'size_desktop' => 'modal_popup_max_width_desktop',
            'size_tablet'  => 'modal_popup_max_width_tablet',
            'size_mobile'  => 'modal_popup_max_width_mobile',
        ),
        'input_attrs'      => array (
            'min'          => 0,
            'max'          => 1500
        ),
        'priority'         => 10,
    )
) );

$wp_customize->add_setting( 'modal_popup_content_padding', array(
    'default'           => 25,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
) );            

$wp_customize->add_control( new Botiga_Responsive_Slider( $wp_customize, 'modal_popup_content_padding',
    array(
        'label'            => esc_html__( 'Popup Content Padding (px)', 'botiga-pro' ),
        'section'          => 'botiga_section_modal_popup',
        'is_responsive'    => 0,
        'settings'         => array (
            'size_desktop' => 'modal_popup_content_padding',
        ),
        'input_attrs'      => array (
            'min'          => 0,
            'max'          => 100
        ),
        'priority'         => 10        
    )
) );

$wp_customize->add_setting( 
    'modal_popup_content_type',
    array(
        'sanitize_callback' => 'botiga_sanitize_select',
        'default' 			=> 'default'
    )
);
$wp_customize->add_control(
    'modal_popup_content_type',
    array(
        'type' 		=> 'select',
        'section' 	=> 'botiga_section_modal_popup',
        'label' 	=> esc_html__( 'Content Type', 'botiga-pro' ),
        'choices'   => apply_filters( 'botiga_customizer_modal_popup_content_type_options', array(
            'default'        => esc_html__( 'Default', 'botiga-pro' )
        ) ),
        'priority'  => 10
    ) 
);

$wp_customize->add_setting(
    'modal_popup_content_block',
    array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    new Botiga_Select2_Control(
        $wp_customize,
        'modal_popup_content_block',
        array(
            'label'           => esc_html__( 'Content Block', 'botiga-pro' ),
            'section'         => 'botiga_section_modal_popup',
            'select2_options' => '{ "selectionCssClass": "botiga-select2" }',
            'multiple'        => false,
            'posttype'        => true,
            'posttype_args'   => array(
                'post_type'      => 'athemes_hf',
                'posts_per_page' => -1
            ),
            'posttype_empty_first_value' => esc_html__( 'None', 'botiga-pro' ),
            'active_callback' => 'botiga_callback_modal_popup_content_type_is_content_block',
            'priority'        => 10
        )
    )
);

$wp_customize->add_setting(
    'modal_popup_layout',
    array(
        'default'           => 'style1',
        'sanitize_callback' => 'sanitize_key',
    )
);
$wp_customize->add_control(
    new Botiga_Radio_Images(
        $wp_customize,
        'modal_popup_layout',
        array(
            'label'   => esc_html__( 'Layout', 'botiga-pro' ),
            'section' => 'botiga_section_modal_popup',
            'cols'    => 2,
            'choices' => array(
                'style1'    => array(
                    'label' => esc_html__( 'Style 1', 'botiga-pro' ),
                    'url'   => '%s/assets/img/popup1.svg'
                ),
                'style2'    => array(
                    'label' => esc_html__( 'Style 2', 'botiga-pro' ),
                    'url'   => '%s/assets/img/popup2.svg'
                ),
                'style3'    => array(
                    'label' => esc_html__( 'Style 3', 'botiga-pro' ),
                    'url'   => '%s/assets/img/popup3.svg'
                ),
                'style4' => array(
                    'label' => esc_html__( 'Style 4', 'botiga-pro' ),
                    'url'   => '%s/assets/img/popup4.svg'
                )
            ),
            'active_callback' => 'botiga_callback_modal_popup_content_type_is_default',
            'priority' => 10
        )
    )
);

$wp_customize->add_setting( 
    'modal_popup_side_image',
    array(
        'default'           => '',
        'sanitize_callback' => 'absint',
    ) 
);
$wp_customize->add_control( 
    new WP_Customize_Media_Control( 
        $wp_customize, 
        'modal_popup_side_image',
        array(
            'label'           => __( 'Side Image', 'botiga-pro' ),
            'section'         => 'botiga_section_modal_popup',
            'mime_type'       => 'image',
            'active_callback' => 'botiga_callback_modal_popup_content_type_is_default',
            'priority'        => 10
        )
    )
);

$wp_customize->add_setting( 'modal_popup_side_image_max_width_desktop', array(
    'default'           => 40,
    'transport'         => 'postMessage',
    'sanitize_callback' => 'absint',
) );            
$wp_customize->add_control( new Botiga_Responsive_Slider( $wp_customize, 'modal_popup_side_image_max_width',
    array(
        'label'            => esc_html__( 'Side Image Max Width (%)', 'botiga-pro' ),
        'section'          => 'botiga_section_modal_popup',
        'is_responsive'    => 0,
        'settings'         => array (
            'size_desktop' => 'modal_popup_side_image_max_width_desktop'
        ),
        'input_attrs'      => array (
            'min'          => 0,
            'max'          => 100,
            'unit'         => '%',
        ),
        'active_callback'  => 'botiga_callback_modal_popup_not_layout_3',
        'priority'         => 10     
    )
) );

$wp_customize->add_setting(
    'modal_popup_side_image_link',
    array(
        'sanitize_callback' => 'botiga_sanitize_checkbox',
        'default'           => 0,
    )       
);
$wp_customize->add_control(
    new Botiga_Toggle_Control(
        $wp_customize,
        'modal_popup_side_image_link',
        array(
            'label'           => esc_html__( 'Side Image Link', 'botiga-pro' ),
            'section'         => 'botiga_section_modal_popup',
            'priority'        => 10,
            'active_callback' => 'botiga_callback_modal_popup',
        )
    )
);

$wp_customize->add_setting(
    'modal_popup_side_image_link_new_tab',
    array(
        'sanitize_callback' => 'botiga_sanitize_checkbox',
        'default'           => 0,
    )       
);
$wp_customize->add_control(
    new Botiga_Toggle_Control(
        $wp_customize,
        'modal_popup_side_image_link_new_tab',
        array(
            'label'           => esc_html__( 'Open link in a new tab', 'botiga-pro' ),
            'section'         => 'botiga_section_modal_popup',
            'priority'        => 10,
            'active_callback' => function(){ return get_theme_mod( 'modal_popup_side_image_link', 0 ) ? true : false; },
        )
    )
);

$wp_customize->add_setting(
    'modal_popup_side_image_link_url',
    array(
        'sanitize_callback' => 'botiga_sanitize_text',
        'default'           => '',
    )       
);
$wp_customize->add_control( 'modal_popup_side_image_link_url', array(
    'label'           => esc_html__( 'Link URL', 'botiga-pro' ),
    'type'            => 'text',
    'section'         => 'botiga_section_modal_popup',
    'active_callback' => function(){ return get_theme_mod( 'modal_popup_side_image_link', 0 ) ? true : false; },
    'priority'        => 10
) );

$wp_customize->add_setting(
    'modal_popup_content',
    array(
        'sanitize_callback' => 'wp_kses_post',
        'default'           => '',
    )       
);
$wp_customize->add_control(
    new Botiga_TinyMCE_Control(
        $wp_customize,
        'modal_popup_content',
        array(
            'label'           => esc_html__( 'Content', 'botiga-pro' ),
            'description'     => esc_html__( 'This field allow HTML and Shortcodes.', 'botiga-pro' ),
            'section'         => 'botiga_section_modal_popup',
            'input_attrs'     => array(
                'toolbar1'    => 'formatselect bold italic bullist numlist alignleft aligncenter alignright link'  
            ),
            'active_callback' => 'botiga_callback_modal_popup_content_type_is_default',
            'priority'        => 10
        )
    )
);

$wp_customize->add_setting( 'modal_popup_divider',
    array(
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control( 
    new Botiga_Divider_Control( 
        $wp_customize, 
        'modal_popup_divider',
        array(
            'section'  => 'botiga_section_modal_popup',
            'priority' => 10,
        )
    )
);

$wp_customize->add_setting(
    'modal_popup_cookie',
    array(
        'sanitize_callback' => 'botiga_sanitize_checkbox',
        'default'           => 1,
    )       
);
$wp_customize->add_control(
    new Botiga_Toggle_Control(
        $wp_customize,
        'modal_popup_cookie',
        array(
            'label'       => esc_html__( 'Enable Cookie', 'botiga-pro' ),
            'description' => esc_html__( 'Permanent close the popup during a defined period. It is when the user click in the close button. Disabling this option will make the popup always appear.', 'botiga-pro' ),
            'section'     => 'botiga_section_modal_popup',
            'priority'    => 10,
        )
    )
);

$wp_customize->add_setting(
    'modal_popup_cookie_name',
    array(
        'sanitize_callback' => 'botiga_sanitize_text',
        'default'           => 'botiga-show-modal-popup',
    )       
);
$wp_customize->add_control( 'modal_popup_cookie_name', array(
    'label'    => esc_html__( 'Cookie Name', 'botiga-pro' ),
    'type'     => 'text',
    'section'  => 'botiga_section_modal_popup',
    'priority' => 10,
) );

$wp_customize->add_setting( 'modal_popup_cookie_expiration_desktop', array(
    'default'           => 7,
    'sanitize_callback' => 'absint'
) );            
$wp_customize->add_control( new Botiga_Responsive_Slider( $wp_customize, 'modal_popup_cookie_expiration',
    array(
        'label'         => esc_html__( 'Cookie Expiration Time (days)', 'botiga-pro' ),
        'description'   => esc_html__( 'How many days the popup should stay hidden.', 'botiga-pro' ),
        'section'       => 'botiga_section_modal_popup',
        'is_responsive' => 0,
        'settings'      => array (
            'size_desktop' => 'modal_popup_cookie_expiration_desktop'
        ),
        'input_attrs' => array (
            'min'   => 0,
            'max'   => 60,
            'unit'  => '',
        ),
        'priority' => 10,
    )
) );

$wp_customize->add_setting( 'modal_popup_divider2',
    array(
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control( 
    new Botiga_Divider_Control( 
        $wp_customize, 
        'modal_popup_divider2',
        array(
            'section'  => 'botiga_section_modal_popup',
            'priority' => 10,
        )
    )
);

$wp_customize->add_setting( 
    'modal_popup_display_settings_title',
    array(
        'default'           => '',
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control( 
    new Botiga_Text_Control( 
        $wp_customize, 
        'modal_popup_display_settings_title',
        array(
            'label'    => esc_html__( 'Display Settings', 'botiga-pro' ),
            'section'  => 'botiga_section_modal_popup',
            'priority' => 10,
        )
    )
);

$wp_customize->add_setting( 
    'modal_popup_display', 
    array(
        'sanitize_callback' => 'botiga_sanitize_select',
        'default'           => 'all'
    ) 
);
$wp_customize->add_control( 
    'modal_popup_display', 
    array(
        'type'     => 'select',
        'section'  => 'botiga_section_modal_popup',
        'label'    => esc_html__( 'Show in', 'botiga-pro' ),
        'choices'  => array(
            'all'        => esc_html__( 'All pages', 'botiga-pro' ),
            'post-types' => esc_html__( 'Specific post types', 'botiga-pro' ),
            'posts-in'   => esc_html__( 'Specific page/post id\'s', 'botiga-pro' )
        ),
        'priority' => 10,
    ) 
);

$wp_customize->add_setting(
    'modal_popup_display_post_types',
    array(
        'sanitize_callback' => 'botiga_sanitize_text',
        'default'           => 'post,page,product',
    )       
);
$wp_customize->add_control( 'modal_popup_display_post_types', array(
    'label'       => esc_html__( 'Post Types', 'botiga-pro' ),
    'description' => esc_html__( 'Post types slug separated by comma. Eg: post,page,product', 'botiga-pro' ),
    'type'        => 'text',
    'section'     => 'botiga_section_modal_popup',
    'active_callback' => 'botiga_callback_modal_popup_display_post_types',
    'priority'    => 10
) );

$wp_customize->add_setting(
    'modal_popup_display_post_ids',
    array(
        'sanitize_callback' => 'botiga_sanitize_text',
        'default'           => '',
    )       
);
$wp_customize->add_control( 'modal_popup_display_post_ids', array(
    'label'           => esc_html__( 'Page/Post ID\'s', 'botiga-pro' ),
    'description'     => esc_html__( 'ID\'s separated by comma. Eg: 1,2,3,4,5', 'botiga-pro' ),
    'type'            => 'text',
    'section'         => 'botiga_section_modal_popup',
    'active_callback' => 'botiga_callback_modal_popup_display_posts_in',
    'priority'        => 10
) );

$wp_customize->add_setting(
    'modal_popup_display_on_search',
    array(
        'sanitize_callback' => 'botiga_sanitize_checkbox',
        'default'           => 1,
    )       
);
$wp_customize->add_control(
    new Botiga_Toggle_Control(
        $wp_customize,
        'modal_popup_display_on_search',
        array(
            'label'           => esc_html__( 'Show On Search Page', 'botiga-pro' ),
            'section'         => 'botiga_section_modal_popup',
            'active_callback' => 'botiga_callback_modal_popup_display_posts_and_types',
            'priority'        => 10
        )
    )
);

$wp_customize->add_setting(
    'modal_popup_display_on_404',
    array(
        'sanitize_callback' => 'botiga_sanitize_checkbox',
        'default'           => 1,
    )       
);
$wp_customize->add_control(
    new Botiga_Toggle_Control(
        $wp_customize,
        'modal_popup_display_on_404',
        array(
            'label'           => esc_html__( 'Show On 404 Page', 'botiga-pro' ),
            'section'         => 'botiga_section_modal_popup',
            'active_callback' => 'botiga_callback_modal_popup_display_posts_and_types',
            'priority'        => 10,
        )
    )
);

$wp_customize->add_setting( 'modal_popup_divider3',
    array(
        'sanitize_callback' => 'esc_attr'
    )
);
$wp_customize->add_control( 
    new Botiga_Divider_Control( 
        $wp_customize, 
        'modal_popup_divider3',
        array(
            'section'           => 'botiga_section_modal_popup',
            'check_white_label' => true,
            'priority'          => 10,
        )
    )
);

// Learn more about the feature
$wp_customize->add_setting(
    'modal_popup_info',
    array(
        'default'           => '',
        'sanitize_callback' => 'esc_attr',
    )
);
$wp_customize->add_control(
    new Botiga_Text_Control(
        $wp_customize,
        'modal_popup_info',
        array(
            'description'       => esc_html__( 'Learn more about this feature in our documentation by clicking on the below link.', 'botiga-pro' ),
            'link_title'        => esc_html__( 'Learn more', 'botiga-pro' ),
            'link'              => 'https://docs.athemes.com/article/420-modal-popup',
            'check_white_label' => true,
            'section'           => 'botiga_section_modal_popup',
            'priority'          => 10,
        )
    )
);
