<?php
/**
 * Product Linked Variations
 * 
 * @package Botiga_Pro
 */
if ( class_exists( 'Botiga_Modules' ) && ! Botiga_Modules::is_module_active( 'linked-variations' ) ) {
    return;
}

require BOTIGA_PRO_DIR . 'inc/modules/linked-variations/linked-variations-cpt-metabox.php';

/**
 * Linked variations customize options.
 */
function botiga_linked_variations_options( $wp_customize ) {
    require BOTIGA_PRO_DIR . 'inc/modules/linked-variations/customizer/options.php';
}
add_action( 'customize_register', 'botiga_linked_variations_options', 999 );

/**
 * Linked variations class
 */
class Botiga_Product_Linked_Variations{

    public $enable_tooltip = false;

    public $linked_products = array();

    public $linked_attributes = array();
    
    public function __construct() {

        add_action( 'wp', array( $this, 'botiga_single_product_linked_variations' ) );

        /**
         * Quickview linked variations support.
         */
        add_action( 'botiga_quick_view_before_add_to_cart', array( $this, 'botiga_single_product_linked_variations_html' ) );

    }

    /**
     * Product linked variations.
     */
    public function botiga_single_product_linked_variations() {
        
        if ( ! is_singular( 'product' ) ) {
            return;
        }
        
        $_product = wc_get_product( get_the_ID() );
        
        if ( ! $_product ) {
            return;
        }
        
        add_action( 'woocommerce_' . $_product->get_type() . '_add_to_cart', array( $this, 'botiga_single_product_linked_variations_html' ) );
        
    }

    /**
     * Product linked variations html.
     */
    public function botiga_single_product_linked_variations_html() {
        
        global $product;
        
        $collections = get_posts( array(
            'post_type'      => 'linked_variation',
            'post_status'    => 'publish',
            'posts_per_page' => 1,
            'fields'         => 'ids',
            'meta_query'     => array(
                array(
                    'key'     => '_botiga_linked_products',
                    'value'   => '(^|")'. $product->get_id() .'("|$)',
                    'compare' => 'REGEXP',
                ),
            ),
        ) );
            
        if ( empty( $collections ) ) {
            return;
        }
        
        $this->linked_products   = get_post_meta( $collections[0], '_botiga_linked_products', true );
        $this->linked_attributes = get_post_meta( $collections[0], '_botiga_linked_attributes', true );
        
        if ( empty( $this->linked_products ) && empty( $this->linked_attributes ) ) {
            return;
        }
        
        $product_attributes = array_keys( array_filter( $product->get_attributes(), 'wc_attributes_array_filter_visible' ) );
        
        if ( empty( $product_attributes ) ) {
            return;
        }
        
        $assigned_attributes = array();
        
        foreach ( $product_attributes as $attribute_name => $attribute ) {
            $assigned_attributes[ $attribute ] = wc_get_product_terms( $product->get_id(), $attribute, array( 'fields' => 'slugs' ) );
        }
        
        if ( empty( $assigned_attributes ) ) {
            return;
        }
        
        $this->enable_tooltip = get_theme_mod( 'single_product_linked_variations_tooltip', 0 );
        
        if ( ! empty( $this->linked_attributes ) ) {
            
            echo '<table class="botiga-linked-variations">';
            
            echo '<tbody>';
            
            foreach ( $this->linked_attributes as $linked_attribute_id ) {
                
                $attribute = wc_get_attribute( $linked_attribute_id );
                
                if ( empty( $attribute ) ) {
                    continue;
                }
                
                $terms = get_terms( $attribute->slug, array( 'hide_empty' => false ) );
                
                $current_terms = wp_get_post_terms( $product->get_id(), $attribute->slug, array( 'fields' => 'ids' ) );
                
                echo '<tr>';
                
                echo '<th><label for="'. esc_attr( $attribute->slug ) .'">'. esc_html( $attribute->name ) .'</label></th>';
                
                echo '<td>';
                
                echo '<div class="botiga-linked-variations-wrapper">';
                
                echo '<div class="botiga-linked-variations-type-'. esc_attr( $attribute->type ) .'">';
                
                foreach ( $terms as $term ) {
                    
                    if ( in_array( $term->term_id, $current_terms ) ) {
                        
                        $current_post = get_post( $product->get_id() );
                        
                        $this->get_linked_variation( $term, $attribute, $current_post, true );
                        
                    } else {
                        
                        $current_term_tax_query = array(
                            'taxonomy' => $term->taxonomy,
                            'terms'    => $term->slug,
                            'field'    => 'slug',
                        );
                        
                        $tax_query = array( 'relation' => 'AND' );
                        
                        $tax_query[] = $current_term_tax_query;
                        
                        foreach ( $assigned_attributes as $product_attribute_key => $product_attribute ) {
                            if ( ! in_array( wc_attribute_taxonomy_id_by_name( $product_attribute_key ), $this->linked_attributes ) ) {
                                continue;
                            }
                            if ( $term->taxonomy !== $product_attribute_key ) {
                                $tax_query[] = array(
                                    'taxonomy' => $product_attribute_key,
                                    'field'    => 'slug',
                                    'terms'    => $product_attribute,
                                );
                            }
                        }
                        
                        $linked_post = $this->get_linked_post( $tax_query );
                        
                        if ( ! empty( $linked_post ) ) {
                            
                            $this->get_linked_variation( $term, $attribute, $linked_post );
                            
                        } else {
                            
                            $tax_query = array();
                            
                            $tax_query[] = $current_term_tax_query;
                            
                            $linked_post = $this->get_linked_post( $tax_query );
                            
                            if ( ! empty( $linked_post ) ) {
                                
                                $this->get_linked_variation( $term, $attribute, $linked_post );
                                
                            }
                            
                        }
                        
                    }
                    
                }
                
                echo '</div>';
                
                echo '</div>';
                
                echo '</td>';
                
                echo '</tr>';
                
            }
            
            echo '</tbody>';
            
            echo '</table>';
            
        }
        
    }

    public function get_linked_post( $tax_query ) {

        $query_args = array(
            'post_type'      => 'product',
            'posts_per_page' => 1,
            'order'          => 'ASC',
            'post__in'       => $this->linked_products,
            'tax_query'      => $tax_query,
        );

        $linked_post = get_posts( $query_args );

        if ( ! empty( $linked_post ) && ! empty( $linked_post[0] ) ) {
            return $linked_post[0];
        }

        return false;

    }

    public function get_linked_variation( $term, $attribute, $linked_post, $active = false ) {

        $attribute_link   = get_the_permalink( $linked_post->ID );
        $attribute_active = ( $active ) ? ' active' : '';
    
        switch ( $attribute->type  ) {

            case 'select':
            case 'button':

                echo '<a href="'. esc_url( $attribute_link ) .'" class="botiga-linked-variation-item'. esc_attr( $attribute_active ) .'">'. esc_html( $term->name ) .'</a>';

            break;

            case 'color':

                $attribute_color = get_term_meta( $term->term_id, 'product_attribute_color', true );
                
                echo '<a href="'. esc_url( $attribute_link ) .'" class="botiga-linked-variation-item'. esc_attr( $attribute_active ) .'" style="background-color: '. esc_attr( $attribute_color ) .';">';
                    echo ( $this->enable_tooltip ) ? '<span class="botiga-linked-variation-tooltip">'. esc_html( $term->name ) .'</span>' : esc_html( $term->name );
                echo '</a>';

            break;

            case 'image':

                $image_src = wc_placeholder_img_src( 'thumbnail' );
                $image_id  = get_term_meta( $term->term_id, 'product_attribute_image', true );

                if ( ! empty( $image_id ) ) {
                    $image_data = wp_get_attachment_image_src( $image_id, 'thumbnail' );
                    $image_src  = ( is_array( $image_data ) && ! empty( $image_data[0] ) ) ? $image_data[0] : $image_src;
                }

                echo '<a href="'. esc_url( $attribute_link ) .'" class="botiga-linked-variation-item'. esc_attr( $attribute_active ) .'">';
                    echo '<img src="'. esc_url( $image_src ) .'" alt="'. esc_attr( $term->name ) .'" />';
                    echo ( $this->enable_tooltip ) ? '<span class="botiga-linked-variation-tooltip">'. esc_html( $term->name ) .'</span>' : esc_html( $term->name );
                echo '</a>';

            break;
            
            default:
            
            break;

        }

    }

}

new Botiga_Product_Linked_Variations();
