<?php
/**
 * Botiga Header Builder
 *
 * @package Botiga
 */

if( ! class_exists( 'Botiga_Modules' ) ) {
	return;
}

if ( ! Botiga_Modules::is_module_active( 'hf-builder' ) ) {
	return;
}

class Botiga_Pro_HF_Builder_Components {

	/**
     * Instance
     */		
    private static $instance;

    /**
     * Initiator
     */
    public static function get_instance() {
        if ( ! isset( self::$instance ) ) {
            self::$instance = new self;
        }
        return self::$instance;
    }

    /**
     * Constructor
     */
	public function __construct() {
		add_filter( 'botiga_header_builder_desktop_components', array( $this, 'header_components' ) );
		add_filter( 'botiga_header_builder_mobile_components', array( $this, 'header_components' ) );
		add_filter( 'botiga_header_builder_footer_components', array( $this, 'footer_components' ) );
		add_action( 'customize_register', array( $this, 'customizer_options' ), 1000 );
		add_filter( 'botiga_hf_builder_custom_css', array( $this, 'custom_css' ) );

		$this->options_to_move();
		$this->components_extra_functionality();
	}

	/**
	 * Extend HF Header Builder With Pro Components
	 * 
	 */
	public function header_components( $components ) {
		
		// Login Register.
		if( class_exists( 'Woocommerce' ) && class_exists( 'Botiga_Modules' ) && Botiga_Modules::is_module_active( 'login-popup' ) ) {
			$components[] = array(
				'id'    => 'login_register',
				'label' => esc_html__( 'Login/Register', 'botiga-pro' )
			);
		}

		// Button 2.
		$components[] = array(
			'id'    => 'button2',
			'label' => esc_html__( 'Button 2', 'botiga-pro' )
		);

		// HTML 2.
		$components[] = array(
			'id'    => 'html2',
			'label' => esc_html__( 'HTML 2', 'botiga-pro' )
		);

		// Shortcode.
		$components[] = array(
			'id'    => 'shortcode',
			'label' => esc_html__( 'Shortcode', 'botiga-pro' )
		);

		// WPML component.
        if ( class_exists( 'SitePress' ) ) {
            $components[] = array(
                'id'    => 'wpml_switcher',
                'label' => esc_html__( 'WPML Language Switcher', 'botiga-pro' )
            );
		}
        
        // Polylang component.
		if ( function_exists( 'pll_the_languages' ) ) {
            $components[] = array(
                'id'    => 'pll_switcher',
                'label' => esc_html__( 'Polylang Language Switcher', 'botiga-pro' )
            );
		}
	
		return $components;
	}

	/**
	 * Extend HF Footer Builder With Pro Components
	 * 
	 */
	public function footer_components( $components ) {

		// Footer Menu.
		$components[] = array(
			'id'    => 'footer_menu',
			'label' => esc_html__( 'Footer Menu', 'botiga-pro' )
		);

		// Button 2.
		$components[] = array(
			'id'    => 'button2',
			'label' => esc_html__( 'Button 2', 'botiga-pro' )
		);

		// HTML 2.
		$components[] = array(
			'id'    => 'html2',
			'label' => esc_html__( 'HTML 2', 'botiga-pro' )
		);

		// Shortcode.
		$components[] = array(
			'id'    => 'shortcode',
			'label' => esc_html__( 'Shortcode', 'botiga-pro' )
		);
	
		return $components;
	}
	
	/**
	 * Customizer Options
	 * 
	 */
	public function customizer_options( $wp_customize ) {
		
		// Header Components.
		if( class_exists( 'Woocommerce' ) && class_exists( 'Botiga_Modules' ) && Botiga_Modules::is_module_active( 'login-popup' ) ) {
            require 'components/header/login-register/customize-options.php';
        }

		require 'components/header/search/customize-options.php';
		require 'components/header/button-2/customize-options.php';
		require 'components/header/html-2/customize-options.php';
		require 'components/header/shortcode/customize-options.php';

		if ( function_exists( 'SitePress' ) ) {
            require 'components/header/wpml/customize-options.php';
        }

		if ( function_exists( 'pll_the_languages' ) ) {
            require 'components/header/polylang/customize-options.php';
        }

		// Footer Components.
		require 'components/footer/button-2/customize-options.php';
		require 'components/footer/html-2/customize-options.php';
		require 'components/footer/shortcode/customize-options.php';
		require 'components/footer/menu/customize-options.php';
		
	}

	/**
	 * Options To Move
	 * Move existing customizer settings.
	 * 
	 */
	public function options_to_move() {

		// Header
		require 'components/header/wc-icons/move-options.php';
		require 'components/header/search/move-options.php';

	}

	/**
     * Require wrapper
     * To require files with params
     */
    public function require_wrapper( $file_path, $params ) {
        extract( $params );
        require $file_path; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
    }

	/**
	 * Login Register Output Callback
	 * 
	 */
	public function login_register( $params ) {
		require 'components/header/login-register/login-register.php';
	}

	/**
     * Button 2
     */		
    public function button2( $params ) {
		if( ! isset( $params[ 'builder_type' ] ) ) {
			$params[ 'builder_type' ] = $params[0];
		}

        require 'components/'. $params[ 'builder_type' ] .'/button-2/button.php';
    }

    /**
     * HTML 2 Output Callback
     */		
    public function html2( $params ) {
		if( ! isset( $params[ 'builder_type' ] ) ) {
			$params[ 'builder_type' ] = $params[0];
		}

        require 'components/'. $params[ 'builder_type' ] .'/html-2/html.php';
    }

	/**
	 * Shortcode Output Callback
	 * 
	 */
    public function shortcode( $params ) {
		if( ! isset( $params[ 'builder_type' ] ) ) {
			$params[ 'builder_type' ] = $params[0];
		}
		
        require 'components/'. $params[ 'builder_type' ] .'/shortcode/shortcode.php';
    }

	/**
     * Polylang Language Switcher
     */
    public function pll_switcher( $params ) { 
        require 'components/header/polylang/polylang-switcher.php';
    }

	/**
     * WPML Language Switcher
     */
    public function wpml_switcher( $params ) { 
        require 'components/header/wpml/wpml-switcher.php';
    }

	/**
     * Footer Menu
     */
    public function footer_menu( $params ) {
        require 'components/footer/menu/menu.php';
    }

	/**
	 * Components Custom CSS
	 * 
	 */
	public function custom_css( $css ) {

		// Components.
		// Header
		require 'components/header/button-2/css.php';
		if( class_exists( 'Woocommerce' ) && class_exists( 'Botiga_Modules' ) && Botiga_Modules::is_module_active( 'login-popup' ) ) {
			require 'components/header/login-register/css.php';
		}
		require 'components/header/html-2/css.php';
		require 'components/header/shortcode/css.php';
		require 'components/header/search/css.php';
		if ( function_exists( 'pll_the_languages' ) ) {
			require 'components/header/polylang/css.php';
		}
		if ( class_exists( 'SitePress' ) ) {
			require 'components/header/wpml/css.php';
		}

		// Footer
		require 'components/footer/button-2/css.php';
		require 'components/footer/menu/css.php';
		require 'components/footer/html-2/css.php';
		require 'components/footer/shortcode/css.php';

		return $css;
	}

	/**
	 * Componenents Functionality
	 */
	public function components_extra_functionality() {
		require 'components/header/search/extra-functionality.php';
	}
}

Botiga_Pro_HF_Builder_Components::get_instance();