<?php
/**
 * Header/Footer Builder
 * WPML Components
 * 
 * @package Botiga_Pro
 */

/**
 * WPML Language Switcher
 * 
 */
$wp_customize->add_section(
    'botiga_section_hb_component__wpml_switcher',
    array(
        'title'      => esc_html__( 'Polylang Language Switcher', 'botiga-pro' ),
        'panel'      => 'botiga_panel_header'
    )
);

$wp_customize->add_setting( 'botiga_section_hb_component__wpml_switcher_configure',
	array(
		'default' 			=> '',
		'sanitize_callback' => 'esc_attr'
	)
);
$wp_customize->add_control( new Botiga_Text_Control( $wp_customize, 'botiga_section_hb_component__wpml_switcher_configure',
		array(
			'description' 	=> '<a class="footer-widget-area-link footer-widget-area-link-1" target="_blank" href="/wp-admin/admin.php?page=sitepress-multilingual-cms%2Fmenu%2Flanguages.php#wpml-language-switcher-shortcode-action">' . esc_html__( 'Configure language switcher', 'botiga-pro' ) . '<span class="dashicons dashicons-arrow-right-alt2"></span></a>',
			'section' 		=> 'botiga_section_hb_component__wpml_switcher'
		)
	)
);

// Visibility
$wp_customize->add_setting( 
    'botiga_section_hb_component__wpml_switcher_visibility_desktop',
    array(
        'default' 			=> 'visible',
        'sanitize_callback' => 'botiga_sanitize_text',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_setting( 
    'botiga_section_hb_component__wpml_switcher_visibility_tablet',
    array(
        'default' 			=> 'visible',
        'sanitize_callback' => 'botiga_sanitize_text',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_setting( 
    'botiga_section_hb_component__wpml_switcher_visibility_mobile',
    array(
        'default' 			=> 'visible',
        'sanitize_callback' => 'botiga_sanitize_text',
        'transport'         => 'postMessage'
    )
);
$wp_customize->add_control( 
    new Botiga_Radio_Buttons( 
        $wp_customize, 
        'botiga_section_hb_component__wpml_switcher_visibility',
        array(
            'label'         => esc_html__( 'Visibility', 'botiga' ),
            'section'       => 'botiga_section_hb_component__wpml_switcher',
            'is_responsive' => true,
            'settings' => array(
                'desktop' 		=> 'botiga_section_hb_component__wpml_switcher_visibility_desktop',
                'tablet' 		=> 'botiga_section_hb_component__wpml_switcher_visibility_tablet',
                'mobile' 		=> 'botiga_section_hb_component__wpml_switcher_visibility_mobile'
            ),
            'choices'       => array(
                'visible' => esc_html__( 'Visible', 'botiga' ),
                'hidden'  => esc_html__( 'Hidden', 'botiga' )
            ),
            'priority'      => 42
        )
    ) 
);

if( class_exists( 'Botiga_Dimensions_Control' ) ) {

    // Padding
    $wp_customize->add_setting( 
        'botiga_section_hb_component__wpml_switcher_padding_desktop',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'botiga_section_hb_component__wpml_switcher_padding_tablet',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'botiga_section_hb_component__wpml_switcher_padding_mobile',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'botiga_section_hb_component__wpml_switcher_padding',
            array(
                'label'           	=> __( 'Wrapper Padding', 'botiga' ),
                'section'         	=> 'botiga_section_hb_component__wpml_switcher',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => true,
                'settings'        	 => array(
                    'desktop' => 'botiga_section_hb_component__wpml_switcher_padding_desktop',
                    'tablet'  => 'botiga_section_hb_component__wpml_switcher_padding_tablet',
                    'mobile'  => 'botiga_section_hb_component__wpml_switcher_padding_mobile'
                ),
                'priority'	      	 => 72
            )
        )
    );

    // Margin
    $wp_customize->add_setting( 
        'botiga_section_hb_component__wpml_switcher_margin_desktop',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'botiga_section_hb_component__wpml_switcher_margin_tablet',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_setting( 
        'botiga_section_hb_component__wpml_switcher_margin_mobile',
        array(
            'default'           => '{ "unit": "px", "linked": false, "top": "", "right": "", "bottom": "", "left": "" }',
            'sanitize_callback' => 'botiga_sanitize_text',
            'transport'         => 'postMessage'
        ) 
    );
    $wp_customize->add_control( 
        new Botiga_Dimensions_Control( 
            $wp_customize, 
            'botiga_section_hb_component__wpml_switcher_margin',
            array(
                'label'           	=> __( 'Wrapper Margin', 'botiga' ),
                'section'         	=> 'botiga_section_hb_component__wpml_switcher',
                'sides'             => array(
                    'top'    => true,
                    'right'  => true,
                    'bottom' => true,
                    'left'   => true
                ),
                'units'              => array( 'px', '%', 'rem', 'em', 'vw', 'vh' ),
                'link_values_toggle' => true,
                'is_responsive'   	 => true,
                'settings'        	 => array(
                    'desktop' => 'botiga_section_hb_component__wpml_switcher_margin_desktop',
                    'tablet'  => 'botiga_section_hb_component__wpml_switcher_margin_tablet',
                    'mobile'  => 'botiga_section_hb_component__wpml_switcher_margin_mobile'
                ),
                'priority'	      	 => 72
            )
        )
    );

}